/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.MutatatorOperation;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class MutatorOperationImpl
extends OperationImpl
implements MutatatorOperation {
    public static final int OVERHEAD = 32;
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND");
    private final Mutator mutator;
    private final String key;
    private final int amount;

    public MutatorOperationImpl(Mutator m, String k, int amt, OperationCallback c) {
        super(c);
        this.mutator = m;
        this.key = k;
        this.amount = amt;
    }

    public void handleLine(String line) {
        this.getLogger().debug("Result:  %s", line);
        OperationStatus found = null;
        found = line.equals("NOT_FOUND") ? NOT_FOUND : new OperationStatus(true, line);
        this.getCallback().receivedStatus(found);
        this.transitionState(OperationState.COMPLETE);
    }

    public void initialize() {
        int size = KeyUtil.getKeyBytes(this.key).length + 32;
        ByteBuffer b = ByteBuffer.allocate(size);
        this.setArguments(b, this.mutator.name(), this.key, this.amount);
        b.flip();
        this.setBuffer(b);
    }

    protected void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }
}

