/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class DeleteOperationImpl
extends OperationImpl
implements DeleteOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus DELETED = new OperationStatus(true, "DELETED");
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND");
    private final String key;
    private final int when;

    public DeleteOperationImpl(String k, int w, OperationCallback cb) {
        super(cb);
        this.key = k;
        this.when = w;
    }

    public void handleLine(String line) {
        this.getLogger().debug("Delete of %s returned %s", this.key, line);
        this.getCallback().receivedStatus(this.matchStatus(line, DELETED, NOT_FOUND));
        this.transitionState(OperationState.COMPLETE);
    }

    public void initialize() {
        ByteBuffer b = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + 32);
        this.setArguments(b, "delete", this.key, this.when);
        b.flip();
        this.setBuffer(b);
    }
}

