/*
 * Decompiled with CFR 0.152.
 */
package net.spy.log;

import net.spy.log.Level;
import net.spy.log.LineGettingOutputStream;
import net.spy.log.Logger;
import net.spy.log.LoggerFactory;

public class LoggingOutputStream
extends LineGettingOutputStream {
    private Logger logger = null;
    private Level level = null;
    private static final String STDOUT_NAME = "stdout";
    private static final String STDERR_NAME = "stderr";

    public LoggingOutputStream(String name) {
        this(name, Level.INFO);
    }

    public LoggingOutputStream(String name, Level lv) {
        this.logger = LoggerFactory.getLogger(name);
        this.level = lv;
    }

    protected void processChunk(String chunk) {
        this.logger.log(this.level, chunk);
    }

    public static void redefineOutputs() {
        LoggingOutputStream out = new LoggingOutputStream(STDOUT_NAME);
        LoggingOutputStream err = new LoggingOutputStream(STDERR_NAME, Level.ERROR);
        out.setOut();
        err.setErr();
    }
}

