/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.spy.SpyObject;
import net.spy.concurrent.TrackingScheduledExecutor;
import net.spy.db.Savable;
import net.spy.db.SaveContext;
import net.spy.db.Saver;
import net.spy.util.SpyConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionPipeline
extends SpyObject {
    private static final String POOL_NAME = "TransactionPipeline Worker";
    private static final int DEFAULT_POOL_SIZE = 1;
    private static final int MIN_TRANS_AGE = 500;
    private ScheduledExecutorService pool = null;

    public TransactionPipeline(ThreadGroup tg, String name) {
        String n = POOL_NAME + (name == null ? "" : " " + name);
        this.pool = new TrackingScheduledExecutor(1, tg, n);
    }

    public TransactionPipeline() {
        this(null, null);
    }

    public synchronized void shutdown() {
        assert (this.pool != null) : "Trying to double-shutdown a pool.";
        this.pool.shutdown();
        this.pool = null;
    }

    public ScheduledFuture<?> addTransaction(Savable s, SpyConfig conf, SaveContext ctx) {
        return this.pool.schedule(new PipelineTask(s, conf, ctx), 500L, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> addTransaction(Savable s, SpyConfig conf) {
        return this.addTransaction(s, conf, null);
    }

    static final class PipelineTask
    extends SpyObject
    implements Runnable {
        private Throwable originalStack = new Exception("Original request");
        private Savable toSave = null;
        private SpyConfig conf = null;
        private SaveContext context = null;

        PipelineTask(Savable s, SpyConfig cnf, SaveContext ctx) {
            this.originalStack.fillInStackTrace();
            this.toSave = s;
            this.conf = cnf;
            this.context = ctx;
        }

        public void run() {
            try {
                new Saver(this.conf, this.context).save(this.toSave);
            }
            catch (Throwable t) {
                this.getLogger().error((Object)"Error saving asynchronous transaction", t);
                this.getLogger().error((Object)"Sent from", this.originalStack);
            }
        }
    }
}

