/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.spy.SpyObject;
import net.spy.db.ConnectionSource;
import net.spy.util.SpyConfig;

public class JDBCConnectionSource
extends SpyObject
implements ConnectionSource {
    public Connection getConnection(SpyConfig conf) throws SQLException {
        SpyConfig c = new SpyConfig();
        c.put("user", conf.get("dbUser"));
        c.put("password", conf.get("dbPass"));
        String driver = conf.get("dbDriverName");
        String source = conf.get("dbSource");
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Couldn't load DB driver:  " + cnfe);
        }
        Connection conn = DriverManager.getConnection(source, c);
        return conn;
    }

    public void returnConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().warn((Object)"Problem closing connection", e);
        }
    }
}

