/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import net.spy.SpyObject;
import net.spy.db.DBNull;
import net.spy.db.DBUtil;

public abstract class GenericPreparedStatementStub
extends SpyObject {
    private String query = null;
    private Object[] args = null;
    private int[] types = null;

    public GenericPreparedStatementStub(String q) {
        this.query = q;
        int ntokens = DBUtil.countQs(this.query);
        this.args = new Object[ntokens];
        this.types = new int[ntokens];
    }

    protected String getQuery() {
        return this.query;
    }

    protected Object[] getArgs() {
        return this.args;
    }

    protected Object[] getApplicableArgs() {
        Object[] rv = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            rv[i] = this.args[i] instanceof DBNull ? null : this.args[i];
        }
        return rv;
    }

    protected int[] getTypes() {
        return this.types;
    }

    private void setArg(int index, Object what, int type) throws SQLException {
        if (--index < 0) {
            throw new SQLException("Illegal index, they start at 1, G");
        }
        if (index >= this.args.length) {
            throw new SQLException("Illegal index, this statement takes a maximum of " + this.args.length + " arguments.");
        }
        this.args[index] = what;
        this.types[index] = type;
    }

    public void setBoolean(int a0, boolean a1) throws SQLException {
        this.setArg(a0, a1, -7);
    }

    public void setDate(int a0, Date a1) throws SQLException {
        this.setArg(a0, a1, 91);
    }

    public void setDouble(int a0, double a1) throws SQLException {
        this.setArg(a0, new Double(a1), 8);
    }

    public void setFloat(int a0, float a1) throws SQLException {
        this.setArg(a0, new Float(a1), 6);
    }

    public void setInt(int a0, int a1) throws SQLException {
        this.setArg(a0, new Integer(a1), 4);
    }

    public void setLong(int a0, long a1) throws SQLException {
        this.setArg(a0, new Long(a1), -5);
    }

    public void setNull(int a0, int a1) throws SQLException {
        this.setArg(a0, new DBNull(a1), 0);
    }

    public void setBigDecimal(int a0, BigDecimal a1) throws SQLException {
        this.setArg(a0, a1, 3);
    }

    public void setObject(int a0, Object a1) throws SQLException {
        this.setArg(a0, a1, 1111);
    }

    public void setShort(int a0, short a1) throws SQLException {
        this.setArg(a0, new Integer(a1), -6);
    }

    public void setString(int a0, String a1) throws SQLException {
        this.setArg(a0, a1, 12);
    }

    public void setTime(int a0, Time a1) throws SQLException {
        this.setArg(a0, a1, 92);
    }

    public void setTimestamp(int a0, Timestamp a1) throws SQLException {
        this.setArg(a0, a1, 93);
    }

    public void close() throws SQLException {
        this.query = null;
        this.args = null;
        this.types = null;
    }
}

