/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import net.spy.db.DBCP;
import net.spy.db.DBNull;
import net.spy.db.DBSPLike;
import net.spy.db.SpyCacheDB;
import net.spy.db.TypeNames;
import net.spy.util.SpyConfig;
import net.spy.util.SpyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBSP
extends SpyCacheDB
implements DBSPLike {
    private static final int TOSTRING_SB_SIZE = 128;
    private static final int BD_SCALE = 4;
    private LinkedHashMap<String, Parameter> parameters = null;
    private LinkedHashMap<String, Argument> arguments = null;
    private String spname = null;
    private long cachetime = 0L;
    private int timeout = 0;
    private int maxRows = 0;
    private boolean debug = false;
    private String query = null;
    private PreparedStatement pst = null;
    private String cursorName = null;

    public DBSP(SpyConfig conf) throws SQLException {
        super(conf);
        this.initsp();
    }

    public DBSP(Connection conn) throws SQLException {
        super(conn);
        this.initsp();
    }

    private void initsp() {
        this.parameters = new LinkedHashMap();
        this.arguments = new LinkedHashMap();
        this.debug = this.getLogger().isDebugEnabled();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.prepare();
        ResultSet rs = null;
        rs = this.pst.executeQuery();
        if (this.debug && !(this instanceof DBCP)) {
            this.getLogger().debug("Returned: ");
            ResultSetMetaData rsmd = rs.getMetaData();
            String cols = "";
            for (int x = 1; x <= rsmd.getColumnCount(); ++x) {
                if (x > 1) {
                    cols = cols + ", ";
                }
                cols = cols + rsmd.getColumnName(x) + "=" + rsmd.getColumnTypeName(x);
            }
            this.getLogger().debug(cols);
        }
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int rv = 0;
        this.prepare();
        rv = this.pst.executeUpdate();
        return rv;
    }

    public ResultSet nextResults() throws SQLException {
        ResultSet rs = null;
        this.pst.getUpdateCount();
        if (this.pst.getMoreResults()) {
            rs = this.pst.getResultSet();
        }
        return rs;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.pst.getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.cursorName = name;
        if (this.pst != null) {
            this.getLogger().debug("Setting the pst cursor name to %s", this.cursorName);
            this.pst.setCursorName(this.cursorName);
        }
    }

    @Override
    public void setCacheTime(long time) {
        this.cachetime = time;
    }

    @Override
    public long getCacheTime() {
        return this.cachetime;
    }

    protected void setPreparedStatement(PreparedStatement to) throws SQLException {
        if (this.pst != null) {
            this.getLogger().warn("Discarding old prepared statement %s", this.pst);
        }
        this.pst = to;
        if (this.debug) {
            this.getLogger().debug("Setting timeout to: %s", this.timeout);
        }
        this.pst.setQueryTimeout(this.timeout);
        this.pst.setMaxRows(this.maxRows);
        if (this.cursorName != null) {
            this.getLogger().debug("Setting the pst cursor name to %s", this.cursorName);
        }
    }

    protected PreparedStatement getPreparedStatement() {
        return this.pst;
    }

    protected void addParameter(Parameter p) throws SQLException {
        if (this.parameters.containsKey(p.getName())) {
            throw new SQLException("parameter ``" + p + "'' already provided.");
        }
        this.parameters.put(p.getName(), p);
    }

    protected void setRequired(String name, int type) throws SQLException {
        this.addParameter(new Parameter(1, type, name));
    }

    protected void setOptional(String name, int type) throws SQLException {
        this.addParameter(new Parameter(2, type, name));
    }

    protected void setOutput(String name, int type) throws SQLException {
        this.addParameter(new Parameter(2, type, name));
        this.setArg(name, "", type);
    }

    protected void setArg(String which, Object what, int type) throws SQLException {
        this.arguments.put(which, new Argument(type, which, what));
    }

    public Collection<Argument> getArguments() {
        ArrayList<Argument> al = new ArrayList<Argument>(this.arguments.size());
        for (Parameter p : this.getParameters()) {
            Argument arg = this.arguments.get(p.getName());
            if (arg == null && p.getParamType() == 1) {
                throw new NullPointerException("Missing argument for " + p);
            }
            if (arg == null) continue;
            al.add(arg);
        }
        return Collections.unmodifiableList(al);
    }

    protected Collection<Parameter> getParams() {
        return this.parameters.values();
    }

    protected void resetArgs() {
        this.arguments.clear();
    }

    @Override
    public void setQueryTimeout(int to) {
        this.timeout = to;
    }

    public void setMaxRows(int to) {
        this.maxRows = to;
    }

    @Override
    public int getQueryTimeout() {
        return this.timeout;
    }

    protected void setSPName(String to) {
        this.spname = to;
    }

    protected String getSPName() {
        return this.spname;
    }

    protected void checkArgs() throws SQLException {
        if (this.debug) {
            this.getLogger().debug("Checking");
            this.getLogger().debug("Parameters:  %s", this.parameters);
            this.getLogger().debug("Args:  %s", this.arguments);
        }
        for (Argument arg : this.arguments.values()) {
            Parameter p = this.parameters.get(arg.getName());
            if (p == null) {
                throw new SQLException("Invalid argument " + arg);
            }
            int ptype = p.getJavaType();
            int atype = arg.getJavaType();
            if (atype == 0) {
                atype = ((DBNull)arg.getValue()).getType();
            }
            if (ptype == atype) continue;
            throw new SQLException("Invalid type for arg " + arg + " type was " + atype + " (" + TypeNames.getTypeName(atype) + ")" + " should be " + ptype + " (" + TypeNames.getTypeName(ptype) + ")");
        }
        for (Parameter p : this.parameters.values()) {
            if (p.getParamType() != 1 || this.arguments.get(p.getName()) != null) continue;
            throw new SQLException("Required argument " + p + " missing.");
        }
    }

    protected void prepare() throws SQLException {
        if (this.pst == null) {
            this.checkArgs();
            StringBuilder querySb = new StringBuilder(128);
            querySb.append("exec ");
            querySb.append(this.spname);
            querySb.append(" ");
            int nargs = 0;
            for (Argument arg : this.getArguments()) {
                querySb.append("\t@");
                querySb.append(arg.getName());
                querySb.append("=?,\n");
                ++nargs;
            }
            if (nargs > 0) {
                querySb.delete(querySb.length() - 2, querySb.length());
            }
            String tmpQuery = querySb.toString().trim();
            if (this.debug) {
                this.getLogger().debug("Query: %s", tmpQuery);
            }
            this.setQuery(tmpQuery);
        }
        this.applyArgs(this.getArguments());
    }

    protected void setDebug(boolean db) {
        this.debug = db;
    }

    protected boolean isDebugEnabled() {
        return this.debug;
    }

    protected void setQuery(String to) throws SQLException {
        this.query = to;
        PreparedStatement tmpPst = null;
        tmpPst = this.getCacheTime() > 0L ? this.prepareStatement(to, this.getCacheTime()) : this.prepareStatement(to);
        this.setPreparedStatement(tmpPst);
    }

    protected String getQuery() {
        return this.query;
    }

    protected void applyArgs(Collection<Argument> v) throws SQLException {
        int i = 1;
        for (Argument arg : v) {
            Object o = arg.getValue();
            int type = arg.getJavaType();
            if (this.isDebugEnabled()) {
                this.getLogger().debug("arg[%d] = %s", i, arg);
            }
            try {
                switch (type) {
                    case -7: {
                        this.pst.setBoolean(i, (Boolean)o);
                        break;
                    }
                    case 91: {
                        this.pst.setDate(i, (Date)o);
                        break;
                    }
                    case 8: {
                        this.pst.setDouble(i, ((Number)o).doubleValue());
                        break;
                    }
                    case 6: {
                        this.pst.setFloat(i, ((Number)o).floatValue());
                        break;
                    }
                    case 4: {
                        this.pst.setInt(i, ((Number)o).intValue());
                        break;
                    }
                    case -5: {
                        this.pst.setLong(i, ((Number)o).longValue());
                        break;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bd = ((BigDecimal)o).setScale(4, 4);
                        this.pst.setBigDecimal(i, bd);
                        break;
                    }
                    case -6: 
                    case 5: {
                        this.pst.setShort(i, (short)((Number)o).intValue());
                        break;
                    }
                    case 0: {
                        this.pst.setNull(i, ((DBNull)o).getType());
                        break;
                    }
                    case 1111: {
                        this.pst.setObject(i, o);
                        break;
                    }
                    case 12: 
                    case 2005: {
                        this.pst.setString(i, (String)o);
                        break;
                    }
                    case 92: {
                        this.pst.setTime(i, (Time)o);
                        break;
                    }
                    case 93: {
                        this.pst.setTimestamp(i, (Timestamp)o);
                        break;
                    }
                    default: {
                        throw new SQLException("Whoops, type " + TypeNames.getTypeName(type) + "(" + type + ")" + " seems to have been overlooked.");
                    }
                }
            }
            catch (SQLException se) {
                this.getLogger().warn("SQLException while applying %s in prepared statement for type %s %s", arg, TypeNames.getTypeName(type), o, se);
                throw se;
            }
            catch (Exception applyException) {
                String msg = "Problem setting " + arg + " in prepared statement for type " + TypeNames.getTypeName(type) + " " + String.valueOf(o) + " : " + applyException;
                this.getLogger().warn((Object)msg, applyException);
                SQLException se = new SQLException(msg);
                se.initCause(applyException);
                throw se;
            }
            ++i;
        }
    }

    public void set(String which, BigDecimal a1) throws SQLException {
        this.setArg(which, a1, 3);
    }

    public void set(String which, boolean a1) throws SQLException {
        this.setArg(which, a1, -7);
    }

    public void set(String which, Boolean b) throws SQLException {
        this.setArg(which, b, -7);
    }

    public void set(String which, Date a1) throws SQLException {
        this.setArg(which, a1, 91);
    }

    public void set(String which, double a1) throws SQLException {
        this.setArg(which, new Double(a1), 8);
    }

    public void set(String which, float a1) throws SQLException {
        this.setArg(which, new Float(a1), 6);
    }

    public void set(String which, Float a1) throws SQLException {
        this.setArg(which, a1, 6);
    }

    public void set(String which, Integer a1) throws SQLException {
        if (this.debug) {
            this.getLogger().debug("Adding Integer->INTEGER for " + which);
        }
        this.setArg(which, a1, 4);
    }

    public void set(String which, int a1) throws SQLException {
        this.setArg(which, new Integer(a1), 4);
    }

    public void set(String which, long a1) throws SQLException {
        this.setArg(which, new Long(a1), -5);
    }

    protected void setNull(String which, int a1) throws SQLException {
        this.setArg(which, new Integer(a1), 0);
    }

    public void setTinyInt(String which, short a1) throws SQLException {
        this.setArg(which, new Integer(a1), 5);
    }

    public void set(String which, byte b) throws SQLException {
        this.setArg(which, new Integer(b), -6);
    }

    public void set(String which, Byte b) throws SQLException {
        this.setArg(which, new Integer(b.intValue()), -6);
    }

    public void set(String which, short a1) throws SQLException {
        this.setArg(which, new Integer(a1), 5);
    }

    public void set(String which, Short s) throws SQLException {
        this.setArg(which, new Integer(s.intValue()), 5);
    }

    public void set(String which, String a1) throws SQLException {
        if (this.debug) {
            this.getLogger().debug("Adding String->VARCHAR for " + which);
        }
        this.setArg(which, a1, 12);
    }

    public void set(String which, Time a1) throws SQLException {
        this.setArg(which, a1, 92);
    }

    public void set(String which, Timestamp a1) throws SQLException {
        this.setArg(which, a1, 93);
    }

    public void set(String which, Object obj) throws SQLException {
        this.setArg(which, obj, 1111);
    }

    public Collection<Parameter> getParameters() {
        return this.parameters.values();
    }

    public Collection<Parameter> getParameters(int type) {
        ArrayList<Parameter> al = new ArrayList<Parameter>();
        for (Parameter p : this.getParameters()) {
            if (p.getJavaType() != type) continue;
            al.add(p);
        }
        return al;
    }

    public int getType(String var) {
        int rv = -1;
        Parameter p = this.parameters.get(var);
        if (p != null) {
            rv = p.getJavaType();
        }
        return rv;
    }

    public int getParameterType(String var) {
        int rv = -1;
        Parameter p = this.parameters.get(var);
        if (p != null) {
            rv = p.getParamType();
        }
        return rv;
    }

    @Override
    public void close() {
        if (this.pst != null) {
            try {
                this.pst.close();
            }
            catch (SQLException e) {
                this.getLogger().warn((Object)"Problem closing prepared statement", e);
            }
            this.pst = null;
        }
        super.close();
    }

    public void setCoerced(String var, String value) throws SQLException {
        int type = this.getType(var);
        if (value == null) {
            DBNull n = new DBNull(type);
            this.set(var, n);
        } else {
            switch (type) {
                case -7: {
                    this.set(var, (boolean)SpyUtil.getBoolean(value));
                    break;
                }
                case 8: {
                    this.set(var, new Double(value));
                    break;
                }
                case 6: {
                    this.set(var, new Float(value).floatValue());
                    break;
                }
                case 4: {
                    this.set(var, Integer.parseInt(value));
                    break;
                }
                case -5: {
                    this.set(var, Long.parseLong(value));
                    break;
                }
                case 2: 
                case 3: {
                    this.set(var, new BigDecimal(value));
                    break;
                }
                case -6: 
                case 5: {
                    this.set(var, (short)Integer.parseInt(value));
                    break;
                }
                case 1111: {
                    this.set(var, value);
                    break;
                }
                case 12: {
                    this.set(var, value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    throw new SQLException("Date types not currently handled");
                }
                default: {
                    throw new SQLException("No known type for " + var + ", you sure it's valid?.");
                }
            }
        }
    }

    public class Argument
    extends NamedObject {
        private int javaType;
        private Object value;

        public Argument(int jType, String name, Object v) {
            super(name);
            this.javaType = 0;
            this.value = null;
            this.javaType = jType;
            this.value = v;
        }

        public int getJavaType() {
            return this.value == null ? 0 : this.javaType;
        }

        public Object getValue() {
            Object rv = this.value;
            if (rv == null) {
                rv = new DBNull(this.javaType);
            }
            return rv;
        }

        public String toString() {
            String valName;
            valName = this.value == null ? (valName = "NULL") : "'" + this.value + "'";
            return "{Arg: type=" + this.javaType + "(" + TypeNames.getTypeName(this.javaType) + "), name=" + this.getName() + ", value=" + valName + "}";
        }
    }

    public class Parameter
    extends NamedObject {
        public static final int REQUIRED = 1;
        public static final int OPTIONAL = 2;
        public static final int OUTPUT = 2;
        private int paramType;
        private int javaType;

        public Parameter(int pType, int jType, String name) {
            super(name);
            this.paramType = 0;
            this.javaType = 0;
            this.paramType = pType;
            this.javaType = jType;
            this.validateParamType();
        }

        private void validateParamType() {
            if (this.paramType != 1 && this.paramType != 2 && this.paramType != 2) {
                throw new IllegalArgumentException(this.paramType + " is not a valid " + this.getClass().getName() + " type.");
            }
        }

        public int getParamType() {
            return this.paramType;
        }

        public int getJavaType() {
            return this.javaType;
        }

        public String toString() {
            return "{Param: type=" + TypeNames.getTypeName(this.javaType) + "(" + this.javaType + "), name=" + this.getName() + ", required=" + this.paramType + "}";
        }
    }

    public abstract class NamedObject {
        private String name = null;

        protected NamedObject(String nm) {
            if (nm == null) {
                throw new NullPointerException("name not given");
            }
            this.name = nm;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "{" + this.getClass().getName() + " " + this.getName() + "}";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            boolean rv = false;
            if (o instanceof NamedObject) {
                NamedObject no = (NamedObject)o;
                rv = this.name.equals(no.name);
            }
            return rv;
        }
    }
}

