/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import net.spy.db.DBNull;
import net.spy.db.DBSP;
import net.spy.db.TypeNames;
import net.spy.util.SpyConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCP
extends DBSP {
    private int argumentIndex = 1;

    public DBCP(SpyConfig conf) throws SQLException {
        super(conf);
    }

    public DBCP(Connection conn) throws SQLException {
        super(conn);
    }

    public boolean execute() throws SQLException {
        boolean rv = true;
        this.prepare();
        rv = this.getPreparedStatement().execute();
        return rv;
    }

    @Override
    protected void setOptional(String name, int type) throws SQLException {
        throw new SQLException("Optional Parameters Not Supported on DBCP");
    }

    public CallableStatement getCallableStatement() {
        CallableStatement rc = (CallableStatement)this.getPreparedStatement();
        return rc;
    }

    @Override
    protected void applyArgs(Collection<DBSP.Argument> v) throws SQLException {
        PreparedStatement pst = this.getPreparedStatement();
        if (pst == null) {
            if (this.getCacheTime() > 0L) {
                throw new IllegalArgumentException("Not Implemented!!");
            }
            pst = this.prepareCall(this.getQuery());
        }
        for (DBSP.Argument arg : this.getArguments()) {
            int i = this.argumentIndex;
            Object o = arg.getValue();
            int type = arg.getJavaType();
            try {
                if (this.getParameterType(arg.getName()) == 2) {
                    this.getLogger().debug("OUT -> Setting column %s(%d) type %s", arg, i, type);
                    CallableStatement cst = (CallableStatement)pst;
                    cst.registerOutParameter(i, type);
                } else {
                    this.getLogger().debug("IN -> Setting column %s(%d) type %s", arg, i, type);
                    switch (type) {
                        case -7: {
                            pst.setBoolean(i, (Boolean)o);
                            break;
                        }
                        case 91: {
                            pst.setDate(i, (Date)o);
                            break;
                        }
                        case 8: {
                            pst.setDouble(i, (Double)o);
                            break;
                        }
                        case 6: {
                            pst.setFloat(i, ((Float)o).floatValue());
                            break;
                        }
                        case 4: {
                            pst.setInt(i, (Integer)o);
                            break;
                        }
                        case -5: {
                            pst.setLong(i, (Long)o);
                            break;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal bd = ((BigDecimal)o).setScale(4, 4);
                            pst.setBigDecimal(i, bd);
                            break;
                        }
                        case -6: 
                        case 5: {
                            pst.setShort(i, (short)((Integer)o).intValue());
                            break;
                        }
                        case 0: {
                            pst.setNull(i, ((DBNull)o).getType());
                            break;
                        }
                        case 1111: {
                            pst.setObject(i, o);
                            break;
                        }
                        case 12: {
                            pst.setString(i, (String)o);
                            break;
                        }
                        case 92: {
                            pst.setTime(i, (Time)o);
                            break;
                        }
                        case 93: {
                            pst.setTimestamp(i, (Timestamp)o);
                            break;
                        }
                        default: {
                            throw new SQLException("Whoops, type " + TypeNames.getTypeName(type) + "(" + type + ")" + " seems to have been overlooked.");
                        }
                    }
                }
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception applyException) {
                this.getLogger().warn((Object)"Exception while applying", applyException);
                String msg = "Problem setting " + arg + " in prepared statement for type " + TypeNames.getTypeName(type) + " " + o.toString() + " : " + applyException;
                throw new SQLException(msg);
            }
            ++this.argumentIndex;
        }
    }

    @Override
    protected void prepare() throws SQLException {
        PreparedStatement pst;
        this.checkArgs();
        StringBuilder querySb = new StringBuilder(256);
        querySb.append("{call ");
        querySb.append(this.getSPName());
        querySb.append(" (");
        int nargs = this.getArguments().size();
        for (int i = 0; i < nargs; ++i) {
            querySb.append("?,");
        }
        if (nargs > 0) {
            querySb.deleteCharAt(querySb.length() - 1);
        }
        querySb.append(")}");
        String query = querySb.toString().trim();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Query: " + query);
        }
        if ((pst = this.getPreparedStatement()) == null) {
            if (this.getCacheTime() > 0L) {
                throw new IllegalArgumentException("Not Implemented");
            }
            pst = this.prepareCall(query);
            this.setPreparedStatement(pst);
        }
        this.setQuery(query);
        this.applyArgs(this.getArguments());
    }
}

