/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.util.Collection;
import net.spy.SpyObject;
import net.spy.db.Savable;
import net.spy.db.SaveContext;
import net.spy.db.TransactionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSavable
extends SpyObject
implements Savable,
TransactionListener {
    private boolean asIsNew = false;
    private boolean asIsModified = false;
    private Exception createdHere = new UnsavedObjectWarning();

    protected AbstractSavable() {
        this.createdHere.fillInStackTrace();
        this.asIsNew = true;
    }

    @Override
    public boolean isNew() {
        return this.asIsNew;
    }

    @Override
    public boolean isModified() {
        return this.asIsModified;
    }

    protected void setNew(boolean to) {
        this.asIsNew = to;
    }

    protected void setModified(boolean to) {
        this.asIsModified = to;
    }

    public void modify() {
        this.setModified(true);
    }

    @Override
    public Collection<? extends Savable> getPreSavables(SaveContext context) {
        return null;
    }

    @Override
    public Collection<? extends Savable> getPostSavables(SaveContext context) {
        return null;
    }

    @Override
    public void transactionCommited() {
        this.setNew(false);
        this.setModified(false);
    }

    protected void finalize() throws Throwable {
        if (this.isNew() || this.isModified()) {
            this.getLogger().debug((Object)"Finalizing and object that needs saving", this.createdHere);
        }
    }

    private static final class UnsavedObjectWarning
    extends Exception {
        public UnsavedObjectWarning() {
            super("CREATED HERE");
        }
    }
}

