/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cron;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import net.spy.cron.JobQueue;
import net.spy.cron.MainJob;
import net.spy.cron.TimeIncrement;
import net.spy.util.CloseUtil;
import net.spy.util.SpyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileJobQueue
extends JobQueue<MainJob> {
    private ClassLoader classLoader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileJobQueue(ClassLoader cl, File f) throws IOException {
        this.classLoader = cl;
        FileReader fr = null;
        try {
            fr = new FileReader(f);
            this.initQueue(fr);
        }
        catch (Throwable throwable) {
            CloseUtil.close(fr);
            throw throwable;
        }
        CloseUtil.close(fr);
    }

    public FileJobQueue(File f) throws IOException {
        this(null, f);
        this.classLoader = this.getClass().getClassLoader();
    }

    public FileJobQueue(ClassLoader cl, Reader r) throws IOException {
        this.classLoader = cl;
        this.initQueue(r);
    }

    public FileJobQueue(Reader r) throws IOException {
        this(null, r);
        this.classLoader = this.getClass().getClassLoader();
    }

    private void initQueue(Reader r) throws IOException {
        LineNumberReader lnr = new LineNumberReader(r);
        String line = lnr.readLine();
        while (line != null) {
            try {
                MainJob j = this.parseJob(line, lnr.getLineNumber());
                if (j != null) {
                    this.addJob(j);
                    this.getLogger().info("Added job %s to start at %s", j, j.getStartTime());
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Error parsing line %s", lnr.getLineNumber(), e);
            }
            line = lnr.readLine();
        }
        lnr.close();
    }

    private MainJob parseJob(String line, int lineNum) throws ParseException {
        MainJob rv = null;
        if ((line = line.trim()).startsWith("#")) {
            return null;
        }
        if (line.length() < 1) {
            return null;
        }
        String[] stuff = SpyUtil.split(" ", line);
        String dateS = stuff[0];
        String fieldS = stuff[1];
        String incrS = stuff[2];
        String classS = stuff[3];
        String[] args = new String[stuff.length - 4];
        if (stuff.length > 4) {
            System.arraycopy(stuff, 4, args, 0, args.length);
        }
        Date startDate = this.parseStartDate(dateS);
        int cf = this.parseCalendarField(fieldS);
        if (cf >= 0) {
            TimeIncrement ti = new TimeIncrement();
            ti.setField(cf);
            ti.setIncrement(Integer.parseInt(incrS));
            startDate = ti.nextDate(startDate);
            rv = new MainJob(this.classLoader, classS, args, startDate, ti);
        } else if (startDate.getTime() < System.currentTimeMillis()) {
            this.getLogger().warn("At job on line %d is in the past.", lineNum);
        } else {
            rv = new MainJob(this.classLoader, classS, args, startDate);
        }
        return rv;
    }

    private Date parseStartDate(String in) throws ParseException {
        Date rv = null;
        long now = System.currentTimeMillis();
        if (in.equals("NOW")) {
            rv = new Date(now + 60000L);
        } else if (in.equals("NEXT")) {
            rv = new Date(now - 1L);
        } else {
            for (TimeFormat tf : this.getFormats()) {
                SimpleDateFormat sdf = tf.getFormat();
                try {
                    Date d = sdf.parse(in);
                    rv = this.copyDate(d, tf.getFields());
                }
                catch (ParseException e) {}
            }
        }
        if (rv == null) {
            throw new ParseException("Could not parse date:  " + in, 0);
        }
        return rv;
    }

    private Collection<TimeFormat> getFormats() {
        ArrayList<TimeFormat> rv = new ArrayList<TimeFormat>();
        int[] f1 = new int[]{1, 2, 5, 11, 12, 13};
        rv.add(new TimeFormat("yyyyMMdd-HHmmss", f1));
        int[] f2 = new int[]{11, 12, 13};
        rv.add(new TimeFormat("HHmmss", f2));
        int[] f3 = new int[]{12, 13};
        rv.add(new TimeFormat("mmss", f3));
        return rv;
    }

    private Date copyDate(Date d, int[] fields) {
        Calendar oldc = Calendar.getInstance();
        oldc.setTime(d);
        Calendar newc = Calendar.getInstance();
        newc.set(14, 0);
        for (int i = 0; i < fields.length; ++i) {
            newc.set(fields[i], oldc.get(fields[i]));
        }
        return newc.getTime();
    }

    private int parseCalendarField(String fieldName) {
        int rv = -1;
        if (fieldName.equals("YEAR")) {
            rv = 1;
        } else if (fieldName.equals("MONTH")) {
            rv = 2;
        } else if (fieldName.equals("DAY")) {
            rv = 5;
        } else if (fieldName.equals("HOUR")) {
            rv = 10;
        } else if (fieldName.equals("MINUTE")) {
            rv = 12;
        } else if (fieldName.equals("SECOND")) {
            rv = 13;
        } else if (fieldName.equals("ONCE")) {
            rv = -1;
        } else {
            this.getLogger().warn(fieldName + " is not a valid Calendar field.");
        }
        return rv;
    }

    static final class TimeFormat {
        private SimpleDateFormat format = null;
        private int[] fields = null;

        TimeFormat(String fmt, int[] flds) {
            this.format = new SimpleDateFormat(fmt);
            this.format.setLenient(false);
            this.fields = flds;
        }

        SimpleDateFormat getFormat() {
            return this.format;
        }

        int[] getFields() {
            return this.fields;
        }
    }
}

