/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cron;

import java.io.File;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import net.spy.SpyThread;
import net.spy.concurrent.ThreadPool;
import net.spy.cron.FileJobQueue;
import net.spy.cron.Job;
import net.spy.cron.JobQueue;
import net.spy.cron.TimeIncrement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cron
extends SpyThread {
    private JobQueue<?> jobQueue = null;
    private boolean stillRunning = true;
    private ThreadPool threads = null;
    private long maxIdleTime = 900000L;
    private long validJobFound = 0L;

    public Cron(JobQueue<?> jq) {
        this("Cron", jq);
    }

    public Cron(String name, JobQueue<?> jq) {
        this(name, jq, null);
    }

    public Cron(String name, JobQueue<?> jq, ThreadPool tp) {
        super(new ThreadGroup(name), name);
        this.jobQueue = jq;
        this.setDaemon(true);
        this.getThreadGroup().setDaemon(true);
        this.threads = tp;
        if (this.threads == null) {
            this.threads = new ThreadPool(name + "Pool", 1, 10, 5, new LinkedBlockingQueue<Runnable>(128));
        }
        this.validJobFound = System.currentTimeMillis();
        this.start();
    }

    @Override
    public String toString() {
        String extra = null;
        extra = this.jobQueue == null ? " - null jobqueue" : " - watching " + this.jobQueue.size() + " jobs, next up at " + this.jobQueue.getNextStartDate();
        return super.toString() + extra;
    }

    public JobQueue<?> getJobQueue() {
        return this.jobQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Already shut down");
        }
        this.stillRunning = false;
        this.threads.shutdown();
        JobQueue<?> jobQueue = this.jobQueue;
        synchronized (jobQueue) {
            this.jobQueue.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.stillRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.getLogger().info("Starting cron services");
        while (this.stillRunning) {
            for (Job j : this.jobQueue.getReadyJobs()) {
                this.getLogger().info("Starting job " + j);
                this.threads.addTask(j);
            }
            long now = System.currentTimeMillis();
            Date next = this.jobQueue.getNextStartDate();
            long soonestJob = 0L;
            if (next == null) {
                this.getLogger().debug("No job in queue");
                if (now - this.validJobFound > this.maxIdleTime) {
                    this.getLogger().info("Been a long time since I had a job.  Shutting down.");
                    this.getLogger().debug("now: %s", now);
                    this.getLogger().debug("validJobFound:  %s", this.validJobFound);
                    this.getLogger().debug("maxIdleTime:  %s", this.maxIdleTime);
                    this.shutdown();
                }
                soonestJob = 60000L;
            } else {
                soonestJob = next.getTime() - now;
                this.validJobFound = now;
            }
            try {
                if (next != null) {
                    this.getLogger().debug("Sleeping %sms (next job at %s).", soonestJob, next);
                } else {
                    this.getLogger().debug("Sleeping %sms (no good date found).", soonestJob);
                }
                if (this.stillRunning) {
                    if ((soonestJob -= 1000L) < 1L) {
                        soonestJob = 1L;
                    }
                    this.getLogger().debug("Sleeping for " + soonestJob);
                    JobQueue<?> jobQueue = this.jobQueue;
                    synchronized (jobQueue) {
                        this.jobQueue.wait(soonestJob);
                    }
                    Cron.sleep(1000L);
                    this.getLogger().debug("Finished sleep.");
                    continue;
                }
                this.getLogger().debug("Not sleeping, game over.");
            }
            catch (Exception e) {
                this.getLogger().warn((Object)"Exception in cron loop", e);
            }
        }
        this.getLogger().info("shut down at");
    }

    public void setMaxIdleTime(long to) {
        this.maxIdleTime = to;
    }

    public static void main(String[] args) throws Exception {
        FileJobQueue jq = new FileJobQueue(new File(args[0]));
        Cron c = new Cron(jq);
        TimeIncrement ti = new TimeIncrement();
        ti.setField(12);
        ti.setIncrement(2);
        while (c.isAlive()) {
            Cron.sleep(10000L);
        }
    }
}

