/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import net.spy.concurrent.ThreadPoolRunnable;

public class WorkerThread
extends Thread {
    private volatile Runnable running = null;
    private volatile long started = 0L;

    public WorkerThread(ThreadGroup tg, Runnable r, String name) {
        super(tg, r, name);
    }

    public WorkerThread(Runnable r, String name) {
        this(null, r, name);
    }

    public void setRunning(Runnable to) {
        this.running = to;
        if (to != null) {
            this.started = System.currentTimeMillis();
        }
    }

    public String toString() {
        String rv = null;
        Runnable r = this.running;
        if (r != null) {
            long now = System.currentTimeMillis();
            String runString = r.getClass().getName();
            if (r instanceof ThreadPoolRunnable) {
                ThreadPoolRunnable tpr = (ThreadPoolRunnable)r;
                runString = ((Object)tpr).toString();
            }
            rv = super.toString() + " - running " + runString + " for " + (now - this.started) + "ms";
        } else {
            rv = super.toString() + " - idle";
        }
        return rv;
    }
}

