/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cache;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import net.spy.SpyObject;
import net.spy.SpyThread;
import net.spy.cache.AbstractCachable;
import net.spy.cache.Cachable;
import net.spy.cache.CacheClearRequestListener;
import net.spy.cache.CacheDelegate;
import net.spy.util.TimeStampedHashMap;

public class SpyCache
extends SpyObject {
    TimeStampedHashMap<String, Cachable> cacheStore = null;
    private SpyCacheCleaner cacheCleaner = null;
    CacheDelegate delegate = null;
    private static SpyCache instance = null;
    private static final int CACHE_CLEAN_SLEEP_TIME = 60000;

    protected SpyCache() {
        this.init();
    }

    private void init() {
        this.cacheStore = new TimeStampedHashMap();
        this.delegate = new DummyDelegate();
    }

    private synchronized void checkThread() {
        if (this.cacheCleaner == null || !this.cacheCleaner.isAlive()) {
            this.cacheCleaner = new SpyCacheCleaner();
        }
    }

    public static synchronized SpyCache getInstance() {
        if (instance == null) {
            instance = new SpyCache();
        }
        instance.checkThread();
        return instance;
    }

    public static synchronized void shutdown() {
        if (instance != null && SpyCache.instance.cacheCleaner != null) {
            SpyCache.instance.cacheCleaner.shutdown();
        }
        instance = null;
    }

    public void setDelegate(CacheDelegate del) {
        if (del == null) {
            throw new NullPointerException("Invalid delegate <null>");
        }
        this.delegate = del;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String key, Cachable value) {
        TimeStampedHashMap<String, Cachable> timeStampedHashMap = this.cacheStore;
        synchronized (timeStampedHashMap) {
            value.cachedEvent(key);
            this.cacheStore.put(key, value);
        }
        this.delegate.cachedObject(key, value);
    }

    public void store(String key, Object value, long cacheTime) {
        SpyCacheItem i = new SpyCacheItem(key, value, cacheTime);
        this.store(key, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Object ret = null;
        long t = System.currentTimeMillis();
        TimeStampedHashMap<String, Cachable> timeStampedHashMap = this.cacheStore;
        synchronized (timeStampedHashMap) {
            Cachable i = this.cacheStore.get(key);
            if (i != null && !i.isExpired()) {
                i.setAccessTime(t);
                ret = i.getCachedObject();
                if (ret != null && ret instanceof Reference) {
                    Reference ref = (Reference)ret;
                    ret = ref.get();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncache(String key) {
        Cachable unc = null;
        TimeStampedHashMap<String, Cachable> timeStampedHashMap = this.cacheStore;
        synchronized (timeStampedHashMap) {
            unc = (Cachable)this.cacheStore.remove(key);
        }
        if (unc != null) {
            unc.uncachedEvent(key);
            this.delegate.uncachedObject(key, unc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncacheLike(String keystart) {
        TimeStampedHashMap<String, Cachable> timeStampedHashMap = this.cacheStore;
        synchronized (timeStampedHashMap) {
            Iterator i = this.cacheStore.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                String key = (String)me.getKey();
                if (!key.startsWith(keystart)) continue;
                i.remove();
                Cachable c = (Cachable)me.getValue();
                c.uncachedEvent(key);
                this.delegate.uncachedObject(key, c);
            }
        }
    }

    static class DummyDelegate
    implements CacheDelegate {
        DummyDelegate() {
        }

        public void cachedObject(String key, Cachable value) {
        }

        public void uncachedObject(String key, Cachable value) {
        }
    }

    static class SpyCacheItem
    extends AbstractCachable {
        private long exptime = 0L;

        public SpyCacheItem(Object key, Object value, long cacheTime) {
            super(key, value);
            this.exptime = this.getCacheTime() + cacheTime;
        }

        public String toString() {
            String out = "{Cached item:  " + this.getCacheKey();
            if (this.exptime > 0L) {
                out = out + " Expires:  " + new Date(this.exptime) + " - expired? " + this.isExpired();
            }
            out = out + "}";
            return out;
        }

        public boolean isExpired() {
            Reference rvalue;
            Object v;
            boolean ret = false;
            if (this.exptime > 0L) {
                long t = System.currentTimeMillis();
                boolean bl = ret = t > this.exptime;
            }
            if ((v = this.getCachedObject()) instanceof Reference && (rvalue = (Reference)v).get() == null) {
                ret = false;
            }
            return ret;
        }
    }

    private class SpyCacheCleaner
    extends SpyThread {
        private int passes = 0;
        private boolean reportedMulticastSE = false;
        private CacheClearRequestListener listener = null;
        private boolean wantMulticastListener = true;
        private boolean shutdown = false;

        public SpyCacheCleaner() {
            this.setName("SpyCacheCleaner");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.getLogger().debug("Shutting down %s", this);
            this.shutdown = true;
            SpyCacheCleaner spyCacheCleaner = this;
            synchronized (spyCacheCleaner) {
                this.notifyAll();
            }
        }

        public String toString() {
            return super.toString() + " - " + this.passes + " runs, mod age:  " + SpyCache.this.cacheStore.getUseAge() + ", cur size:  " + SpyCache.this.cacheStore.size() + ", tot stored:  " + SpyCache.this.cacheStore.getNumPuts() + ", watermark:  " + SpyCache.this.cacheStore.getWatermark() + ", hits:  " + SpyCache.this.cacheStore.getHits() + ", misses:  " + SpyCache.this.cacheStore.getMisses();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() throws Exception {
            TimeStampedHashMap<String, Cachable> timeStampedHashMap = SpyCache.this.cacheStore;
            synchronized (timeStampedHashMap) {
                Iterator i = SpyCache.this.cacheStore.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    String key = (String)me.getKey();
                    Cachable it = (Cachable)me.getValue();
                    if (!it.isExpired()) continue;
                    this.getLogger().debug("%s expired", it.getCacheKey());
                    i.remove();
                    it.uncachedEvent(key);
                    SpyCache.this.delegate.uncachedObject(key, it);
                }
            }
            ++this.passes;
        }

        private boolean shouldIContinue() {
            boolean rv = false;
            if (!this.shutdown && SpyCache.this.cacheStore.getUseAge() < 3600000L) {
                rv = true;
            }
            return rv;
        }

        private void checkMulticastThread() {
            try {
                String addrS = System.getProperty("net.spy.cache.multi.addr");
                String portS = System.getProperty("net.spy.cache.multi.port");
                if (addrS != null && portS != null) {
                    this.wantMulticastListener = true;
                    int port = Integer.parseInt(portS);
                    InetAddress group = InetAddress.getByName(addrS);
                    this.listener = new CacheClearRequestListener(group, port);
                } else {
                    this.wantMulticastListener = false;
                }
            }
            catch (SecurityException se) {
                if (!this.reportedMulticastSE) {
                    this.getLogger().error((Object)"Couldn't create multicast listener", se);
                    this.reportedMulticastSE = true;
                }
            }
            catch (IOException ioe) {
                this.getLogger().error((Object)"Couldn't create multicast listener", ioe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            while (this.shouldIContinue()) {
                try {
                    object = this;
                    synchronized (object) {
                        this.wait(60000L);
                    }
                    this.cleanup();
                    if (!this.wantMulticastListener || this.listener != null && this.listener.isAlive()) continue;
                    this.checkMulticastThread();
                }
                catch (Exception e) {
                    this.getLogger().warn((Object)"Exception in cleanup loop", e);
                }
            }
            this.getLogger().info("Shutting down.");
            object = SpyCache.this.cacheStore;
            synchronized (object) {
                Iterator i = SpyCache.this.cacheStore.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    String key = (String)me.getKey();
                    Cachable it = (Cachable)me.getValue();
                    i.remove();
                    it.uncachedEvent(key);
                    SpyCache.this.delegate.uncachedObject(key, it);
                }
            }
            if (this.listener != null) {
                this.listener.stopRunning();
            }
        }
    }
}

