/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.spy.cache.LRUCache;
import net.spy.log.Logger;
import net.spy.log.LoggerFactory;
import net.spy.util.CloseUtil;
import net.spy.util.SpyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskCache
extends AbstractMap<Serializable, Serializable> {
    String basedir = null;
    private LRUCache<Serializable, SoftReference<Serializable>> lruCache = null;
    private static final int DEFAULT_LRU_CACHE_SIZE = 100;
    private transient Logger logger = null;

    public DiskCache(String base) {
        this(base, 100);
    }

    public DiskCache(String base, int lruCacheSize) {
        this.basedir = base;
        this.lruCache = new LRUCache(lruCacheSize);
    }

    public String getBaseDir() {
        return this.basedir;
    }

    private String getPath(Object key) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"There's no SHA?");
        }
        if (key instanceof String) {
            String k = (String)key;
            md.update(k.getBytes());
        } else {
            String tmpkey = key.getClass().getName() + key.hashCode();
            md.update(tmpkey.getBytes());
        }
        String hashed = SpyUtil.byteAToHexString(md.digest());
        String base = this.basedir + "/" + hashed.substring(0, 2);
        String path = base + "/" + hashed;
        File f = new File(base);
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        return path;
    }

    @Override
    public Serializable put(Serializable k, Serializable v) {
        Serializable rv = this.get(k);
        String pathto = this.getPath(k);
        FileOutputStream ostream = null;
        ObjectOutputStream p = null;
        try {
            ostream = new FileOutputStream(pathto);
            p = new ObjectOutputStream(ostream);
            p.writeObject(k);
            p.writeObject(v);
            p.flush();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error storing object", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(p);
                CloseUtil.close(ostream);
                throw throwable;
            }
        }
        CloseUtil.close(p);
        CloseUtil.close(ostream);
        return rv;
    }

    @Override
    public Serializable get(Object key) {
        Serializable rv = null;
        if (key == null) {
            throw new NullPointerException("Name not provided");
        }
        rv = (Serializable)((Object)this.lruCache.get(key));
        if (rv == null) {
            rv = (Serializable)this.getFromDiskCache(key);
            this.lruCache.put((Serializable)key, new SoftReference<Serializable>(rv));
        }
        return rv;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object getFromDiskCache(Object key) {
        Object rv = null;
        FileInputStream istream = null;
        ObjectInputStream p = null;
        try {
            istream = new FileInputStream(this.getPath(key));
            p = new ObjectInputStream(istream);
            Object storedKey = p.readObject();
            Object o = p.readObject();
            if (!key.equals(storedKey)) {
                throw new Exception("Key value did not match (" + storedKey + " != " + key + ")");
            }
            rv = o;
        }
        catch (FileNotFoundException e) {
            block7: {
                if (!this.getLogger().isDebugEnabled()) break block7;
                this.getLogger().debug((Object)"File not found loading disk cache", e);
            }
            CloseUtil.close(p);
            CloseUtil.close(istream);
        }
        catch (Exception e2) {
            this.getLogger().warn("Error getting ``%s'' from disk cache", key, e2);
            {
                catch (Throwable throwable) {
                    CloseUtil.close(p);
                    CloseUtil.close(istream);
                    throw throwable;
                }
            }
            CloseUtil.close(p);
            CloseUtil.close(istream);
        }
        CloseUtil.close(p);
        CloseUtil.close(istream);
        return rv;
    }

    @Override
    public Set<Map.Entry<Serializable, Serializable>> entrySet() {
        WalkerDiskCacheRanger rv = null;
        try {
            rv = new WalkerDiskCacheRanger();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error getting set", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting set", e);
        }
        return rv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class E
    implements Map.Entry<Serializable, Serializable> {
        File path = null;
        Serializable k = null;

        public E(Serializable key, File p) {
            this.k = key;
            this.path = p;
        }

        @Override
        public boolean equals(Object o) {
            boolean rv = false;
            if (o instanceof E) {
                E e = (E)o;
                rv = e.k.equals(this.k);
            }
            return rv;
        }

        public File getPath() {
            return this.path;
        }

        @Override
        public Serializable getKey() {
            return this.k;
        }

        @Override
        public int hashCode() {
            return this.k.hashCode();
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Serializable getValue() {
            Serializable rv = null;
            FileInputStream istream = null;
            ObjectInputStream p = null;
            try {
                istream = new FileInputStream(this.path);
                p = new ObjectInputStream(istream);
                Object key = p.readObject();
                assert (key.equals(this.k));
                rv = (Serializable)p.readObject();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Error getting object", e);
                    catch (ClassNotFoundException e2) {
                        throw new RuntimeException("Error getting object", e2);
                    }
                }
                catch (Throwable throwable) {
                    CloseUtil.close(p);
                    CloseUtil.close(istream);
                    throw throwable;
                }
            }
            CloseUtil.close(p);
            CloseUtil.close(istream);
            return rv;
        }

        @Override
        public Serializable setValue(Serializable o) {
            throw new UnsupportedOperationException("Can't set here.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class I
    implements Iterator<Map.Entry<Serializable, Serializable>> {
        private Iterator<Map.Entry<Serializable, Serializable>> i = null;
        private E current = null;
        private boolean begun = false;

        public I(Iterator<Map.Entry<Serializable, Serializable>> it) {
            this.i = it;
        }

        @Override
        public E next() {
            this.begun = true;
            this.current = (E)this.i.next();
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            if (!this.begun) {
                throw new IllegalStateException("Have not yet begun walking.");
            }
            File f = this.current.getPath();
            f.delete();
            this.i.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WalkerDiskCacheRanger
    extends HashSet<Map.Entry<Serializable, Serializable>> {
        public WalkerDiskCacheRanger() throws IOException, ClassNotFoundException {
            this.init(new File(DiskCache.this.basedir));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(File f) throws IOException, ClassNotFoundException {
            block4: {
                block3: {
                    if (!f.isDirectory()) break block3;
                    File[] stuff = f.listFiles();
                    for (int i = 0; i < stuff.length; ++i) {
                        this.init(stuff[i]);
                    }
                    break block4;
                }
                FileInputStream istream = null;
                ObjectInputStream p = null;
                Serializable key = null;
                try {
                    istream = new FileInputStream(f);
                    p = new ObjectInputStream(istream);
                    key = (Serializable)p.readObject();
                }
                catch (Throwable throwable) {
                    CloseUtil.close(p);
                    CloseUtil.close(istream);
                    throw throwable;
                }
                CloseUtil.close(p);
                CloseUtil.close(istream);
                this.add(new E(key, f));
            }
        }

        @Override
        public Iterator<Map.Entry<Serializable, Serializable>> iterator() {
            return new I(super.iterator());
        }
    }
}

