/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cache;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import net.spy.SpyThread;
import net.spy.cache.SpyCache;

public class CacheClearRequestListener
extends SpyThread {
    private MulticastSocket s = null;
    private InetAddress group = null;
    private int port = -1;
    private int requests = 0;
    private boolean running = true;

    public CacheClearRequestListener(InetAddress g, int p) throws IOException {
        this.getLogger().info("Starting multicast cache listener on %s:%d", g, p);
        this.setDaemon(true);
        this.setName("SpyCacheClearRequestListener");
        this.group = g;
        this.port = p;
        this.s = this.makeMCastSocket(this.port);
        this.s.joinGroup(g);
        this.start();
    }

    protected MulticastSocket makeMCastSocket(int p) throws IOException {
        return new MulticastSocket(p);
    }

    public String toString() {
        return super.toString() + " on " + this.group.getHostAddress() + ":" + this.port + " processed " + this.requests + " requests";
    }

    public void stopRunning() {
        this.running = false;
        try {
            this.s.leaveGroup(this.group);
            this.s.close();
        }
        catch (IOException ioe) {
            this.getLogger().error((Object)"IOException when leaving group", ioe);
        }
    }

    public void flush(DatagramPacket recv) {
        byte[] data = recv.getData();
        byte[] tmp = new byte[recv.getLength()];
        System.arraycopy(data, 0, tmp, 0, tmp.length);
        String prefix = new String(tmp);
        this.getLogger().info("CacheClearRequestListener flushing ``%s'' per mcast req from %s", prefix, recv.getAddress());
        ++this.requests;
        SpyCache cache = SpyCache.getInstance();
        cache.uncacheLike(prefix);
    }

    public void run() {
        while (this.running) {
            try {
                byte[] data = new byte[1500];
                DatagramPacket recv = new DatagramPacket(data, data.length);
                this.s.receive(recv);
                this.flush(recv);
            }
            catch (IOException e) {
                this.getLogger().error((Object)"IOException processing packet.", e);
            }
        }
    }
}

