/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.spy.cache.AbstractCacheListener;
import net.spy.cache.Cachable;
import net.spy.cache.CacheListener;

public abstract class AbstractCachable
extends AbstractCacheListener
implements Cachable {
    private Object key = null;
    private Object value = null;
    private long cacheTime = 0L;
    private AtomicInteger accesses = new AtomicInteger(0);
    private AtomicLong lastAccess = new AtomicLong(0L);

    public AbstractCachable(Object k, Object v) {
        this.key = k;
        this.value = v;
        this.cacheTime = System.currentTimeMillis();
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public Object getCacheKey() {
        return this.key;
    }

    public Object getCachedObject() {
        return this.value;
    }

    public long getLastAccessTime() {
        return this.lastAccess.get();
    }

    public void setAccessTime(long t) {
        long oldtime = this.lastAccess.get();
        if (t > oldtime) {
            this.lastAccess.compareAndSet(oldtime, t);
        }
        this.accesses.incrementAndGet();
    }

    public int getAccessCount() {
        return this.accesses.intValue();
    }

    private CacheListener getContainedObjectAsListener() {
        CacheListener rv = null;
        if (this.value instanceof CacheListener) {
            rv = (CacheListener)this.value;
        }
        return rv;
    }

    public void cachedEvent(Object k) {
        super.cachedEvent(k);
        CacheListener o = this.getContainedObjectAsListener();
        if (o != null) {
            o.cachedEvent(k);
        }
    }

    public void uncachedEvent(Object k) {
        super.uncachedEvent(k);
        CacheListener o = this.getContainedObjectAsListener();
        if (o != null) {
            o.uncachedEvent(k);
        }
    }
}

