/*
 * Decompiled with CFR 0.152.
 */
package net.spy.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.spy.util.CloseUtil;
import net.spy.util.SPGen;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class SPGenTask
extends MatchingTask {
    private File srcDir;
    private File destDir;
    private String superclass = null;
    private String dbcpSuperclass = null;
    private String dbspSuperclass = null;
    private Set<String> interfaces = null;
    private boolean verbose = false;

    public void setSrcdir(File to) {
        this.srcDir = to;
    }

    public void setDestdir(File to) {
        this.destDir = to;
    }

    public void setSuperclass(String sc) {
        this.superclass = sc;
    }

    public void setDbcpSuperclass(String sc) {
        this.dbcpSuperclass = sc;
    }

    public void setDbspSuperclass(String sc) {
        this.dbspSuperclass = sc;
    }

    public void setVerbose(boolean to) {
        this.verbose = to;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("source directory \"" + this.srcDir + "\" is not valid.");
        }
        if (this.destDir == null) {
            this.destDir = this.srcDir;
        }
        if (!this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" is not valid.", this.getLocation());
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] includes = new String[]{"**\\*.spt"};
        ds.setIncludes(includes);
        ds.setBasedir(this.srcDir);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        String[] toDoFiles = this.trimSPTList(files);
        if (toDoFiles.length > 0) {
            this.log("Compiling " + toDoFiles.length + " of " + files.length + " spt file" + (files.length == 1 ? "" : "s") + " to " + this.destDir);
            for (int i = 0; i < toDoFiles.length; ++i) {
                this.processFile(toDoFiles[i]);
            }
        }
    }

    private String[] trimSPTList(String[] input) {
        ArrayList<String> a = new ArrayList<String>();
        for (int i = 0; i < input.length; ++i) {
            File srcFile = new File(this.srcDir, input[i]);
            File destFile = this.getDestFile(input[i]);
            if (destFile.exists() && destFile.lastModified() > srcFile.lastModified()) continue;
            a.add(input[i]);
        }
        String[] rv = new String[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            rv[i] = (String)a.get(i);
        }
        return rv;
    }

    private File getDestFile(String filename) {
        File destFile = new File(this.destDir, filename.substring(0, filename.length() - 4) + ".java");
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(String filename) {
        File srcFile = new File(this.srcDir, filename);
        File tmpFile = null;
        File destFile = this.getDestFile(filename);
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            try {
                FileReader reader = new FileReader(srcFile);
                in = new BufferedReader(reader);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            if (destFile.exists() && destFile.lastModified() > srcFile.lastModified()) {
                return;
            }
            try {
                tmpFile = File.createTempFile("sptgen", "java", this.destDir);
                FileWriter writer = new FileWriter(tmpFile);
                out = new PrintWriter(writer);
                String name = srcFile.getName();
                SPGen spg = new SPGen(name.substring(0, name.length() - 4), in, out);
                if (this.superclass != null) {
                    spg.setSuperclass(this.superclass);
                }
                if (this.dbcpSuperclass != null) {
                    spg.setDbcpSuperclass(this.dbcpSuperclass);
                }
                if (this.dbspSuperclass != null) {
                    spg.setDbspSuperclass(this.dbspSuperclass);
                }
                if (this.interfaces != null) {
                    spg.addInterfaces(this.interfaces);
                }
                spg.setVerbose(this.verbose);
                spg.generate();
            }
            catch (Exception e) {
                try {
                    throw new BuildException((Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close(in);
                    CloseUtil.close(out);
                    throw throwable;
                }
            }
            CloseUtil.close(in);
            CloseUtil.close(out);
            if (destFile.exists()) {
                if (!destFile.delete()) {
                    throw new BuildException("Unable to delete " + destFile);
                }
            } else {
                this.checkParent(destFile);
            }
            if (!tmpFile.renameTo(destFile)) {
                throw new BuildException("Unable to rename " + tmpFile + " to " + destFile);
            }
            tmpFile = null;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    protected void checkParent(File f) throws BuildException {
        File parent = f.getParentFile();
        if (parent.equals(this.destDir) && !parent.exists()) {
            throw new BuildException("Destination dir no longer exists");
        }
        if (!parent.exists()) {
            this.checkParent(parent);
            if (!parent.mkdir()) {
                throw new BuildException("Unable to create directory " + parent);
            }
        } else if (!parent.isDirectory()) {
            throw new BuildException("Not a directory: " + parent);
        }
    }

    public void setInterfaces(String to) {
        this.interfaces = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(to);
        while (st.hasMoreTokens()) {
            this.interfaces.add(st.nextToken());
        }
    }
}

