/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.timeutils;

import edu.iris.timeutils.TimeStampCalendar;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class TimeStamp
extends Timestamp {
    private static final long serialVersionUID = 1L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final int MAX_NANO_DIGITS = 9;
    private static final int NANOSEC_PER_SEC = 1000000000;
    private static final int DATE_TIME_OUTPUT = 1;
    private static final int SEED_TIME_OUTPUT = 3;
    private static final int EPOCH_TIME_OUTPUT = 5;

    public TimeStamp(long millis) {
        super(millis);
    }

    public static TimeStamp buildTimestamp(String sqlTimestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy,DDD,HH:mm:ss");
        sdf.setTimeZone(UTC);
        Date date = null;
        try {
            date = sdf.parse(sqlTimestamp);
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(e.getMessage()) + ": " + sqlTimestamp);
        }
        TimeStamp ts = new TimeStamp(date.getTime());
        int idx = sqlTimestamp.indexOf(46);
        if (idx != -1) {
            int frac_sec = Integer.parseInt(sqlTimestamp.substring(idx + 1));
            ts.setNanos(frac_sec * 100000);
        } else {
            ts.setNanos(0);
        }
        return ts;
    }

    public static TimeStamp buildTimestamp0(String sqlTimestamp) {
        int nvals;
        int yr = 1970;
        int jday = 1;
        int mo = 0;
        int day = 1;
        int hr = 0;
        int min = 0;
        int sec = 0;
        boolean isDateTime = false;
        boolean isSeedTime = false;
        ArrayList dateTimeVals = null;
        long millis = 0L;
        int nanosec = 0;
        boolean numCount = false;
        if (TimeStamp.isDouble(sqlTimestamp)) {
            numCount = true;
        } else {
            dateTimeVals = TimeStamp.parseDateTime(sqlTimestamp, "-: ");
            if (dateTimeVals == null) {
                dateTimeVals = TimeStamp.parseDateTime(sqlTimestamp, "/: ");
                if (dateTimeVals == null) {
                    dateTimeVals = TimeStamp.parseDateTime(sqlTimestamp, ",:");
                    if (dateTimeVals != null) {
                        isSeedTime = true;
                    }
                } else {
                    isDateTime = true;
                }
            } else {
                isDateTime = true;
            }
        }
        if (numCount) {
            int intValLength = sqlTimestamp.indexOf(46);
            String intStringVal = "0";
            BigDecimal bdec = new BigDecimal(intStringVal);
            if (intValLength == -1) {
                nanosec = 0;
                bdec = new BigDecimal(sqlTimestamp);
            } else if (intValLength > 0) {
                intStringVal = sqlTimestamp.substring(0, intValLength);
                bdec = new BigDecimal(intStringVal);
            }
            millis = bdec.movePointRight(3).longValue();
            nanosec = TimeStamp.getNanos(sqlTimestamp);
        } else if (isDateTime) {
            nvals = dateTimeVals.size();
            String tmpStr = null;
            if (nvals == 6) {
                tmpStr = (String)dateTimeVals.get(5);
                sec = new Double(tmpStr).intValue();
                nanosec = TimeStamp.getNanos(tmpStr);
                --nvals;
            }
            int i = 0;
            while (i < nvals) {
                tmpStr = (String)dateTimeVals.get(i);
                int tmpInt = new Integer(tmpStr);
                if (i == 0) {
                    yr = tmpInt;
                } else if (i == 1) {
                    mo = tmpInt;
                } else if (i == 2) {
                    day = tmpInt;
                } else if (i == 3) {
                    hr = tmpInt;
                } else if (i == 4) {
                    min = tmpInt;
                }
                ++i;
            }
            TimeStampCalendar cal = new TimeStampCalendar(yr, --mo, day, hr, min, sec);
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            millis = cal.getTimeInMillis();
        } else if (isSeedTime) {
            nvals = dateTimeVals.size();
            String tmpStr = null;
            if (nvals == 5) {
                tmpStr = (String)dateTimeVals.get(4);
                sec = new Double(tmpStr).intValue();
                nanosec = TimeStamp.getNanos(tmpStr);
                --nvals;
            }
            int i = 0;
            while (i < nvals) {
                tmpStr = (String)dateTimeVals.get(i);
                int tmpInt = new Integer(tmpStr);
                if (i == 0) {
                    yr = tmpInt;
                } else if (i == 1) {
                    jday = tmpInt;
                } else if (i == 2) {
                    hr = tmpInt;
                } else if (i == 3) {
                    min = tmpInt;
                }
                ++i;
            }
            TimeStampCalendar cal = new TimeStampCalendar(yr, jday, hr, min, sec);
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            millis = cal.getTimeInMillis();
        } else {
            System.err.println("Error parsing time string");
            return null;
        }
        if (nanosec >= 1000000000) {
            int nsec = nanosec / 1000000000;
            millis += (long)(nsec * 1000);
            nanosec -= nsec * 1000000000;
        }
        TimeStamp mts = new TimeStamp(millis);
        mts.setNanos(nanosec);
        return mts;
    }

    public static TimeStamp buildTimestamp(double epochTime, int precision) {
        BigDecimal bd = new BigDecimal(epochTime);
        BigDecimal bdShifted = epochTime >= 0.0 ? bd.movePointRight(precision).add(new BigDecimal(0.5)) : bd.movePointRight(precision).subtract(new BigDecimal(0.5));
        BigInteger bi = bdShifted.toBigInteger();
        BigDecimal newbd = new BigDecimal(bi).movePointLeft(precision);
        TimeStamp mts = TimeStamp.buildTimestamp(newbd.toString());
        return mts;
    }

    public String toEpochString() {
        long millis = this.getTime();
        int nanos = this.getNanos();
        BigDecimal bdm = new BigDecimal(new Long(millis).toString());
        BigDecimal bdn = new BigDecimal(new Integer(nanos).toString());
        BigDecimal sumVal = millis >= 0L ? bdm.movePointLeft(3).add(bdn.movePointLeft(9)) : bdm.movePointLeft(3).subtract(bdn.movePointLeft(9));
        int scale = sumVal.scale();
        BigDecimal epochTime = sumVal;
        int i = scale - 1;
        while (i >= 0) {
            try {
                epochTime = sumVal.setScale(i, 7);
            }
            catch (ArithmeticException e) {
                break;
            }
            catch (IllegalArgumentException e) {
                break;
            }
            --i;
        }
        return epochTime.toString();
    }

    public String toSeedString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy,DDD,HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTimeStr = formatter.format(this);
        int lenDateTime = dateTimeStr.length();
        if (this.getNanos() != 0) {
            String nanosStr = this.getNanosStr();
            return String.valueOf(dateTimeStr) + "." + nanosStr;
        }
        if (dateTimeStr.substring(lenDateTime - 3).compareTo(":00") != 0) {
            return dateTimeStr;
        }
        if (dateTimeStr.substring(lenDateTime - 6).compareTo(":00:00") != 0) {
            return dateTimeStr.substring(0, lenDateTime - 3);
        }
        if (dateTimeStr.substring(lenDateTime - 9).compareTo(",00:00:00") != 0) {
            return dateTimeStr.substring(0, lenDateTime - 6);
        }
        return dateTimeStr.substring(0, lenDateTime - 9);
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.valueOf(formatter.format(this)) + "." + this.getNanosStr();
    }

    String getNanosStr() {
        int i;
        int len;
        int nanosVal = this.getNanos();
        if (nanosVal == 0) {
            return new Integer(nanosVal).toString();
        }
        String sval = new Integer(nanosVal).toString();
        int ndigits = len = sval.length();
        if (len > 1) {
            int lensave = len;
            i = lensave - 1;
            while (i >= 0) {
                if (sval.charAt(i) != '0') break;
                --len;
                --i;
            }
            if (len < lensave) {
                sval = sval.substring(0, len);
            }
        }
        String initPad = "";
        i = ndigits;
        while (i < 9) {
            initPad = String.valueOf(initPad) + "0";
            ++i;
        }
        return String.valueOf(initPad) + sval;
    }

    public String getDateTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTimeString = formatter.format(this);
        return dateTimeString;
    }

    public int getNanoSecs() {
        return this.getNanos();
    }

    public Date toDate() {
        long ms = this.getTime() + (long)(this.getNanos() / 1000000);
        return new Date(ms);
    }

    public double toEpochTime() {
        long millis = this.getTime();
        int nanos = this.getNanos();
        BigDecimal bdMillis = new BigDecimal(new Long(millis).toString());
        BigDecimal bdNanos = new BigDecimal(new Integer(nanos).toString());
        if (millis >= 0L) {
            return bdMillis.movePointLeft(3).add(bdNanos.movePointLeft(9)).doubleValue();
        }
        return bdMillis.movePointLeft(3).subtract(bdNanos.movePointLeft(9)).doubleValue();
    }

    static int getNanos(String epochTime) {
        int fieldLength = epochTime.length();
        int intValLength = epochTime.indexOf(46);
        String intStringVal = "0";
        double tmp = 0.0;
        int nanosec = 0;
        if (intValLength == -1) {
            return 0;
        }
        if (intValLength > 0) {
            intStringVal = epochTime.substring(0, intValLength);
        }
        BigDecimal bd1 = new BigDecimal(epochTime);
        BigDecimal bd2 = new BigDecimal(intStringVal);
        int ndigits = intValLength;
        int nshift = fieldLength - ndigits - 1;
        BigDecimal diff = bd1.signum() < 0 ? bd2.movePointRight(nshift).subtract(bd1.movePointRight(nshift)) : bd1.movePointRight(nshift).subtract(bd2.movePointRight(nshift));
        nshift = Math.min(9 - nshift, 9);
        nanosec = nshift > 0 ? diff.movePointRight(nshift).intValue() : (int)(diff.movePointLeft(-nshift).doubleValue() + 0.5);
        return nanosec;
    }

    private static boolean isDouble(String sqlTimeString) {
        try {
            Double tmp = new Double(sqlTimeString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static ArrayList parseDateTime(String sqlTimeString, String sepChars) {
        ArrayList<String> vals = new ArrayList<String>();
        int nfields = 0;
        StringTokenizer st = new StringTokenizer(sqlTimeString, sepChars);
        while (st.hasMoreTokens()) {
            vals.add(st.nextToken());
            try {
                Double tmp = new Double((String)vals.get(nfields));
            }
            catch (NumberFormatException e) {
                return null;
            }
            ++nfields;
        }
        return vals;
    }

    static void printUsage() {
        System.err.println("Usage: java edu.iris.timeutils.TimeStamp [-{u|U|h|H} | -dateTime | -seedTime | -epochTime ]");
        System.err.println("  Output options; -{u|U|h|H} = for any of these options, print usage and exit");
        System.err.println("                  -dateTime  = YYYY-MO-DY HR:MM:SS.NNNNNNNNN");
        System.err.println("                  -seedTime  = YYYY,DOY,HR:MM:SS.NNNNNNNNN");
        System.err.println("                  -epochTime = the epoch time as a string (with arbitrary precision)");
    }

    public static void main(String[] args) {
        ArrayList vals = new ArrayList();
        int outFormatFlag = 0;
        TimeStamp tmpVal = null;
        if (args.length > 1 || args.length == 1 && (args[0].equals("-H") || args[0].equals("-h"))) {
            TimeStamp.printUsage();
            System.exit(1);
        } else if (args.length == 1 && (args[0].equals("-H") || args[0].equals("-h") || args[0].equals("-U") || args[0].equals("-u"))) {
            TimeStamp.printUsage();
            System.exit(1);
        }
        if (args.length == 0) {
            outFormatFlag = 1;
        } else if (args[0].equals("-dateTime")) {
            outFormatFlag = 1;
        } else if (args[0].equals("-seedTime")) {
            outFormatFlag = 3;
        } else if (args[0].equals("-epochTime")) {
            outFormatFlag = 5;
        } else {
            System.err.println("ERROR(TimeStamp): Unrecognized output type encountered: " + args[0]);
            TimeStamp.printUsage();
            System.exit(1);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            String s;
            while ((s = in.readLine()) != null) {
                if (s == null || s.length() <= 0) continue;
                tmpVal = TimeStamp.buildTimestamp(s);
                switch (outFormatFlag) {
                    case 1: {
                        System.out.println(tmpVal.toString());
                        break;
                    }
                    case 3: {
                        System.out.println(tmpVal.toSeedString());
                        break;
                    }
                    case 5: {
                        System.out.println(tmpVal.toEpochString());
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }
}

