/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.Blockette10;
import edu.iris.seedutils.Blockette11;
import edu.iris.seedutils.Blockette12;
import edu.iris.seedutils.Blockette30;
import edu.iris.seedutils.Blockette31;
import edu.iris.seedutils.Blockette32;
import edu.iris.seedutils.Blockette33;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.Blockette50;
import edu.iris.seedutils.Blockette51;
import edu.iris.seedutils.Blockette52;
import edu.iris.seedutils.Blockette53;
import edu.iris.seedutils.Blockette54;
import edu.iris.seedutils.Blockette55;
import edu.iris.seedutils.Blockette57;
import edu.iris.seedutils.Blockette58;
import edu.iris.seedutils.Blockette59;
import edu.iris.seedutils.Blockette61;
import edu.iris.seedutils.Blockette70;
import edu.iris.seedutils.Blockette71;
import edu.iris.seedutils.Blockette72;
import edu.iris.seedutils.Blockette73;
import edu.iris.seedutils.Blockette74;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.SeedPod;
import edu.iris.seedutils.StandaloneLookupMap;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class SeedVolume
extends HashMap
implements SeedPod {
    private static final long serialVersionUID = 1L;
    private int logicalRecLen;
    private byte[] buffer;
    private int offset = 0;
    private boolean endSeedHead = false;
    protected SeedLookupMap volumeLookupMap = new StandaloneLookupMap();
    protected SeedLookupMap parseLookupMap = new StandaloneLookupMap();

    public SeedVolume() {
        HashMap stationInfo = new HashMap();
        this.put("stationInfo", stationInfo);
        HashMap dataRecordMap = new HashMap();
        this.put("dataRecordMap", dataRecordMap);
    }

    public SeedVolume(String volFileName) {
        this();
    }

    public RandomAccessFile openSeedVolume(String fname) {
        RandomAccessFile file_in = null;
        String vol_id = "000001V";
        try {
            file_in = new RandomAccessFile(fname, "r");
            byte[] lcl_buffer = new byte[21];
            int num_bytes_read = file_in.read(lcl_buffer, 0, 21);
            String wrkstr = null;
            if (num_bytes_read != 21) {
                throw new IOException("cannot read volume ID from input file '" + fname + "'");
            }
            wrkstr = new String(lcl_buffer, 0, 7);
            if (wrkstr.compareTo(vol_id) != 0) {
                throw new IOException("first 7 bytes from input file '" + fname + "' don't " + "look like a volume ID");
            }
            this.logicalRecLen = 1 << new Integer(new String(lcl_buffer, 19, 2));
            this.buffer = new byte[this.logicalRecLen];
            file_in.seek(0L);
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader: " + e.getMessage());
            return null;
        }
        return file_in;
    }

    public char readLogicalRecord(RandomAccessFile file_in) {
        try {
            int i = 0;
            while (i < this.buffer.length) {
                this.buffer[i] = 32;
                ++i;
            }
            int num_bytes_read = file_in.read(this.buffer, 0, this.logicalRecLen);
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader(): " + e.getMessage());
        }
        this.offset = 8;
        return (char)this.buffer[6];
    }

    public String getSeedBlkt(RandomAccessFile file_in) {
        String block;
        char header_type = '\u0000';
        try {
            if (file_in.getFilePointer() >= file_in.length()) {
                return new String();
            }
        }
        catch (IOException e) {
            System.out.println("SeedBlocketteReader.get_blk(): " + e.getMessage());
            return new String();
        }
        if (this.offset == 0 || this.offset > this.logicalRecLen - 7) {
            header_type = this.readLogicalRecord(file_in);
        }
        if (header_type == 'D' || header_type == 'Q' || header_type == 'R') {
            return new String();
        }
        String blk_length = new String(this.buffer, this.offset + 3, 4).trim();
        if (blk_length.length() <= 0) {
            header_type = this.readLogicalRecord(file_in);
            blk_length = new String(this.buffer, this.offset + 3, 4).trim();
        }
        if (header_type == 'D' || header_type == 'Q' || header_type == 'R') {
            return new String();
        }
        if (blk_length.length() <= 0) {
            return new String();
        }
        Integer len = new Integer(blk_length.trim());
        if (len + this.offset < this.logicalRecLen) {
            block = new String(this.buffer, this.offset, (int)len);
            this.offset += len.intValue();
        } else {
            char[] now_blockette = new char[len.intValue()];
            int i = this.offset;
            int ptr = 0;
            while (ptr < len) {
                now_blockette[ptr] = (char)this.buffer[i];
                if (++i >= this.logicalRecLen) {
                    this.readLogicalRecord(file_in);
                    i = this.offset;
                }
                ++ptr;
            }
            this.offset = i;
            block = new String(now_blockette);
        }
        return block;
    }

    public SeedBlockette nextBlockette(RandomAccessFile file_in) {
        SeedBlockette seedBlkt = null;
        this.endSeedHead = false;
        String blktStr = this.getSeedBlkt(file_in);
        if (blktStr == null || blktStr.length() == 0) {
            this.endSeedHead = true;
            return null;
        }
        switch (SeedBlockette.getType(blktStr)) {
            case 10: {
                seedBlkt = new Blockette10(blktStr, this.volumeLookupMap);
                break;
            }
            case 11: {
                seedBlkt = new Blockette11(blktStr, this.volumeLookupMap);
                break;
            }
            case 12: {
                seedBlkt = new Blockette12(blktStr, this.volumeLookupMap);
                break;
            }
            case 30: {
                seedBlkt = new Blockette30(blktStr, this.parseLookupMap);
                Blockette30 compareBlkt = new Blockette30();
                ((SeedBlockette)compareBlkt).compStringToObj(seedBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 4;
                this.parseLookupMap.setLookup(mapType, seedBlkt.get("Data format ID"), compareBlkt);
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                seedBlkt.put("Data format ID", new Integer(lookup));
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 31: {
                seedBlkt = new Blockette31(blktStr, this.parseLookupMap);
                Blockette31 compareBlkt = new Blockette31();
                ((SeedBlockette)compareBlkt).compStringToObj(seedBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 6;
                this.parseLookupMap.setLookup(mapType, seedBlkt.get("Comment lookup"), compareBlkt);
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                seedBlkt.put("Comment lookup", new Integer(lookup));
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 32: {
                seedBlkt = new Blockette32(blktStr, this.parseLookupMap);
                Blockette32 compareBlkt = new Blockette32();
                ((SeedBlockette)compareBlkt).compStringToObj(seedBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 5;
                this.parseLookupMap.setLookup(mapType, seedBlkt.get("Source lookup code"), seedBlkt);
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                seedBlkt.put("Source lookup code", new Integer(lookup));
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 33: {
                seedBlkt = new Blockette33(blktStr, this.parseLookupMap);
                Blockette33 compareBlkt = new Blockette33();
                ((SeedBlockette)compareBlkt).compStringToObj(seedBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 7;
                this.parseLookupMap.setLookup(mapType, seedBlkt.get("Abbrev lookup code"), seedBlkt);
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                seedBlkt.put("Abbrev lookup code", new Integer(lookup));
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 34: {
                seedBlkt = new Blockette34(blktStr, this.parseLookupMap);
                Blockette34 compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(seedBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 8;
                this.parseLookupMap.setLookup(mapType, seedBlkt.get("Units lookup code"), seedBlkt);
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                seedBlkt.put("Units lookup code", new Integer(lookup));
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 50: {
                seedBlkt = new Blockette50(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Network name");
                Blockette33 compareBlkt = new Blockette33();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 7;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Abbrev lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 51: {
                seedBlkt = new Blockette51(blktStr, this.parseLookupMap);
                break;
            }
            case 52: {
                seedBlkt = new Blockette52(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Instrument");
                SeedBlockette compareBlkt = new Blockette33();
                compareBlkt.compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 7;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Abbrev lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                tmpBlkt = (SeedBlockette)seedBlkt.get("Signal response units");
                compareBlkt = new Blockette34();
                compareBlkt.compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                mapType = 8;
                lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                tmpBlkt = (SeedBlockette)seedBlkt.get("Calibration input units");
                compareBlkt = new Blockette34();
                try {
                    compareBlkt.compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                    mapType = 8;
                    lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                    tmpBlkt.put("Units lookup code", new Integer(lookup));
                    tmpBlkt.setLookupMap(this.volumeLookupMap);
                }
                catch (NullPointerException e) {
                    tmpBlkt = new Blockette34();
                    tmpBlkt.compStringToObj("NO_UNITS - No units specified", this.parseLookupMap);
                    compareBlkt.compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                    mapType = 8;
                    lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                    tmpBlkt.put("Units lookup code", new Integer(lookup));
                    tmpBlkt.setLookupMap(this.volumeLookupMap);
                    seedBlkt.put("Calibration input units", tmpBlkt);
                }
                tmpBlkt = (SeedBlockette)seedBlkt.get("Data format");
                compareBlkt = new Blockette30();
                compareBlkt.compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                mapType = 4;
                lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Data format ID", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 53: {
                seedBlkt = new Blockette53(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Response input units");
                Blockette34 compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 8;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                tmpBlkt = (SeedBlockette)seedBlkt.get("Response output units");
                compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                mapType = 8;
                lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 54: {
                seedBlkt = new Blockette54(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Response input units");
                Blockette34 compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 8;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                tmpBlkt = (SeedBlockette)seedBlkt.get("Response output units");
                compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                mapType = 8;
                lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 55: {
                seedBlkt = new Blockette55(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Response input units");
                Blockette34 compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 8;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                tmpBlkt = (SeedBlockette)seedBlkt.get("Response output units");
                compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                mapType = 8;
                lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 57: {
                seedBlkt = new Blockette57(blktStr, this.volumeLookupMap);
                break;
            }
            case 58: {
                seedBlkt = new Blockette58(blktStr, this.volumeLookupMap);
                break;
            }
            case 59: {
                seedBlkt = new Blockette59(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Response input units");
                Blockette34 compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 8;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                tmpBlkt = (SeedBlockette)seedBlkt.get("Response output units");
                compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                mapType = 8;
                lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 61: {
                seedBlkt = new Blockette61(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Response input units");
                Blockette34 compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 8;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                tmpBlkt = (SeedBlockette)seedBlkt.get("Response output units");
                compareBlkt = new Blockette34();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                mapType = 8;
                lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Units lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 70: {
                seedBlkt = new Blockette70(blktStr, this.volumeLookupMap);
                break;
            }
            case 71: {
                seedBlkt = new Blockette71(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Hypocenter source");
                Blockette32 compareBlkt = new Blockette32();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 5;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Source lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 72: {
                seedBlkt = new Blockette72(blktStr, this.parseLookupMap);
                SeedBlockette tmpBlkt = (SeedBlockette)seedBlkt.get("Source");
                Blockette32 compareBlkt = new Blockette32();
                ((SeedBlockette)compareBlkt).compStringToObj(tmpBlkt.objToCompString(), this.parseLookupMap);
                int mapType = 5;
                int lookup = this.volumeLookupMap.getLookup(mapType, compareBlkt);
                tmpBlkt.put("Source lookup code", new Integer(lookup));
                tmpBlkt.setLookupMap(this.volumeLookupMap);
                seedBlkt.setLookupMap(this.volumeLookupMap);
                break;
            }
            case 73: {
                seedBlkt = new Blockette73(blktStr, this.volumeLookupMap);
                break;
            }
            case 74: {
                seedBlkt = new Blockette74(blktStr, this.volumeLookupMap);
                break;
            }
            default: {
                System.out.println(blktStr);
                return null;
            }
        }
        return seedBlkt;
    }

    public boolean putSeedBlkt(RandomAccessFile file_out, String buffer) {
        return false;
    }

    public void closeSeedVolume(RandomAccessFile file_in) {
        try {
            file_in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPodBlkt(RandomAccessFile file_in) {
        return null;
    }

    public boolean putPodBlkt(String buffer) {
        return false;
    }

    public boolean hasMoreHeaderBlockettes() {
        return !this.endSeedHead;
    }

    public static void main(String[] args) {
        RandomAccessFile file_in;
        SeedVolume sv = new SeedVolume();
        if (args.length != 1) {
            System.err.println("Usage:  java SeedVolume <volName>");
            System.exit(1);
        }
        if ((file_in = sv.openSeedVolume(args[0])) == null) {
            System.out.println("File " + args[0] + " is not a seed volume\nExiting.. .");
            sv.closeSeedVolume(file_in);
            System.exit(-1);
        }
        SeedBlockette blk = null;
        do {
            if ((blk = sv.nextBlockette(file_in)) == null) continue;
            blk.echoResp();
        } while (sv.hasMoreHeaderBlockettes());
        sv.closeSeedVolume(file_in);
        System.exit(0);
    }
}

