/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.Blockette53;
import edu.iris.seedutils.Blockette54;
import edu.iris.seedutils.Blockette55;
import edu.iris.seedutils.Blockette57;
import edu.iris.seedutils.Blockette58;
import edu.iris.seedutils.Blockette61;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedLookupMap;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class SeedStageResp
extends ArrayList {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SeedStageResp parseStageResp(String stageRespFileName, SeedLookupMap lm) {
        SeedStageResp seedStageResp = new SeedStageResp();
        BufferedReader rd = null;
        try {
            int testVal;
            char[] cbuf = new char[4];
            rd = new BufferedReader(new InputStreamReader(new FileInputStream(stageRespFileName)));
            rd.mark(4);
            while ((testVal = rd.read(cbuf, 0, 4)) != -1) {
                String line = new String(cbuf);
                if (!line.startsWith("#")) {
                    if (!line.startsWith("B")) throw new ParseStageException("illegal prefix found while parsing '" + line + rd.readLine() + "'");
                }
                if (line.startsWith("#")) {
                    rd.reset();
                    rd.readLine();
                    rd.mark(4);
                    continue;
                }
                if (line.startsWith("B053")) {
                    rd.reset();
                    seedStageResp.add(new Blockette53(rd, lm, 53));
                } else if (line.startsWith("B054")) {
                    rd.reset();
                    seedStageResp.add(new Blockette54(rd, lm, 54));
                } else if (line.startsWith("B055")) {
                    rd.reset();
                    seedStageResp.add(new Blockette55(rd, lm, 55));
                } else {
                    if (line.startsWith("B056")) {
                        throw new ParseStageException("Corner frequency/slope filters not yet implemented");
                    }
                    if (line.startsWith("B057")) {
                        rd.reset();
                        seedStageResp.add(new Blockette57(rd, lm, 57));
                    } else if (line.startsWith("B058")) {
                        rd.reset();
                        seedStageResp.add(new Blockette58(rd, lm, 58));
                    } else if (line.startsWith("B061")) {
                        rd.reset();
                        seedStageResp.add(new Blockette61(rd, lm, 61));
                    } else {
                        if (!line.startsWith("B060")) throw new ParseStageException("Unrecognized response blockette found  while parsing\n'" + line + "'");
                        throw new ParseStageException("Response lookups not yet implemented");
                    }
                }
                rd.mark(4);
            }
            rd.close();
            return seedStageResp;
        }
        catch (ParseStageException e) {
            e.printStackTrace();
            System.err.println("  while parsing '" + stageRespFileName + "'");
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            seedStageResp = null;
            try {
                if (rd == null) return seedStageResp;
                rd.close();
                return seedStageResp;
            }
            catch (IOException except) {
                except.printStackTrace();
            }
        }
        return seedStageResp;
    }
}

