/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.seedutils.Converter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PodWriter {
    private String Cwd;
    private String HA_fname;
    private String now_net;
    private String now_stn;
    private String now_chn;
    private String now_loc;
    private boolean file_open;
    private Converter converter;
    private static String fileSep = System.getProperty("file.separator");
    File out_file;
    RandomAccessFile rf;

    public PodWriter(String dir) {
        this.Cwd = new String(dir);
        this.HA_fname = new String("H.A");
        this.file_open = false;
        this.converter = new Converter();
    }

    public PodWriter() {
        this.Cwd = new String("HAR000");
        this.HA_fname = new String("H.A");
        this.file_open = false;
        this.converter = new Converter();
    }

    public void close() {
        if (this.file_open) {
            try {
                this.rf.close();
            }
            catch (IOException e) {
                System.out.println("Unable to properly close file");
            }
        }
        this.file_open = false;
    }

    private void open_file(String path, String fname) {
        File p = new File(path);
        if (!p.exists() && !p.mkdirs()) {
            System.out.println("Unable to make directory to data files!");
            return;
        }
        this.out_file = new File(path, fname);
        try {
            this.rf = new RandomAccessFile(this.out_file, "rw");
            this.rf.seek(this.rf.length());
            this.file_open = true;
        }
        catch (IOException e) {
            System.out.println("Unable to write data record. IO error:" + e.getMessage());
        }
    }

    public void set_CWD(String dir) {
        this.Cwd = new String(dir);
    }

    public void newStation(String s, String n) {
        this.now_stn = s.trim();
        this.now_net = n.trim();
        String fname = new String(String.valueOf(this.Cwd) + fileSep + s + "." + n);
        if (this.file_open && fname.compareTo(String.valueOf(this.out_file.getParent()) + fileSep + this.out_file.getName()) == 0) {
            try {
                this.rf.close();
            }
            catch (IOException e) {
                System.out.println("Unable to properly close file: " + fname);
                return;
            }
            this.file_open = false;
        }
    }

    public void write(byte[] datarec) {
        String stn = new String(datarec, 8, 5).trim();
        String loc = new String(datarec, 13, 2).trim();
        String chn = new String(datarec, 15, 3).trim();
        String net = new String(datarec, 18, 2).trim();
        short year = this.converter.makeShort(datarec[20], datarec[21]);
        short day = this.converter.makeShort(datarec[22], datarec[23]);
        if (day < 0 || day > 366) {
            year = this.converter.swapShort(year);
            day = this.converter.swapShort(day);
        }
        String path = new String(String.valueOf(this.Cwd) + fileSep + stn + "." + net);
        String out_fname = new String(String.valueOf(stn) + "." + net + "." + loc + "." + chn + "." + year + "." + day);
        this.appendDataRec(path, out_fname, datarec);
    }

    public void write(String buffer) {
        Integer blk_type = new Integer(buffer.substring(0, 3).trim());
        switch (blk_type) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.put_abbrev_info(buffer);
                break;
            }
            case 50: {
                this.put_stn_info(buffer);
                break;
            }
            case 51: {
                this.put_stn_comments(buffer);
                break;
            }
            case 52: {
                this.put_chn_info(buffer);
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                this.put_chn_resps(buffer);
                break;
            }
            case 59: {
                this.put_chn_comments(buffer);
                break;
            }
        }
    }

    private void put_stn_info(String buffer) {
        this.now_stn = new String(buffer.substring(7, 12).trim());
        this.now_net = new String(buffer.substring(buffer.length() - 2, buffer.length())).trim();
        String out_path = new String(String.valueOf(this.Cwd) + fileSep + this.now_stn + "." + this.now_net);
        this.append(out_path, "B050", buffer);
    }

    private void put_stn_comments(String buffer) {
        String out_path = new String(String.valueOf(this.Cwd) + fileSep + this.now_stn + "." + this.now_net);
        this.append(out_path, "B051", buffer);
    }

    private void put_chn_info(String buffer) {
        this.now_chn = new String(buffer.substring(9, 12).trim());
        this.now_loc = new String(buffer.substring(7, 9).trim());
        String out_path = new String(String.valueOf(this.Cwd) + fileSep + this.now_stn + "." + this.now_net + fileSep + this.now_chn + "." + this.now_loc);
        this.append(out_path, "B052", buffer);
    }

    private void put_chn_resps(String buffer) {
        String out_path = new String(String.valueOf(this.Cwd) + fileSep + this.now_stn + "." + this.now_net + fileSep + this.now_chn + "." + this.now_loc);
        this.append(out_path, "B052", buffer);
    }

    private void put_chn_comments(String buffer) {
        String out_path = new String(String.valueOf(this.Cwd) + fileSep + this.now_stn + "." + this.now_net + fileSep + this.now_chn + "." + this.now_loc);
        this.append(out_path, "B059", buffer);
    }

    private void put_abbrev_info(String abbr) {
        String out_fname = new String(String.valueOf(this.Cwd) + fileSep + this.HA_fname);
        if (this.file_open) {
            if (out_fname.compareTo(String.valueOf(this.out_file.getParent()) + fileSep + this.out_file.getName()) == 0) {
                try {
                    this.rf.writeBytes(abbr);
                    this.rf.write(10);
                }
                catch (IOException e) {
                    System.out.println("Unable to write abbreviations. IO error:" + e.getMessage());
                }
                return;
            }
            try {
                this.rf.close();
            }
            catch (IOException e) {
                System.out.println("Unable to properly close file: " + out_fname);
                return;
            }
        }
        this.open_file(this.Cwd, this.HA_fname);
        try {
            this.rf.writeBytes(abbr);
            this.rf.write(10);
        }
        catch (IOException e) {
            System.out.println("Unable to write abbreviations. Io error:" + e.getMessage());
            return;
        }
    }

    private void append(String path, String out_fname, String b) {
        String full_file_name = new String(String.valueOf(path) + fileSep + out_fname);
        if (this.file_open) {
            if (full_file_name.compareTo(String.valueOf(this.out_file.getParent()) + fileSep + this.out_file.getName()) == 0) {
                try {
                    this.rf.writeBytes(b);
                    this.rf.write(10);
                }
                catch (IOException e) {
                    System.out.println("Unable to write data record. IO error:" + e.getMessage());
                    return;
                }
                return;
            }
            try {
                this.rf.close();
            }
            catch (IOException e) {
                System.out.println("Unable to properly close file: " + full_file_name);
                return;
            }
        }
        this.open_file(path, out_fname);
        try {
            this.rf.writeBytes(b);
            this.rf.write(10);
        }
        catch (IOException e) {
            System.out.println("Unable to write blockette. Io error:" + e.getMessage());
        }
    }

    private void appendDataRec(String path, String out_fname, byte[] b) {
        String full_file_name = new String(String.valueOf(path) + fileSep + out_fname);
        if (this.file_open) {
            if (full_file_name.compareTo(String.valueOf(this.out_file.getParent()) + fileSep + this.out_file.getName()) == 0) {
                try {
                    this.rf.write(b);
                }
                catch (IOException e) {
                    System.out.println("Unable to write data record. IO error:" + e.getMessage());
                }
                return;
            }
            try {
                this.rf.close();
                this.file_open = false;
            }
            catch (IOException e) {
                System.out.println("Unable to properly close file: " + full_file_name);
                return;
            }
        }
        this.open_file(path, out_fname);
        try {
            this.rf.write(b);
        }
        catch (IOException e) {
            System.out.println("Unable to write data record. IO error:" + e.getMessage());
            return;
        }
    }
}

