/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette32;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class Blockette72
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette72() {
    }

    public Blockette72(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette72(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette72(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt2_2d = new Format("%2.2d");
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt10_4e = new Format("%10.4E");
            Format fmt2s = new Format("%-2s");
            Format fmt3s = new Format("%-3s");
            Format fmt5s = new Format("%-5s");
            Format fmt_vars = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt5s.format((String)this.get("Station"));
            blktStr = String.valueOf(blktStr) + fmt2s.format((String)this.get("Location ID"));
            blktStr = String.valueOf(blktStr) + fmt3s.format((String)this.get("Channel"));
            blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)this.get("Arrival time")).toSeedString());
            blktStr = String.valueOf(blktStr) + fmt10_4e.format((Double)this.get("Amplitude of signal"));
            blktStr = String.valueOf(blktStr) + fmt10_4e.format((Double)this.get("Period of signal (seconds)"));
            blktStr = String.valueOf(blktStr) + fmt10_4e.format((Double)this.get("Signal-to-noise ratio"));
            blktStr = String.valueOf(blktStr) + fmt_vars.format((String)this.get("Phase name"));
            int mapType = 5;
            Blockette32 sourceAbbrev = (Blockette32)this.get("Source");
            int lookupVal = this.lookupMap.getLookup(mapType, sourceAbbrev);
            blktStr = String.valueOf(blktStr) + fmt2_2d.format(lookupVal);
            blktStr = String.valueOf(blktStr) + fmt2s.format((String)this.get("Network"));
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            Object tmpList = null;
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 5;
            this.put("Station", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = (sIdx += 5) + 2;
            this.put("Location ID", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = (sIdx += 2) + 3;
            this.put("Channel", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
            this.put("Arrival time", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = sIdx + 10;
            this.put("Amplitude of signal", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 10;
            this.put("Period of signal (seconds)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 10;
            this.put("Signal-to-noise ratio", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 10).indexOf(126) + sIdx;
            this.put("Phase name", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = sIdx + 2;
            Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int mapType = 5;
            Blockette32 sourceAbbrev = (Blockette32)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Source", sourceAbbrev);
            eIdx = (sIdx += 2) + 2;
            this.put("Network", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Station");
        this.paramOutputType.put("Station", "%-5s");
        this.paramInputType.put("Station", new Integer(0));
        this.respFieldNames.add("Station");
        this.paramLookup.put("04", "Location ID");
        this.paramOutputType.put("Location ID", "%-2s");
        this.paramInputType.put("Location ID", new Integer(0));
        this.respFieldNames.add("Location ID");
        this.paramLookup.put("05", "Channel");
        this.paramOutputType.put("Channel", "%-3s");
        this.paramInputType.put("Channel", new Integer(0));
        this.respFieldNames.add("Channel");
        this.paramLookup.put("06", "Arrival time");
        this.paramOutputType.put("Arrival time", "%s");
        this.paramInputType.put("Arrival time", new Integer(3));
        this.respFieldNames.add("Arrival time");
        this.paramLookup.put("07", "Amplitude of signal");
        this.paramOutputType.put("Amplitude of signal", "%10.4E");
        this.paramInputType.put("Amplitude of signal", new Integer(2));
        this.respFieldNames.add("Amplitude of signal");
        this.paramLookup.put("08", "Period of signal (seconds)");
        this.paramOutputType.put("Period of signal (seconds)", "%10.4E");
        this.paramInputType.put("Period of signal (seconds)", new Integer(2));
        this.respFieldNames.add("Period of signal (seconds)");
        this.paramLookup.put("09", "Signal-to-noise ratio");
        this.paramOutputType.put("Signal-to-noise ratio", "%10.4E");
        this.paramInputType.put("Signal-to-noise ratio", new Integer(2));
        this.respFieldNames.add("Signal-to-noise ratio");
        this.paramLookup.put("10", "Phase name");
        this.paramOutputType.put("Phase name", "%s");
        this.paramInputType.put("Phase name", new Integer(0));
        this.respFieldNames.add("Phase name");
        this.paramLookup.put("11", "Source");
        this.paramOutputType.put("Source", "%s");
        this.paramInputType.put("Source", new Integer(5));
        this.respFieldNames.add("Source");
        this.idxFieldNames = "Source";
        this.paramLookup.put("12", "Network");
        this.paramOutputType.put("Network", "%-2s");
        this.paramInputType.put("Network", new Integer(0));
        this.respFieldNames.add("Network");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b072 = TestData.test_b072a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String source1 = "NEIC PDE WEEKLY LISTING~3 92 Preliminary Determination of Epicenters~National Earthquake Information Center, USGS~";
        Blockette32 sourceVal = new Blockette32();
        sourceVal.compStringToObj(source1, lm);
        lm.setLookup(5, new Integer(2), sourceVal);
        Blockette72 test_val = new Blockette72(test_b072, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b072.length());
        System.out.println(test_val.toString().compareTo(test_b072) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
        try {
            String fileSep = System.getProperty("file.separator");
            String infile = "test-files" + fileSep + "eventphaseblkt.resp";
            BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            StandaloneLookupMap lm2 = new StandaloneLookupMap();
            Blockette72 test_val2 = new Blockette72(rd, lm2, 72);
            System.out.println("-------- test #3 --------");
            System.out.println(test_val2);
            test_val2.echoResp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

