/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.SeedResponseBlockette;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Date;

public class Blockette61
extends SeedResponseBlockette {
    private static final long serialVersionUID = 1L;
    public static final int MAXNUMCOEFFS = 710;

    public Blockette61() {
    }

    public Blockette61(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette61(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        String tfType = (String)this.get("Symmetry type");
        if (tfType == null) {
            throw new ParseStageException("symmetry type not found");
        }
        this.put("Symmetry type", tfType.substring(0, 1));
        this.checkNumParams();
    }

    public Blockette61(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        String tfType = (String)this.get("Symmetry type");
        if (tfType == null) {
            throw new ParseStageException("symmetry type not found");
        }
        this.put("Symmetry type", tfType.substring(0, 1));
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList coefficientsRet = (ArrayList)this.get("coefficients");
        if (((Integer)this.get("Number of coefficients")).intValue() != coefficientsRet.size()) {
            throw new ParseStageException("'Number of coefficients' found (" + coefficientsRet.size() + " != 'Number of coefficients' in blockette (" + (Integer)this.get("Number of responses") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        String respHdr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmt14_7e = new Format("%14.7E");
        Format fmtvar_str = new Format("%s~");
        if (paramFlag) {
            respHdr = String.valueOf(respHdr) + fmt2_2d.format((Integer)this.get("Stage sequence number"));
            respHdr = String.valueOf(respHdr) + fmtvar_str.format((String)this.get("Response name"));
            respHdr = String.valueOf(respHdr) + (String)this.get("Symmetry type");
            int mapType = 8;
            Blockette34 unitsAbbrev = (Blockette34)this.get("Response input units");
            int lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
            unitsAbbrev = (Blockette34)this.get("Response output units");
            lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
        }
        int nCoeffs = (Integer)this.get("Number of coefficients");
        if (listParamFlag) {
            int coeffIdx = 0;
            int totNum = 0;
            ArrayList coefficientList = (ArrayList)this.get("coefficients");
            while (true) {
                String valStr = "";
                int coeffsInBlkt = 0;
                while (coeffsInBlkt < 710 && totNum < nCoeffs) {
                    ArrayList vals = (ArrayList)coefficientList.get(coeffIdx);
                    double val = (Double)vals.get(0);
                    valStr = String.valueOf(valStr) + fmt14_7e.format(val);
                    ++coeffIdx;
                    ++totNum;
                    ++coeffsInBlkt;
                }
                blktStr = paramFlag ? String.valueOf(blktStr) + respHdr + fmt4_4d.format(coeffsInBlkt) + valStr : String.valueOf(blktStr) + valStr;
                if (coeffsInBlkt == 710 && totNum != nCoeffs) {
                    if (paramFlag) {
                        returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
                        returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr + "\n";
                    } else {
                        returnVal = String.valueOf(returnVal) + blktStr + "\n";
                    }
                } else {
                    if (paramFlag) {
                        blktStr = String.valueOf(respHdr) + fmt4_4d.format(coeffsInBlkt) + valStr;
                        break;
                    }
                    blktStr = valStr;
                    break;
                }
                coeffsInBlkt = 0;
                blktStr = "";
            }
        }
        if (paramFlag) {
            if (!listParamFlag) {
                blktStr = String.valueOf(respHdr) + fmt3_3d.format(nCoeffs);
            }
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        } else {
            returnVal = String.valueOf(returnVal) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList coefficientList = new ArrayList();
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            int ncoeffs = 0;
            int tmpIdx = -1;
            boolean isFirst = true;
            do {
                Integer tmpVal;
                if (isFirst) {
                    this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 3) + 4;
                    eIdx = (sIdx += 4) + 2;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    this.put("Stage sequence number", tmpVal);
                    eIdx = blktInfo.substring(sIdx += 2).indexOf(126) + sIdx;
                    this.put("Response name", new String(blktInfo.substring(sIdx, eIdx).trim()));
                    sIdx = eIdx + 1;
                    eIdx = sIdx + 1;
                    this.put("Symmetry type", new String(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = ++sIdx + 3;
                    Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    int mapType = 8;
                    Blockette34 unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response input units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 3;
                    lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    mapType = 8;
                    unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response output units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 4;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    ncoeffs += tmpVal.intValue();
                    sIdx += 4;
                    isFirst = false;
                } else {
                    prevStageSeqNo = stageSeqNo;
                    eIdx = (sIdx += 7) + 3;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
                    sIdx = eIdx + 7;
                    eIdx = sIdx + 4;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    ncoeffs += tmpVal.intValue();
                    sIdx += 4;
                }
                int i = 0;
                while (i < tmpVal) {
                    eIdx = sIdx + 14;
                    ArrayList<Double> vals = new ArrayList<Double>();
                    vals.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    coefficientList.add(vals);
                    sIdx += 14;
                    ++i;
                }
                tmpIdx = blktInfo.substring(sIdx).indexOf("\n");
                if (tmpIdx < 0) break;
                sIdx = tmpIdx + sIdx + 1;
            } while (prevStageSeqNo < 0 || stageSeqNo == prevStageSeqNo);
            this.put("Number of coefficients", new Integer(ncoeffs));
            this.put("coefficients", coefficientList);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Stage sequence number");
        this.paramOutputType.put("Stage sequence number", "%d");
        this.paramInputType.put("Stage sequence number", new Integer(1));
        this.respFieldNames.add("Stage sequence number");
        this.paramLookup.put("04", "Response name");
        this.paramOutputType.put("Response name", "%s");
        this.paramInputType.put("Response name", new Integer(0));
        this.put("Response name", new String(""));
        this.paramLookup.put("05", "Symmetry type");
        this.paramOutputType.put("Symmetry type", "%s");
        this.paramInputType.put("Symmetry type", new Integer(0));
        this.respFieldNames.add("Symmetry type");
        this.paramLookup.put("06", "Response input units");
        this.paramOutputType.put("Response input units", "%s");
        this.paramInputType.put("Response input units", new Integer(8));
        this.respFieldNames.add("Response input units");
        this.paramLookup.put("07", "Response output units");
        this.paramOutputType.put("Response output units", "%s");
        this.paramInputType.put("Response output units", new Integer(8));
        this.respFieldNames.add("Response output units");
        this.paramLookup.put("08", "Number of coefficients");
        this.paramOutputType.put("Number of coefficients", "%d");
        this.paramInputType.put("Number of coefficients", new Integer(1));
        this.respFieldNames.add("Number of coefficients");
        this.listParamLookup.put("09", "coefficients");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(2));
        this.listParamInputTypes.put("coefficients", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%14.7E");
        this.listParamOutputTypes.put("coefficients", tmpList);
        this.put("coefficients", new ArrayList());
        this.respFieldNames.add("coefficients");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b061 = TestData.test_b061a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String unitsStr = "M/S - Velocity in Meters Per Second";
        Blockette34 unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(1), unitsVal);
        unitsStr = "V - Volts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(2), unitsVal);
        unitsStr = "COUNTS - Digital Counts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(3), unitsVal);
        Blockette61 test_val = new Blockette61(test_b061, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b061.length());
        System.out.println(test_val.toString().compareTo(test_b061) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("     Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("FIR Coefficients Hash to value of: " + test_val.getListParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

