/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.SeedResponseBlockette;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Date;

public class Blockette54
extends SeedResponseBlockette {
    private static final long serialVersionUID = 1L;
    private ArrayList numerators;
    private ArrayList numeratorErrors;
    private ArrayList denominators;
    private ArrayList denominatorErrors;
    public static final int MAXNUMCOEFFS = 400;

    public Blockette54() {
    }

    public Blockette54(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette54(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        String tfType = (String)this.get("Transfer function type");
        if (tfType == null) {
            throw new ParseStageException("response type not found");
        }
        this.put("Transfer function type", tfType.substring(0, 1));
        this.checkNumParams();
    }

    public Blockette54(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        String tfType = (String)this.get("Transfer function type");
        if (tfType == null) {
            throw new ParseStageException("response type not found");
        }
        this.put("Transfer function type", tfType.substring(0, 1));
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList numeratorsRet = (ArrayList)this.get("numerators");
        ArrayList denominatorsRet = (ArrayList)this.get("denominators");
        if (((Integer)this.get("Number of numerators")).intValue() != numeratorsRet.size()) {
            throw new ParseStageException("'Number of numerators' found (" + numeratorsRet.size() + " != 'Number of numerators' in blockette (" + (Integer)this.get("Number of numerators") + ")");
        }
        if (((Integer)this.get("Number of denominators")).intValue() != denominatorsRet.size()) {
            throw new ParseStageException("'Number of denominators' found (" + denominatorsRet.size() + " != 'Number of denominators' in blockette (" + (Integer)this.get("Number of denominators") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        String respHdr = "";
        Format fmt2_2d = new Format("%2.2d");
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmt5_5d = new Format("%5.5d");
        Format fmt12_5e = new Format("%12.5E");
        if (paramFlag) {
            respHdr = String.valueOf(respHdr) + (String)this.get("Transfer function type");
            respHdr = String.valueOf(respHdr) + fmt2_2d.format((Integer)this.get("Stage sequence number"));
            int mapType = 8;
            Blockette34 unitsAbbrev = (Blockette34)this.get("Response input units");
            int lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
            unitsAbbrev = (Blockette34)this.get("Response output units");
            lookupVal = this.lookupMap.getLookup(mapType, unitsAbbrev);
            respHdr = String.valueOf(respHdr) + fmt3_3d.format(lookupVal);
        }
        int nnum = (Integer)this.get("Number of numerators");
        int ndenom = (Integer)this.get("Number of denominators");
        if (listParamFlag) {
            int numIdx = 0;
            int denomIdx = 0;
            int totNum = 0;
            ArrayList numerators = (ArrayList)this.get("numerators");
            ArrayList denominators = (ArrayList)this.get("denominators");
            while (true) {
                String numStr = "";
                String denomStr = "";
                int nBlktCoeffs = 0;
                int numInBlkt = 0;
                int denomInBlkt = 0;
                while (nBlktCoeffs < 400 && totNum < nnum + ndenom) {
                    ArrayList listVal;
                    if (totNum < nnum) {
                        listVal = (ArrayList)numerators.get(numIdx);
                        numStr = String.valueOf(numStr) + fmt12_5e.format((Double)listVal.get(0));
                        numStr = String.valueOf(numStr) + fmt12_5e.format((Double)listVal.get(1));
                        ++numIdx;
                        ++totNum;
                        ++nBlktCoeffs;
                        ++numInBlkt;
                        continue;
                    }
                    listVal = (ArrayList)denominators.get(denomIdx);
                    denomStr = String.valueOf(denomStr) + fmt12_5e.format((Double)listVal.get(0));
                    denomStr = String.valueOf(denomStr) + fmt12_5e.format((Double)listVal.get(1));
                    ++denomIdx;
                    ++totNum;
                    ++nBlktCoeffs;
                    ++denomInBlkt;
                }
                if (nBlktCoeffs == 400 && totNum != nnum + ndenom) {
                    blktStr = numInBlkt > 0 && denomInBlkt == 0 ? (paramFlag ? String.valueOf(blktStr) + respHdr + fmt4_4d.format(numInBlkt) + numStr + fmt4_4d.format(0) : String.valueOf(blktStr) + numStr) : (denomInBlkt > 0 && numInBlkt == 0 ? (paramFlag ? String.valueOf(blktStr) + respHdr + fmt4_4d.format(0) + fmt4_4d.format(denomInBlkt) + denomStr : String.valueOf(blktStr) + denomStr) : (paramFlag ? String.valueOf(blktStr) + respHdr + fmt4_4d.format(numInBlkt) + numStr + fmt4_4d.format(denomInBlkt) + denomStr : String.valueOf(blktStr) + numStr + denomStr));
                    if (paramFlag) {
                        returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
                        returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr + "\n";
                    } else {
                        returnVal = String.valueOf(returnVal) + blktStr + "\n";
                    }
                } else {
                    if (paramFlag) {
                        blktStr = String.valueOf(respHdr) + fmt4_4d.format(numInBlkt) + numStr + fmt4_4d.format(denomInBlkt) + denomStr;
                        break;
                    }
                    blktStr = String.valueOf(numStr) + denomStr;
                    break;
                }
                nBlktCoeffs = 0;
                blktStr = "";
            }
        }
        if (paramFlag) {
            if (!listParamFlag) {
                blktStr = String.valueOf(respHdr) + fmt3_3d.format(nnum) + fmt3_3d.format(ndenom);
            }
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        } else {
            returnVal = String.valueOf(returnVal) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            this.numerators = new ArrayList();
            this.denominators = new ArrayList();
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            int nnum = 0;
            int ndenom = 0;
            int tmpIdx = -1;
            boolean isFirst = true;
            do {
                Integer tmpVal;
                if (isFirst) {
                    this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 3) + 4;
                    eIdx = (sIdx += 4) + 1;
                    this.put("Transfer function type", blktInfo.substring(sIdx, eIdx).trim());
                    eIdx = ++sIdx + 2;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    this.put("Stage sequence number", tmpVal);
                    eIdx = (sIdx += 2) + 3;
                    Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    int mapType = 8;
                    Blockette34 unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response input units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 3;
                    lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    mapType = 8;
                    unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
                    this.put("Response output units", unitsAbbrev);
                    eIdx = (sIdx += 3) + 4;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    nnum += tmpVal.intValue();
                    sIdx += 4;
                    isFirst = false;
                } else {
                    prevStageSeqNo = stageSeqNo;
                    eIdx = (sIdx += 8) + 2;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    stageSeqNo = tmpVal;
                    eIdx = (sIdx += 8) + 4;
                    tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                    nnum += tmpVal.intValue();
                    sIdx += 4;
                }
                int i = 0;
                while (i < tmpVal) {
                    ArrayList<Double> numerator = new ArrayList<Double>();
                    eIdx = sIdx + 12;
                    numerator.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    numerator.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    sIdx += 12;
                    this.numerators.add(numerator);
                    ++i;
                }
                eIdx = sIdx + 4;
                tmpVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
                ndenom += tmpVal.intValue();
                sIdx += 4;
                i = 0;
                while (i < tmpVal) {
                    ArrayList<Double> denominator = new ArrayList<Double>();
                    eIdx = sIdx + 12;
                    denominator.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    eIdx = (sIdx += 12) + 12;
                    denominator.add(new Double(blktInfo.substring(sIdx, eIdx).trim()));
                    sIdx += 12;
                    this.denominators.add(denominator);
                    ++i;
                }
                tmpIdx = blktInfo.substring(sIdx).indexOf("\n");
                if (tmpIdx < 0) break;
                sIdx = tmpIdx + sIdx + 1;
            } while (prevStageSeqNo < 0 || stageSeqNo == prevStageSeqNo);
            this.put("Number of numerators", new Integer(nnum));
            this.put("numerators", this.numerators);
            this.put("Number of denominators", new Integer(ndenom));
            this.put("denominators", this.denominators);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Transfer function type");
        this.paramOutputType.put("Transfer function type", "%s");
        this.paramInputType.put("Transfer function type", new Integer(0));
        this.respFieldNames.add("Transfer function type");
        this.paramLookup.put("04", "Stage sequence number");
        this.paramOutputType.put("Stage sequence number", "%d");
        this.paramInputType.put("Stage sequence number", new Integer(1));
        this.respFieldNames.add("Stage sequence number");
        this.paramLookup.put("05", "Response input units");
        this.paramOutputType.put("Response input units", "%s");
        this.paramInputType.put("Response input units", new Integer(8));
        this.respFieldNames.add("Response input units");
        this.paramLookup.put("06", "Response output units");
        this.paramOutputType.put("Response output units", "%s");
        this.paramInputType.put("Response output units", new Integer(8));
        this.respFieldNames.add("Response output units");
        this.paramLookup.put("07", "Number of numerators");
        this.paramOutputType.put("Number of numerators", "%d");
        this.paramInputType.put("Number of numerators", new Integer(1));
        this.respFieldNames.add("Number of numerators");
        this.paramLookup.put("10", "Number of denominators");
        this.paramOutputType.put("Number of denominators", "%d");
        this.paramInputType.put("Number of denominators", new Integer(1));
        this.respFieldNames.add("Number of denominators");
        this.listParamLookup.put("08-09", "numerators");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        this.listParamInputTypes.put("numerators", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        this.listParamOutputTypes.put("numerators", tmpList);
        this.put("numerators", new ArrayList());
        this.respFieldNames.add("numerators");
        this.listParamLookup.put("11-12", "denominators");
        tmpList = new ArrayList();
        tmpList.add(new Integer(2));
        tmpList.add(new Integer(2));
        this.listParamInputTypes.put("denominators", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%12.5E");
        tmpList.add("%12.5E");
        this.listParamOutputTypes.put("denominators", tmpList);
        this.put("denominators", new ArrayList());
        this.respFieldNames.add("denominators");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b054 = TestData.test_b054c;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String unitsStr = "M/S - Velocity in Meters Per Second";
        Blockette34 unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(1), unitsVal);
        unitsStr = "V - Volts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(2), unitsVal);
        unitsStr = "COUNTS - Digital Counts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(3), unitsVal);
        Blockette54 test_val = new Blockette54(test_b054, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b054.length());
        System.out.println(test_val.toString().compareTo(test_b054) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("Coefficient Values Hash to value of: " + test_val.getListParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

