/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.Blockette30;
import edu.iris.seedutils.Blockette33;
import edu.iris.seedutils.Blockette34;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class Blockette52
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette52(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette52(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette52(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt1s = new Format("%1s");
            Format fmt2s = new Format("%-2s");
            Format fmt3s = new Format("%-3s");
            Format fmt2_2d = new Format("%2.2d");
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt5_1f = new Format("%5.1f");
            Format fmt7_1f = new Format("%7.1f");
            Format fmt10_4e = new Format("%10.4E");
            Format fmt10_6f = new Format("%10.6f");
            Format fmt11_6f = new Format("%11.6f");
            Format fmtvar_str = new Format("%s~");
            blktStr = String.valueOf(blktStr) + fmt2s.format((String)this.get("Location ID"));
            blktStr = String.valueOf(blktStr) + fmt3s.format((String)this.get("Channel"));
            blktStr = String.valueOf(blktStr) + fmt4_4d.format((Integer)this.get("Subchannel ID"));
            Blockette33 genAbbrev = (Blockette33)this.get("Instrument");
            int mapType = 7;
            int lookupVal = this.lookupMap.getLookup(mapType, genAbbrev);
            blktStr = String.valueOf(blktStr) + fmt3_3d.format(lookupVal);
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Comment"));
            mapType = 8;
            Blockette34 unitsAbbrev = (Blockette34)this.get("Signal response units");
            lookupVal = unitsAbbrev != null ? this.lookupMap.getLookup(mapType, unitsAbbrev) : 0;
            blktStr = String.valueOf(blktStr) + fmt3_3d.format(lookupVal);
            mapType = 8;
            unitsAbbrev = (Blockette34)this.get("Calibration input units");
            lookupVal = unitsAbbrev != null ? this.lookupMap.getLookup(mapType, unitsAbbrev) : 0;
            blktStr = String.valueOf(blktStr) + fmt3_3d.format(lookupVal);
            blktStr = String.valueOf(blktStr) + fmt10_6f.format((Double)this.get("Latitude (degrees)"));
            blktStr = String.valueOf(blktStr) + fmt11_6f.format((Double)this.get("Longitude (degrees)"));
            blktStr = String.valueOf(blktStr) + fmt7_1f.format((Double)this.get("Elevation (m)"));
            blktStr = String.valueOf(blktStr) + fmt5_1f.format((Double)this.get("Emplacement depth (m)"));
            blktStr = String.valueOf(blktStr) + fmt5_1f.format((Double)this.get("Azimuth (degrees)"));
            blktStr = String.valueOf(blktStr) + fmt5_1f.format((Double)this.get("Dip (degrees)"));
            mapType = 4;
            Blockette30 dataAbbrev = (Blockette30)this.get("Data format");
            lookupVal = this.lookupMap.getLookup(mapType, dataAbbrev);
            blktStr = String.valueOf(blktStr) + fmt4_4d.format(lookupVal);
            blktStr = String.valueOf(blktStr) + fmt2_2d.format((Integer)this.get("Record length"));
            blktStr = String.valueOf(blktStr) + fmt10_4e.format((Double)this.get("Sample rate (Hz)"));
            blktStr = String.valueOf(blktStr) + fmt10_4e.format((Double)this.get("Max clock drift (seconds)"));
            blktStr = String.valueOf(blktStr) + fmt4_4d.format((Integer)this.get("Number of channel comments"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Channel flags"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format(((TimeStamp)this.get("Start date")).toSeedString());
            String tmpStr = ((TimeStamp)this.get("End date")).toSeedString();
            blktStr = tmpStr.compareTo("5138,320,09:46:39.9999") == 0 ? String.valueOf(blktStr) + fmtvar_str.format("") : String.valueOf(blktStr) + fmtvar_str.format(tmpStr);
            blktStr = String.valueOf(blktStr) + fmt1s.format((String)this.get("Update flag"));
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            String tmpStr = blktInfo.substring(sIdx, eIdx).trim();
            if (tmpStr.length() == 0) {
                tmpStr = "0";
            }
            this.setType(new Integer(tmpStr));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 2;
            this.put("Location ID", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = (sIdx += 2) + 3;
            this.put("Channel", blktInfo.substring(sIdx, eIdx).trim());
            eIdx = (sIdx += 3) + 4;
            tmpStr = blktInfo.substring(sIdx, eIdx).trim();
            if (tmpStr.length() == 0) {
                tmpStr = "0";
            }
            this.put("Subchannel ID", new Integer(tmpStr));
            eIdx = (sIdx += 4) + 3;
            Integer lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int mapType = 7;
            Blockette33 genAbbrev = (Blockette33)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Instrument", genAbbrev);
            eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
            this.put("Comment", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = sIdx + 3;
            lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            mapType = 8;
            Blockette34 unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Signal response units", unitsAbbrev);
            eIdx = (sIdx += 3) + 3;
            lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            mapType = 8;
            unitsAbbrev = (Blockette34)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Calibration input units", unitsAbbrev);
            eIdx = (sIdx += 3) + 10;
            this.put("Latitude (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 11;
            this.put("Longitude (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 11) + 7;
            this.put("Elevation (m)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 7) + 5;
            this.put("Emplacement depth (m)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 5) + 5;
            this.put("Azimuth (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 5) + 5;
            this.put("Dip (degrees)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 5) + 4;
            lookupVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            mapType = 4;
            Blockette30 dataAbbrev = (Blockette30)this.lookupMap.getMatch(mapType, lookupVal);
            this.put("Data format", dataAbbrev);
            eIdx = (sIdx += 4) + 2;
            this.put("Record length", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 2) + 10;
            this.put("Sample rate (Hz)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 10;
            this.put("Max clock drift (seconds)", new Double(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 10) + 4;
            String testStr = blktInfo.substring(sIdx, eIdx).trim();
            if (testStr.length() == 0) {
                this.put("Number of channel comments", new Integer(0));
            } else {
                this.put("Number of channel comments", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            }
            eIdx = blktInfo.substring(sIdx += 4).indexOf(126) + sIdx;
            this.put("Channel flags", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            this.put("Start date", TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            if (sIdx != eIdx) {
                tmpStr = blktInfo.substring(sIdx, eIdx).trim();
                if (tmpStr.length() == 0) {
                    this.put("End date", TimeStamp.buildTimestamp("99999999999.9999"));
                } else {
                    this.put("End date", TimeStamp.buildTimestamp(tmpStr));
                }
            } else {
                this.put("End date", TimeStamp.buildTimestamp("99999999999.9999"));
            }
            sIdx = eIdx + 1;
            eIdx = sIdx + 1;
            this.put("Update flag", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Location ID");
        this.paramOutputType.put("Location ID", "%s");
        this.paramInputType.put("Location ID", new Integer(0));
        this.respFieldNames.add("Location ID");
        this.paramLookup.put("04", "Channel");
        this.paramOutputType.put("Channel", "%s");
        this.paramInputType.put("Channel", new Integer(0));
        this.respFieldNames.add("Channel");
        this.paramLookup.put("05", "Subchannel ID");
        this.paramOutputType.put("Subchannel ID", "%4.4d");
        this.paramInputType.put("Subchannel ID", new Integer(1));
        this.respFieldNames.add("Subchannel ID");
        this.paramLookup.put("06", "Instrument");
        this.paramOutputType.put("Instrument", "%s");
        this.paramInputType.put("Instrument", new Integer(7));
        this.respFieldNames.add("Instrument");
        this.paramLookup.put("07", "Comment");
        this.paramOutputType.put("Comment", "%s");
        this.paramInputType.put("Comment", new Integer(0));
        this.respFieldNames.add("Comment");
        this.paramLookup.put("08", "Signal response units");
        this.paramOutputType.put("Signal response units", "%s");
        this.paramInputType.put("Signal response units", new Integer(8));
        this.respFieldNames.add("Signal response units");
        this.paramLookup.put("09", "Calibration input units");
        this.paramOutputType.put("Calibration input units", "%s");
        this.paramInputType.put("Calibration input units", new Integer(8));
        this.respFieldNames.add("Calibration input units");
        this.paramLookup.put("10", "Latitude (degrees)");
        this.paramOutputType.put("Latitude (degrees)", "%10.6f");
        this.paramInputType.put("Latitude (degrees)", new Integer(2));
        this.respFieldNames.add("Latitude (degrees)");
        this.paramLookup.put("11", "Longitude (degrees)");
        this.paramOutputType.put("Longitude (degrees)", "%11.6f");
        this.paramInputType.put("Longitude (degrees)", new Integer(2));
        this.respFieldNames.add("Longitude (degrees)");
        this.paramLookup.put("12", "Elevation (m)");
        this.paramOutputType.put("Elevation (m)", "%7.1f");
        this.paramInputType.put("Elevation (m)", new Integer(2));
        this.respFieldNames.add("Elevation (m)");
        this.paramLookup.put("13", "Emplacement depth (m)");
        this.paramOutputType.put("Emplacement depth (m)", "%5.1f");
        this.paramInputType.put("Emplacement depth (m)", new Integer(2));
        this.respFieldNames.add("Emplacement depth (m)");
        this.paramLookup.put("14", "Azimuth (degrees)");
        this.paramOutputType.put("Azimuth (degrees)", "%5.1f");
        this.paramInputType.put("Azimuth (degrees)", new Integer(2));
        this.respFieldNames.add("Azimuth (degrees)");
        this.paramLookup.put("15", "Dip (degrees)");
        this.paramOutputType.put("Dip (degrees)", "%5.1f");
        this.paramInputType.put("Dip (degrees)", new Integer(2));
        this.respFieldNames.add("Dip (degrees)");
        this.paramLookup.put("16", "Data format");
        this.paramOutputType.put("Data format", "%s");
        this.paramInputType.put("Data format", new Integer(4));
        this.respFieldNames.add("Data format");
        this.paramLookup.put("17", "Record length");
        this.paramOutputType.put("Record length", "%d");
        this.paramInputType.put("Record length", new Integer(1));
        this.respFieldNames.add("Record length");
        this.paramLookup.put("18", "Sample rate (Hz)");
        this.paramOutputType.put("Sample rate (Hz)", "%10.4E");
        this.paramInputType.put("Sample rate (Hz)", new Integer(2));
        this.respFieldNames.add("Sample rate (Hz)");
        this.paramLookup.put("19", "Max clock drift (seconds)");
        this.paramOutputType.put("Max clock drift (seconds)", "%10.4E");
        this.paramInputType.put("Max clock drift (seconds)", new Integer(2));
        this.respFieldNames.add("Max clock drift (seconds)");
        this.paramLookup.put("20", "Number of channel comments");
        this.paramOutputType.put("Number of channel comments", "%d");
        this.paramInputType.put("Number of channel comments", new Integer(1));
        this.respFieldNames.add("Number of channel comments");
        this.paramLookup.put("21", "Channel flags");
        this.paramOutputType.put("Channel flags", "%s");
        this.paramInputType.put("Channel flags", new Integer(0));
        this.respFieldNames.add("Channel flags");
        this.paramLookup.put("22", "Start date");
        this.paramOutputType.put("Start date", "%s");
        this.paramInputType.put("Start date", new Integer(3));
        this.respFieldNames.add("Start date");
        this.paramLookup.put("23", "End date");
        this.paramOutputType.put("End date", "%s");
        this.paramInputType.put("End date", new Integer(3));
        this.respFieldNames.add("End date");
        this.paramLookup.put("24", "Update flag");
        this.paramOutputType.put("Update flag", "%s");
        this.paramInputType.put("Update flag", new Integer(0));
        this.respFieldNames.add("Update flag");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b052 = TestData.test_b052a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        String genStr = "Streckeisen STS-1V/VBB Seismometer";
        Blockette33 genVal = new Blockette33();
        genVal.compStringToObj(genStr, lm);
        lm.setLookup(7, new Integer(2), genVal);
        String unitsStr = "M/S - Velocity in Meters Per Second";
        Blockette34 unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(1), unitsVal);
        unitsStr = "COUNTS - Digital Counts";
        unitsVal = new Blockette34();
        unitsVal.compStringToObj(unitsStr, lm);
        lm.setLookup(8, new Integer(3), unitsVal);
        String dfStr = "Steim Integer Compression Format~05006F1 P4 W4 D0-31 C2 R1 P8 W4 D0-31 C2~P0 W4 N15 S2,0,1~T0 X N0 W4 D0-31 C2~T1 N0 W1 D0-7 C2 N1 W1 D0-7 C2 N2 W1 D0-7 C2 N3 W1 D0-7 C2~T2 N0 W2 D0-15 C2 N1 W2 D0-15 C2~T3 N0 W4 D0-31 C2~";
        Blockette30 dfVal = new Blockette30();
        dfVal.compStringToObj(dfStr, lm);
        lm.setLookup(4, new Integer(2), dfVal);
        Blockette52 test_val = new Blockette52(test_b052, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b052.length());
        System.out.println(test_val.toString().compareTo(test_b052) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
        try {
            String fileSep = System.getProperty("file.separator");
            String infile = "test-files" + fileSep + "chanblkt.resp";
            BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            StandaloneLookupMap lm2 = new StandaloneLookupMap();
            Blockette52 test_val2 = new Blockette52(rd, lm2, 52);
            System.out.println("-------- test #3 --------");
            System.out.println(test_val2);
            test_val2.echoResp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

