/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;

public class Blockette34
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette34() {
    }

    public Blockette34(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette34(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
    }

    public Blockette34(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        Format fmt3_3d = new Format("%3.3d");
        Format fmt4_4d = new Format("%4.4d");
        Format fmtvar_str = new Format("%s~");
        if (paramFlag) {
            blktStr = String.valueOf(blktStr) + fmt3_3d.format((Integer)this.get("Units lookup code"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Units name"));
            blktStr = String.valueOf(blktStr) + fmtvar_str.format((String)this.get("Units description"));
            returnVal = fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            int sIdx = 0;
            int eIdx = sIdx + 3;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 3;
            this.put("Units lookup code", new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = blktInfo.substring(sIdx += 3).indexOf(126) + sIdx;
            this.put("Units name", blktInfo.substring(sIdx, eIdx).trim());
            sIdx = eIdx + 1;
            eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
            this.put("Units description", blktInfo.substring(sIdx, eIdx).trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Units lookup code");
        this.paramOutputType.put("Units lookup code", "%d");
        this.paramInputType.put("Units lookup code", new Integer(1));
        this.respFieldNames.add("Units lookup code");
        this.paramLookup.put("04", "Units name");
        this.paramOutputType.put("Units name", "%s");
        this.paramInputType.put("Units name", new Integer(0));
        this.respFieldNames.add("Units name");
        this.paramLookup.put("05", "Units description");
        this.paramOutputType.put("Units description", "%s");
        this.paramInputType.put("Units description", new Integer(0));
        this.respFieldNames.add("Units description");
    }

    public String objToCompString() {
        return String.valueOf((String)this.get("Units name")) + " - " + (String)this.get("Units description");
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        if (abbrev == null || abbrev.length() == 0) {
            throw new NullPointerException();
        }
        int mapType = 8;
        int splitIdx = abbrev.indexOf(" - ");
        String name = abbrev.substring(0, splitIdx).trim();
        String desc = abbrev.substring(splitIdx + 3).trim();
        this.setLookupMap(lm);
        this.put("Units name", name);
        this.put("Units description", desc);
        this.put("Units lookup code", new Integer(0));
        this.setType(34);
    }

    public static void main(String[] args) {
        String test_b034 = TestData.test_b034a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette34 test_val = new Blockette34(test_b034, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.print("matches '" + test_b034 + "'?  ");
        System.out.println(test_val.toString().compareTo(test_b034) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        System.out.println("Coefficient Values Hash to value of: " + test_val.getListParamElfHash());
    }
}

