/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Date;

public class Blockette12
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette12() {
    }

    public Blockette12(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette12(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        this.checkNumParams();
    }

    public Blockette12(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList tmpList = (ArrayList)this.get("Time span values");
        if (((Integer)this.get("Number of time spans")).intValue() != tmpList.size()) {
            throw new ParseStageException("'Number of time spans' found (" + tmpList.size() + " != 'Number of time spans' in blockette (" + (Integer)this.get("Number of time spans") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt6_6d = new Format("%6.6d");
            Format fmt_vars = new Format("%s~");
            int numSpans = (Integer)this.get("Number of time spans");
            blktStr = String.valueOf(blktStr) + fmt4_4d.format(numSpans);
            ArrayList tmpList = (ArrayList)this.get("Time span values");
            int i = 0;
            while (i < numSpans) {
                ArrayList valList = (ArrayList)tmpList.get(i);
                blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)valList.get(0)).toSeedString());
                blktStr = String.valueOf(blktStr) + fmt_vars.format(((TimeStamp)valList.get(1)).toSeedString());
                blktStr = String.valueOf(blktStr) + fmt6_6d.format((Integer)valList.get(2));
                ++i;
            }
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList tmpList = null;
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 4;
            Integer intVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int numSpans = intVal;
            this.put("Number of time spans", intVal);
            if (numSpans > 0) {
                tmpList = (ArrayList)this.get("Time span values");
                tmpList.clear();
                eIdx = blktInfo.substring(sIdx += 4).indexOf(126) + sIdx;
            }
            int i = 0;
            while (i < numSpans) {
                ArrayList<Comparable<Date>> valList = new ArrayList<Comparable<Date>>();
                valList.add(TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
                sIdx = eIdx + 1;
                eIdx = blktInfo.substring(sIdx).indexOf(126) + sIdx;
                valList.add(TimeStamp.buildTimestamp(blktInfo.substring(sIdx, eIdx).trim()));
                sIdx = eIdx + 1;
                eIdx = sIdx + 6;
                valList.add(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = blktInfo.substring(sIdx += 6).indexOf(126) + sIdx;
                tmpList.add(valList);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Number of time spans");
        this.paramOutputType.put("Number of time spans", "%d");
        this.paramInputType.put("Number of time spans", new Integer(1));
        this.respFieldNames.add("Number of time spans");
        this.listParamLookup.put("04-06", "Time span values");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(3));
        tmpList.add(new Integer(3));
        tmpList.add(new Integer(1));
        this.listParamInputTypes.put("Time span values", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%s");
        tmpList.add("%s");
        tmpList.add("%6d");
        this.listParamOutputTypes.put("Time span values", tmpList);
        this.put("Time span values", new ArrayList());
        this.respFieldNames.add("Time span values");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b012 = TestData.test_b012a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette12 test_val = new Blockette12(test_b012, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b012.length());
        System.out.println(test_val.toString().compareTo(test_b012) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

