/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.seedutils;

import edu.iris.corejava.Format;
import edu.iris.seedutils.ParseStageException;
import edu.iris.seedutils.SeedBlockette;
import edu.iris.seedutils.SeedLookupMap;
import edu.iris.seedutils.StandaloneLookupMap;
import edu.iris.seedutils.TestData;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Date;

public class Blockette11
extends SeedBlockette {
    private static final long serialVersionUID = 1L;

    public Blockette11() {
    }

    public Blockette11(String blktInfo, SeedLookupMap lm) {
        super(blktInfo, lm);
    }

    public Blockette11(BufferedReader rd, int blktType) throws ParseStageException {
        super(rd, blktType);
        this.checkNumParams();
    }

    public Blockette11(BufferedReader rd, SeedLookupMap lm, int blktType) throws ParseStageException {
        super(rd, lm, blktType);
        this.checkNumParams();
    }

    void checkNumParams() throws ParseStageException {
        ArrayList tmpList = (ArrayList)this.get("Station index values");
        if (((Integer)this.get("Number of stations")).intValue() != tmpList.size()) {
            throw new ParseStageException("'Number of stations' found (" + tmpList.size() + " != 'Number of stations' in blockette (" + (Integer)this.get("Number of stations") + ")");
        }
    }

    public String toString(boolean paramFlag, boolean listParamFlag) {
        String returnVal = "";
        String blktStr = "";
        if (paramFlag) {
            Format fmt3_3d = new Format("%3.3d");
            Format fmt4_4d = new Format("%4.4d");
            Format fmt6_6d = new Format("%6.6d");
            Format fmt5s = new Format("%-5s");
            int numSta = (Integer)this.get("Number of stations");
            blktStr = String.valueOf(blktStr) + fmt3_3d.format(numSta);
            ArrayList tmpList = (ArrayList)this.get("Station index values");
            int i = 0;
            while (i < numSta) {
                ArrayList valList = (ArrayList)tmpList.get(i);
                blktStr = String.valueOf(blktStr) + fmt5s.format((String)valList.get(0));
                blktStr = String.valueOf(blktStr) + fmt6_6d.format((Integer)valList.get(1));
                ++i;
            }
            returnVal = String.valueOf(returnVal) + fmt3_3d.format(this.getType());
            returnVal = String.valueOf(returnVal) + fmt4_4d.format(blktStr.length() + 7) + blktStr;
        }
        return returnVal;
    }

    public boolean fromString(String blktInfo) {
        try {
            ArrayList tmpList = null;
            int sIdx = 0;
            int eIdx = sIdx + 3;
            int stageSeqNo = -1;
            int prevStageSeqNo = -1;
            this.setType(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
            eIdx = (sIdx += 3) + 4;
            eIdx = (sIdx += 4) + 3;
            Integer intVal = new Integer(blktInfo.substring(sIdx, eIdx).trim());
            int numSta = intVal;
            this.put("Number of stations", intVal);
            if (numSta > 0) {
                tmpList = (ArrayList)this.get("Station index values");
                tmpList.clear();
                eIdx = (sIdx += 3) + 5;
            }
            int i = 0;
            while (i < numSta) {
                ArrayList<Object> valList = new ArrayList<Object>();
                valList.add(blktInfo.substring(sIdx, eIdx).trim());
                eIdx = (sIdx += 5) + 6;
                valList.add(new Integer(blktInfo.substring(sIdx, eIdx).trim()));
                eIdx = (sIdx += 6) + 5;
                tmpList.add(valList);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void setupBlockette() {
        this.paramLookup.put("03", "Number of stations");
        this.paramOutputType.put("Number of stations", "%d");
        this.paramInputType.put("Number of stations", new Integer(1));
        this.respFieldNames.add("Number of stations");
        this.listParamLookup.put("04-05", "Station index values");
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(new Integer(0));
        tmpList.add(new Integer(1));
        this.listParamInputTypes.put("Station index values", tmpList);
        tmpList = new ArrayList();
        tmpList.add("%-5s");
        tmpList.add("%6d");
        this.listParamOutputTypes.put("Station index values", tmpList);
        this.put("Station index values", new ArrayList());
        this.respFieldNames.add("Station index values");
    }

    public String objToCompString() {
        return this.toString();
    }

    public void compStringToObj(String abbrev, SeedLookupMap lm) {
        this.setLookupMap(lm);
        this.fromString(abbrev);
    }

    public static void main(String[] args) {
        String test_b011 = TestData.test_b011a;
        StandaloneLookupMap lm = new StandaloneLookupMap();
        Blockette11 test_val = new Blockette11(test_b011, lm);
        System.out.println("-------- test #1 --------");
        System.out.println(test_val);
        System.out.println(test_b011.length());
        System.out.println(test_val.toString().compareTo(test_b011) == 0);
        System.out.println("-------- test #2 --------");
        test_val.echoResp();
        Date dateStart = new Date();
        System.out.println("       Blockette Hashes to value of: " + test_val.getElfHash());
        Date dateEnd = new Date();
        System.out.println("  Blockette Info Hashes to value of: " + test_val.getParamElfHash());
        long elapsed_time = dateEnd.getTime() - dateStart.getTime();
        System.out.println("hashed " + test_val.toString().length() + " characters in " + elapsed_time + " milliseconds");
    }
}

