/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecordHeader;

public class MiniSeedRecord
extends MiniSeedRecordHeader {
    private int[] data;

    public MiniSeedRecord cut(double offset, double length, double time) {
        double ed;
        double st = this.startTime;
        double dt = time - st + offset;
        int noff = (int)(dt * this.sampleRate + 0.5);
        int nlen = (int)(length * this.sampleRate + 0.5);
        if (noff < 0) {
            nlen += noff;
            noff = 0;
        }
        int[] d = new int[nlen];
        System.arraycopy(this.data, noff, d, 0, nlen);
        this.data = d;
        this.startTime = st += (double)noff / this.sampleRate;
        this.endTime = ed = st + (double)nlen / this.sampleRate;
        return this;
    }

    public static MiniSeedRecord build(GenericMiniSeedRecord g) {
        MiniSeedRecord msr = new MiniSeedRecord();
        MiniSeedRecordHeader.build(g, msr);
        msr.setData(new int[g.getNumSamples()]);
        int[] udata = g.getUData();
        if (udata == null) {
            return null;
        }
        if (udata.length == 0) {
            System.out.println("udata.length should not be 0: " + g);
            return null;
        }
        System.arraycopy(udata, 0, msr.getData(), 0, udata.length);
        return msr;
    }

    public int[] getData() {
        return this.data;
    }

    public void setData(int[] data) {
        this.data = data;
    }
}

