/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecordHeader;
import java.util.Date;

public class MiniSeedChunk
extends MiniSeedRecordHeader {
    private int dataFormat;
    private int wordOrder;
    private int length;
    private byte[] data;
    private Date mergeTime;

    public boolean merge(MiniSeedChunk msc) {
        if (this.data.length - this.length < msc.length) {
            return false;
        }
        if (msc.getStartTime() - this.getEndTime() > 600.0) {
            return false;
        }
        System.arraycopy(msc.getData(), 0, this.data, this.length, msc.getData().length);
        this.length += msc.getData().length;
        this.endTime = msc.getEndTime();
        this.numSamples += msc.getNumSamples();
        this.mergeTime = new Date();
        return true;
    }

    public static MiniSeedChunk build(MiniSeedChunk g, int chunckSize) {
        MiniSeedChunk msc = new MiniSeedChunk();
        msc.setNetwork(g.getNetwork());
        msc.setStation(g.getStation());
        msc.setLocID(g.getLocID());
        msc.setChannel(g.getChannel());
        msc.setStartTime(g.getStartTime());
        msc.setSampleRate(g.getSampleRate());
        msc.setNumSamples(g.getNumSamples());
        msc.setEndTime(g.getEndTime());
        msc.sequenceNumber = g.getSequenceNumber();
        msc.activeFlag = g.getActiveFlag();
        msc.caliFlag = g.getCaliFlag();
        msc.recordLength = g.getRecordLength();
        msc.dataFormat = g.getDataFormat();
        msc.wordOrder = g.getWordOrder();
        msc.data = new byte[chunckSize];
        System.arraycopy(g.data, 0, msc.data, 0, g.length);
        msc.length = g.length;
        return msc;
    }

    public static MiniSeedChunk build(GenericMiniSeedRecord g, int chunckSize) {
        MiniSeedChunk msc = new MiniSeedChunk();
        MiniSeedRecordHeader.build(g, msc);
        msc.dataFormat = g.getDataFormat();
        msc.wordOrder = g.getWordOrder();
        msc.data = new byte[chunckSize];
        byte[] b = g.getBytes();
        System.arraycopy(b, 0, msc.data, 0, b.length);
        msc.length = b.length;
        return msc;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Date getMergeTime() {
        return this.mergeTime;
    }

    public void setMergeTime(Date mergeTime) {
        this.mergeTime = mergeTime;
    }

    public int getDataFormat() {
        return this.dataFormat;
    }

    public int getWordOrder() {
        return this.wordOrder;
    }
}

