/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.corejava.Format;
import edu.iris.miniseedutils.steim.ChannelMask;
import edu.iris.miniseedutils.steim.CompressedFrame;
import edu.iris.miniseedutils.steim.DecompressionContinuity;
import edu.iris.miniseedutils.steim.GenericDataRecord;
import edu.iris.miniseedutils.steim.MiniseedFormatException;
import edu.iris.miniseedutils.steim.Steim;
import edu.iris.miniseedutils.steim.UnrecognizedBlocketteException;
import edu.iris.miniseedutils.steim.UnrecognizedFormatException;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GenericMiniSeedRecord
extends GenericDataRecord
implements Comparable {
    private static DecimalFormat fmt = new DecimalFormat("000000");
    protected boolean byteSwappedRec;
    protected int[] udata;
    private boolean decoded = false;
    private ChannelMask chanMask = new ChannelMask();
    private static Format fmt2_2s = new Format("%-2s");
    private static Format fmt3_3s = new Format("%-3s");
    private static Format fmt5_5s = new Format("%-5s");
    private static Format fmt2_2d = new Format("%02.2d");
    private static Format fmt3_3d = new Format("%03.3d");
    private static Format fmt4_4d = new Format("%04.4d");
    private static Format fmt7_4f = new Format("%07.4f");
    private static final int DEFAULTHEADERLENGTH = 48;
    private static final int DEFAULTRECORDLENGTH = 4096;
    private static final int MAXRECORDLENGTH = 65536;
    private static final int FSDH_SIZE = 48;
    private static final int BLKT100_LEN = 12;
    private static final int BLKT200_LEN = 28;
    private static final int BLKT201_LEN = 36;
    private static final int BLKT300_LEN = 32;
    private static final int BLKT310_LEN = 32;
    private static final int BLKT320_LEN = 28;
    private static final int BLKT390_LEN = 28;
    private static final int BLKT395_LEN = 16;
    private static final int BLKT400_LEN = 16;
    private static final int BLKT1000_LEN = 8;
    private static final int BLKT1001_LEN = 8;
    private static Steim steim = new Steim();
    private TimeStamp startTime = null;

    private GenericMiniSeedRecord() {
    }

    public GenericMiniSeedRecord(int headLen, int recLen) {
        this.byteSwappedRec = false;
        this.recordLength = recLen;
        this.headLength = headLen;
        this.dataLength = this.recordLength - this.headLength;
        this.head = new byte[this.headLength];
        this.data = new byte[this.dataLength];
        this.frameLength = 64;
        int numRecordFrames = recLen / this.frameLength;
        this.numHeaderFrames = (int)Math.ceil(headLen / this.frameLength);
        if (this.numHeaderFrames >= numRecordFrames) {
            return;
        }
        this.numDataFrames = numRecordFrames - this.numHeaderFrames;
        this.frames = new CompressedFrame[this.numDataFrames];
        int i = 0;
        while (i < this.frames.length) {
            this.frames[i] = new CompressedFrame();
            ++i;
        }
    }

    public void setEncodeBuffer(byte[] buf) {
        if (buf[6] != 68 && buf[6] != 81 && buf[6] != 82) {
            System.err.println("Header Data is not MinSeed Header");
        }
        if (this.head == null) {
            System.err.println("Internal Error1 in GenericMiniSeedRecord");
        }
        this.recordLength = buf.length;
        try {
            this.headLength = GenericMiniSeedRecord.getHeaderLength(buf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dataLength = this.recordLength - this.headLength;
        this.head = new byte[this.headLength];
        this.data = new byte[this.dataLength];
        System.arraycopy(buf, 0, this.head, 0, this.headLength);
        System.arraycopy(buf, this.headLength, this.data, 0, this.dataLength);
        int dataOffset = 64;
        try {
            dataOffset = GenericMiniSeedRecord.getDataOffset(buf);
            this.byteSwappedRec = GenericMiniSeedRecord.isByteSwapped(this.head);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int k = dataOffset - this.headLength;
        int i = 0;
        while (i < this.numDataFrames) {
            if (k >= this.data.length) break;
            int j = 0;
            while (j < 16) {
                this.frames[i].cfp[j] = Steim.makeInt(this.data[k], this.data[k + 1], this.data[k + 2], this.data[k + 3], this.byteSwappedRec);
                k += 4;
                ++j;
            }
            ++i;
        }
        this.decoded = false;
        this.startTime = null;
    }

    public static String getNextSeqNumber(String seqNumber) {
        int seq = Integer.parseInt(seqNumber);
        seq = (seq + 1) % 1000000;
        return fmt.format(seq);
    }

    public static int getHeaderLength(byte[] bytes) throws MiniseedFormatException, UnrecognizedBlocketteException, UnrecognizedFormatException {
        if (bytes.length < 48) {
            String errStr = "buffer is too short to contain a complete FSDH (length=" + bytes.length + ", but need at least " + 48 + " bytes)";
            throw new UnrecognizedFormatException(errStr);
        }
        if (bytes[6] != 68 && bytes[6] != 81 && bytes[6] != 82) {
            String errStr = "buffer is not a miniSEED data record (should contain a 'D' 'R' 'Q' in the 6th byte, found a '" + bytes[6] + "' instead)";
            throw new UnrecognizedFormatException(errStr);
        }
        int hdrLen = 48;
        boolean byteSwappedRec = GenericMiniSeedRecord.isByteSwapped(bytes);
        short nextOffset = Steim.makeShort(bytes[46], bytes[47], byteSwappedRec);
        while (nextOffset > 0) {
            int blktLen;
            if (nextOffset + 1 > bytes.length) {
                throw new MiniseedFormatException("can't determine miniSEED header type");
            }
            short blktType = Steim.makeShort(bytes[nextOffset], bytes[nextOffset + 1], byteSwappedRec);
            switch (blktType) {
                case 100: {
                    blktLen = 12;
                    break;
                }
                case 200: {
                    blktLen = 28;
                    break;
                }
                case 201: {
                    blktLen = 36;
                    break;
                }
                case 300: {
                    blktLen = 32;
                    break;
                }
                case 310: {
                    blktLen = 32;
                    break;
                }
                case 320: {
                    blktLen = 28;
                    break;
                }
                case 390: {
                    blktLen = 28;
                    break;
                }
                case 395: {
                    blktLen = 16;
                    break;
                }
                case 400: {
                    blktLen = 16;
                    break;
                }
                case 1000: {
                    blktLen = 8;
                    break;
                }
                case 1001: {
                    blktLen = 8;
                    break;
                }
                default: {
                    String errStr = "blkt id of " + blktType + " found in data record";
                    throw new UnrecognizedBlocketteException(errStr);
                }
            }
            if (nextOffset + blktLen > bytes.length) {
                throw new MiniseedFormatException("incomplete miniSEED header found");
            }
            hdrLen += blktLen;
            nextOffset = Steim.makeShort(bytes[nextOffset + 2], bytes[nextOffset + 3], byteSwappedRec);
        }
        return hdrLen;
    }

    private static int getDataOffset(byte[] bytes) throws MiniseedFormatException, UnrecognizedBlocketteException, UnrecognizedFormatException {
        if (bytes.length < 48) {
            String errStr = "buffer is too short to contain a complete FSDH (length=" + bytes.length + ", but need at least " + 48 + " bytes)";
            throw new UnrecognizedFormatException(errStr);
        }
        if (bytes[6] != 68 && bytes[6] != 81 && bytes[6] != 82) {
            String errStr = "buffer is not a miniSEED data record (should contain a 'D' 'Q' 'R' in the 6th byte, found a '" + bytes[6] + "' instead)";
            throw new UnrecognizedFormatException(errStr);
        }
        boolean byteSwappedRec = GenericMiniSeedRecord.isByteSwapped(bytes);
        short dataOffset = Steim.makeShort(bytes[44], bytes[45], byteSwappedRec);
        return dataOffset;
    }

    public static int getRecordLength(byte[] bytes) throws MiniseedFormatException, UnrecognizedBlocketteException, UnrecognizedFormatException {
        if (bytes.length < 48) {
            String errStr = "buffer is too short to contain a complete FSDH (length=" + bytes.length + ", but need at least " + 48 + " bytes)";
            throw new UnrecognizedFormatException(errStr);
        }
        if (bytes[6] != 68 && bytes[6] != 81 && bytes[6] != 82) {
            String errStr = "buffer is not a miniSEED data record (should contain a 'D' 'Q' 'R' in the 6th byte, found a '" + bytes[6] + "' instead)";
            throw new UnrecognizedFormatException(errStr);
        }
        int hdrLen = 48;
        boolean byteSwappedRec = GenericMiniSeedRecord.isByteSwapped(bytes);
        short nextOffset = Steim.makeShort(bytes[46], bytes[47], byteSwappedRec);
        while (nextOffset > 0) {
            if (nextOffset + 1 > bytes.length) {
                throw new MiniseedFormatException("can't determine miniSEED header type");
            }
            short blktType = Steim.makeShort(bytes[nextOffset], bytes[nextOffset + 1], byteSwappedRec);
            if (blktType == 1000) {
                byte lenExp = bytes[nextOffset + 6];
                return (int)Math.pow(2.0, lenExp);
            }
            nextOffset = Steim.makeShort(bytes[nextOffset + 2], bytes[nextOffset + 3], byteSwappedRec);
        }
        return -1;
    }

    public static byte[] getHeader(InputStream is) throws MiniseedFormatException {
        int blktSize = 48;
        byte[] readBuf = new byte[blktSize];
        byte[] headerBuf = new byte[blktSize];
        int nbytes = 0;
        int headerLength = 0;
        int bufferOffset = 0;
        boolean wordOrderChecked = false;
        while (true) {
            int nbytesRead = 0;
            do {
                try {
                    nbytes = is.read(readBuf, nbytesRead, blktSize - nbytesRead);
                    if (nbytes == -1) {
                        throw new MiniseedFormatException("End of file reached while reading a miniSEED data record's header");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            } while ((nbytesRead += nbytes) < blktSize);
            System.arraycopy(readBuf, 0, headerBuf, bufferOffset, readBuf.length);
            try {
                headerLength = GenericMiniSeedRecord.getHeaderLength(headerBuf);
            }
            catch (MiniseedFormatException e) {
                int newSize = headerBuf.length + readBuf.length;
                bufferOffset += readBuf.length;
                byte[] tmpBuf = new byte[newSize];
                System.arraycopy(headerBuf, 0, tmpBuf, 0, headerBuf.length);
                headerBuf = tmpBuf;
                continue;
            }
            catch (UnrecognizedBlocketteException e) {
                e.printStackTrace();
                return null;
            }
            catch (UnrecognizedFormatException e) {
                e.printStackTrace();
                return null;
            }
            break;
        }
        return headerBuf;
    }

    private static boolean isByteSwapped(byte[] headBuf) throws MiniseedFormatException {
        byte[] timeBuf = new byte[10];
        System.arraycopy(headBuf, 20, timeBuf, 0, 10);
        short doy = Steim.makeShort(timeBuf[2], timeBuf[3]);
        if (doy < 1 || doy > 366) {
            doy = Steim.makeShort(timeBuf[3], timeBuf[2]);
            if (doy < 1 || doy > 366) {
                String errStr = "Illegal day of year found in FSDH start time (found byte values of " + Integer.toHexString(timeBuf[2]) + " " + Integer.toHexString(timeBuf[3]) + " in doy field";
                throw new MiniseedFormatException(errStr);
            }
            return true;
        }
        short year = Steim.makeShort(timeBuf[0], timeBuf[1]);
        if (year < 0 || year > 5138) {
            year = Steim.makeShort(timeBuf[1], timeBuf[0]);
            if (year < 0 || year > 5138) {
                String errStr = "Illegal year found in FSDH start time (found byte values of " + Integer.toHexString(timeBuf[0]) + " " + Integer.toHexString(timeBuf[1]) + " in year field";
                throw new MiniseedFormatException(errStr);
            }
            return true;
        }
        return false;
    }

    protected String getStartTimeStr() {
        byte[] startTime = new byte[10];
        System.arraycopy(this.head, 20, startTime, 0, 10);
        short year = Steim.makeShort(startTime[0], startTime[1], this.byteSwappedRec);
        short doy = Steim.makeShort(startTime[2], startTime[3], this.byteSwappedRec);
        byte hour = startTime[4];
        byte min = startTime[5];
        byte intSecs = startTime[6];
        short seedDeciSecs = Steim.makeShort(startTime[8], startTime[9], this.byteSwappedRec);
        float secs = (float)intSecs + (float)seedDeciSecs / 10000.0f;
        return String.valueOf(fmt4_4d.format(year)) + "," + fmt3_3d.format(doy) + "," + fmt2_2d.format(hour) + ":" + fmt2_2d.format(min) + ":" + fmt7_4f.format(secs);
    }

    public void setSequenceNumber(int num) {
        System.arraycopy(fmt.format(num).getBytes(), 0, this.head, 0, 6);
    }

    private void fillString(int idx, int len, byte[] b) {
        int i = 0;
        while (i < len) {
            this.head[idx + i] = 32;
            ++i;
        }
        int min = Math.min(len, b.length);
        int i2 = 0;
        while (i2 < min) {
            this.head[idx + i2] = b[i2];
            ++i2;
        }
    }

    public void setStation(String stn) {
        int idx = 8;
        int len = 5;
        byte[] b = stn.getBytes();
        this.fillString(idx, len, b);
    }

    public void setLocID(String locID) {
        int idx = 13;
        int len = 2;
        byte[] b = locID.getBytes();
        this.fillString(idx, len, b);
    }

    public void setChannel(String chan) {
        int idx = 15;
        int len = 3;
        byte[] b = chan.getBytes();
        this.fillString(idx, len, b);
    }

    public void setNetwork(String network) {
        int idx = 18;
        int len = 2;
        byte[] b = network.getBytes();
        this.fillString(idx, len, b);
    }

    public void setStartTime(TimeStamp ts) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTime(ts);
        int year = c.get(1);
        int doy = c.get(6);
        int hour = c.get(11);
        int min = c.get(12);
        int intSec = c.get(13);
        int tenth_millisec = ts.getNanoSecs() / 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10);
        try {
            DataOutputStream ds = new DataOutputStream(baos);
            if (this.byteSwappedRec) {
                ds.writeShort(this.swapShort(year));
                ds.writeShort(this.swapShort(doy));
                ds.writeByte(hour);
                ds.writeByte(min);
                ds.writeByte(intSec);
                ds.writeByte(0);
                ds.writeShort(this.swapShort(tenth_millisec));
            } else {
                ds.writeShort(year);
                ds.writeShort(doy);
                ds.writeByte(hour);
                ds.writeByte(min);
                ds.writeByte(intSec);
                ds.writeByte(0);
                ds.writeShort(tenth_millisec);
            }
            ds.flush();
            ds.close();
            baos.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        int idx = 20;
        int len = 10;
        byte[] b = baos.toByteArray();
        this.fillString(idx, len, b);
    }

    private int swapShort(int n) {
        return (((n &= 0xFFFF) & 0xFF) << 8) + (n >>> 8);
    }

    public String getSequenceNumber() {
        return new String(this.head, 0, 6).trim();
    }

    public String getStation() {
        return new String(this.head, 8, 5).trim();
    }

    public String getLocID() {
        return new String(this.head, 13, 2);
    }

    public String getChannel() {
        return new String(this.head, 15, 3).trim();
    }

    public String getNetwork() {
        return new String(this.head, 18, 2).trim();
    }

    public TimeStamp getStartTime() {
        if (this.startTime == null) {
            this.startTime = TimeStamp.buildTimestamp(this.getStartTimeStr());
        }
        return this.startTime;
    }

    public Timestamp getEndTime() {
        Timestamp endTS = null;
        TimeStamp start = this.getStartTime();
        long ns = (long)((double)(this.getNumSamples() * 1000) / this.getSampleRate()) * 1000000L + (long)start.getNanos();
        endTS = new Timestamp((start.getTime() / 1000L + ns / 1000000000L) * 1000L);
        endTS.setNanos((int)(ns %= 1000000000L));
        return endTS;
    }

    public double getSampleRate() {
        short srate_fact = Steim.makeShort(this.head[32], this.head[33], this.byteSwappedRec);
        short srate_mult = Steim.makeShort(this.head[34], this.head[35], this.byteSwappedRec);
        if (srate_fact >= 0 && srate_mult >= 0) {
            return (double)srate_fact * (double)srate_mult;
        }
        if (srate_fact >= 0 && srate_mult < 0) {
            return -((double)srate_fact / (double)srate_mult);
        }
        if (srate_fact < 0 && srate_mult >= 0) {
            return -((double)srate_mult / (double)srate_fact);
        }
        double srate = 1.0 / ((double)srate_mult * (double)srate_fact);
        if (srate > 1.0) {
            srate = Math.round(srate);
        }
        return srate;
    }

    public int getNumSamples() {
        return Steim.makeShort(this.head[30], this.head[31], this.byteSwappedRec);
    }

    public int getActiveFlag() {
        return this.head[36] & 0xFF;
    }

    public int getIOFlag() {
        return this.head[37] & 0xFF;
    }

    public int getCaliFlag() {
        if (this.getActiveFlag() == 0) {
            return 0;
        }
        return this.getIOFlag() >>> 6;
    }

    public short getWordOrder() {
        int hdrLen = 48;
        short nextOffset = Steim.makeShort(this.head[46], this.head[47], this.byteSwappedRec);
        while (nextOffset > 0) {
            if (nextOffset + 1 > this.head.length) {
                System.err.println("can't determine miniSEED header type");
                return -1;
            }
            short blktType = Steim.makeShort(this.head[nextOffset], this.head[nextOffset + 1], this.byteSwappedRec);
            if (blktType == 1000) {
                return this.head[nextOffset + 5];
            }
            nextOffset = Steim.makeShort(this.head[nextOffset + 2], this.head[nextOffset + 3], this.byteSwappedRec);
        }
        return -1;
    }

    public short getDataFormat() {
        int hdrLen = 48;
        short nextOffset = Steim.makeShort(this.head[46], this.head[47], this.byteSwappedRec);
        while (nextOffset > 0) {
            if (nextOffset + 1 > this.head.length) {
                System.err.println("can't determine miniSEED header type");
                return -1;
            }
            short blktType = Steim.makeShort(this.head[nextOffset], this.head[nextOffset + 1], this.byteSwappedRec);
            if (blktType == 1000) {
                return this.head[nextOffset + 4];
            }
            nextOffset = Steim.makeShort(this.head[nextOffset + 2], this.head[nextOffset + 3], this.byteSwappedRec);
        }
        return -1;
    }

    public int getBlockType() {
        int hdrLen = 48;
        short nextOffset = Steim.makeShort(this.head[46], this.head[47], this.byteSwappedRec);
        short blktType = Steim.makeShort(this.head[nextOffset], this.head[nextOffset + 1], this.byteSwappedRec);
        return blktType;
    }

    public short getExpRecLength() {
        int hdrLen = 48;
        short nextOffset = Steim.makeShort(this.head[46], this.head[47], this.byteSwappedRec);
        while (nextOffset > 0) {
            if (nextOffset + 1 > this.head.length) {
                System.err.println("can't determine miniSEED header type");
                return -1;
            }
            short blktType = Steim.makeShort(this.head[nextOffset], this.head[nextOffset + 1], this.byteSwappedRec);
            if (blktType == 1000) {
                return this.head[nextOffset + 6];
            }
            nextOffset = Steim.makeShort(this.head[nextOffset + 2], this.head[nextOffset + 3], this.byteSwappedRec);
        }
        return -1;
    }

    public int getRecordLength() {
        return this.head.length + this.dataLength;
    }

    private short getDataOffset() {
        return Steim.makeShort(this.head[44], this.head[45], this.byteSwappedRec);
    }

    public int[] getUData() {
        if (this.decoded) {
            return this.udata;
        }
        if (this.decompress()) {
            return this.udata;
        }
        return null;
    }

    protected byte[] getHeaderBytes() {
        return this.head;
    }

    protected byte[] getDataBytes() {
        return this.data;
    }

    public String toString() {
        return String.valueOf(this.getSequenceNumber()) + " " + this.getNetwork() + "/" + this.getStation() + "/" + this.getLocID() + "/" + this.getChannel() + " " + this.getStartTime() + "\tnsamples " + this.getNumSamples() + " sps " + this.getSampleRate() + " ActiveFlag:" + this.getActiveFlag() + " CaliFlag:" + this.getCaliFlag();
    }

    public byte[] getBytes() {
        byte[] Bytes2 = new byte[this.head.length + this.data.length];
        System.arraycopy(this.head, 0, Bytes2, 0, this.head.length);
        System.arraycopy(this.data, 0, Bytes2, this.head.length, this.data.length);
        return Bytes2;
    }

    public static GenericMiniSeedRecord buildMiniSeedRecord(byte[] miniSeedRecored) {
        int arecLen;
        int headerLength;
        block6: {
            headerLength = GenericMiniSeedRecord.getHeaderLength(miniSeedRecored);
            arecLen = GenericMiniSeedRecord.getRecordLength(miniSeedRecored);
            if (arecLen <= miniSeedRecored.length) break block6;
            return null;
        }
        try {
            byte[] ahead = new byte[headerLength];
            byte[] adata = new byte[arecLen - headerLength];
            System.arraycopy(miniSeedRecored, 0, ahead, 0, headerLength);
            System.arraycopy(miniSeedRecored, headerLength, adata, 0, adata.length);
            return GenericMiniSeedRecord.buildMiniSeedRecord(ahead, adata, arecLen);
        }
        catch (UnrecognizedFormatException ufEx) {
            ufEx.printStackTrace();
            return null;
        }
        catch (MiniseedFormatException msfEx) {
            msfEx.printStackTrace();
            return null;
        }
        catch (UnrecognizedBlocketteException uBEx) {
            uBEx.printStackTrace();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static GenericMiniSeedRecord buildMiniSeedRecord(byte[] head, byte[] data) {
        return GenericMiniSeedRecord.buildMiniSeedRecord(head, data, 4096);
    }

    public static GenericMiniSeedRecord buildMiniSeedRecord(byte[] head, byte[] data, int recLen) {
        if (head.length + data.length != recLen) {
            System.err.println("buildMiniSeedRecord (ERROR):  illegal record length specified");
            return null;
        }
        if (head[6] != 68 && head[6] != 81 && head[6] != 82) {
            System.err.println("Header Data is not MinSeed Header");
            return null;
        }
        GenericMiniSeedRecord gmsRec = new GenericMiniSeedRecord(head.length, recLen);
        int dataOffset = 64;
        try {
            dataOffset = GenericMiniSeedRecord.getDataOffset(head);
            gmsRec.byteSwappedRec = GenericMiniSeedRecord.isByteSwapped(head);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (head == null) {
            System.err.println("Internal Error1 in GenericMiniSeedRecord");
        }
        if (gmsRec.head == null) {
            System.err.println("Internal Error2 in GenericMiniSeedRecord");
        }
        System.arraycopy(head, 0, gmsRec.head, 0, head.length);
        System.arraycopy(data, 0, gmsRec.data, 0, data.length);
        int k = dataOffset - head.length;
        int i = 0;
        while (i < gmsRec.numDataFrames) {
            if (k >= data.length) break;
            int j = 0;
            while (j < 16) {
                gmsRec.frames[i].cfp[j] = Steim.makeInt(data[k], data[k + 1], data[k + 2], data[k + 3], gmsRec.byteSwappedRec);
                k += 4;
                ++j;
            }
            ++i;
        }
        try {
            gmsRec.chanMask.set(gmsRec.getChannel(), gmsRec.getLocID());
        }
        catch (Exception ex) {
            System.err.println("DEBUG:\t" + new Date() + gmsRec.toString());
            ex.printStackTrace();
            gmsRec = null;
        }
        gmsRec.decoded = false;
        return gmsRec;
    }

    public boolean decompress() {
        boolean sucess = false;
        try {
            this.udata = new int[this.getNumSamples()];
            sucess = this.decompress(this.udata);
        }
        catch (MiniseedFormatException msfEx) {
            msfEx.printStackTrace();
            sucess = false;
        }
        this.decoded = true;
        return sucess;
    }

    public boolean decompress(int[] udata) throws MiniseedFormatException {
        if (this.getBlockType() != 1000) {
            return false;
        }
        short flip = 0;
        short firstframe = 0;
        short level = 3;
        short dframes = 63;
        int headertotal = this.getNumSamples();
        short hfirstdata = this.getDataOffset();
        if (hfirstdata == -1) {
            throw new MiniseedFormatException("shit...");
        }
        if (hfirstdata % this.frameLength != 0) {
            throw new MiniseedFormatException("illegal start-of-data is found");
        }
        firstframe = (short)(hfirstdata / this.frameLength);
        if ((firstframe = (short)(firstframe - 1)) < 0) {
            System.out.println(hfirstdata);
            throw new MiniseedFormatException("shit");
        }
        short formatCode = this.getDataFormat();
        switch (formatCode) {
            case 10: {
                level = 1;
                break;
            }
            case 11: {
                level = 2;
                break;
            }
            case 19: 
            case 20: {
                level = 3;
                break;
            }
            default: {
                throw new MiniseedFormatException("unknown encoding format");
            }
        }
        switch (this.getExpRecLength()) {
            case 12: {
                dframes = 63;
                break;
            }
            case 11: {
                dframes = 31;
                break;
            }
            case 10: {
                dframes = 15;
                break;
            }
            case 9: {
                dframes = 7;
                break;
            }
            case 8: {
                dframes = 3;
                break;
            }
            case 7: {
                dframes = 1;
                break;
            }
            default: {
                throw new MiniseedFormatException("unknown record Length");
            }
        }
        DecompressionContinuity dcp = steim.initGenericDecompression();
        short statcode = 0;
        int rectotal = steim.decompressGenericRecord(this, udata, statcode, dcp, firstframe, headertotal, level, flip, dframes);
        return !steim.dfErrorFatal(statcode, System.err);
    }

    public void printWaveformHeader(PrintStream os) {
        os.println("\n===============================================================================");
        os.println("STATION  LOCATION  CHANNEL  NETWORK  TIME");
    }

    private String getWordOrderStr() {
        switch (this.getWordOrder()) {
            case 1: {
                return "68000/SPARC word order";
            }
        }
        return "VAX/8086 word order";
    }

    private String getDataFormatStr() {
        short formatCode = this.getDataFormat();
        switch (formatCode) {
            case 1: {
                return "16 bit integers";
            }
            case 2: {
                return "24 bit integers";
            }
            case 3: {
                return "32 bit integers";
            }
            case 4: {
                return "IEEE floating point";
            }
            case 5: {
                return "IEEE double precision floating point";
            }
            case 10: {
                return "STEIM (1) Compression";
            }
            case 11: {
                return "STEIM (2) Compression";
            }
            case 12: {
                return "GEOSCOPE Multiplexed Format 24 bit integer";
            }
            case 13: {
                return "GEOSCOPE Multiplexed Format 16 bit gain-ranged, 3 bit exponent";
            }
            case 14: {
                return "GEOSCOPE Multiplexed Format 16 bit gain-ranged, 4 bit exponent";
            }
            case 15: {
                return "US National Network compression";
            }
            case 16: {
                return "CDSN 16 bit gain ranged";
            }
            case 17: {
                return "Graefenberg 16 bit gain ranged";
            }
            case 18: {
                return "IPG - Strasbourg 16 bit gain ranged";
            }
            case 19: {
                return "STEIM (3) Compression";
            }
            case 30: {
                return "SRO Format";
            }
            case 31: {
                return "HGLP Format";
            }
            case 32: {
                return "DWWSSN gain ranged format";
            }
            case 33: {
                return "RSTN 16 bit gain ranged";
            }
        }
        return "Unrecognized Data Format (" + formatCode + ")";
    }

    private void printBlockette100(PrintStream os, int offset) {
        os.println("        BLOCKETTE 100:");
        float srate = Steim.makeFloat(this.head[offset + 4], this.head[offset + 5], this.head[offset + 6], this.head[offset + 7], this.byteSwappedRec);
        os.println("                  actual sample rate: " + srate);
        os.println("                               flags: to be defined - " + this.buildFlagString(this.head[offset + 8]));
        os.println("                       reserved[0-2]: " + this.buildFlagString(this.head[offset + 9]) + " " + this.buildFlagString(this.head[offset + 10]) + " " + this.buildFlagString(this.head[offset + 11]) + " ");
    }

    private void printBlockette1000(PrintStream os, int offset) {
        os.println("       BLOCKETTE 1000:");
        os.println("                     encoding format: " + this.getDataFormatStr() + " (val:" + this.head[offset + 4] + ")");
        os.println("                          word order: " + this.getWordOrderStr());
        os.println("                  data record length: " + this.head[offset + 6]);
        os.println("                            reserved: " + this.buildFlagString(this.head[offset + 7]));
    }

    private void printBlockette1001(PrintStream os, int offset) {
        os.println("       BLOCKETTE 1001:");
        os.println("                      timing quality: " + this.head[offset + 4]);
        os.println("                data start time usec: " + this.head[offset + 5]);
        os.println("                            reserved: " + this.buildFlagString(this.head[offset + 6]));
        os.println("                         frame count: " + this.head[offset + 7]);
    }

    public void printDataBlockettes(PrintStream os) {
        os.print(String.valueOf(fmt5_5s.format(this.getStation())) + "    ");
        os.print(String.valueOf(fmt2_2s.format(this.getLocID())) + "        ");
        os.print(String.valueOf(fmt3_3s.format(this.getChannel())) + "      ");
        os.print(String.valueOf(fmt2_2s.format(this.getNetwork())) + "       ");
        os.print(this.getStartTimeStr());
        if (this.byteSwappedRec) {
            os.println("   [WORD SWAP MODE]");
        } else {
            os.println("   [NO SWAP MODE]");
        }
        int intVal = Steim.makeShort(this.head[30], this.head[31], this.byteSwappedRec);
        os.println("         # samples in record: " + intVal);
        intVal = Steim.makeShort(this.head[32], this.head[33], this.byteSwappedRec);
        os.println("                 sample_rate: " + intVal);
        intVal = Steim.makeShort(this.head[34], this.head[35], this.byteSwappedRec);
        os.println("                  multiplier: " + intVal);
        os.println("              activity flags: " + this.buildFlagString(this.head[36]));
        os.println("         I/O and clock flags: " + this.buildFlagString(this.head[37]));
        os.println("          data quality flags: " + this.buildFlagString(this.head[38]));
        os.println("             # of blockettes: " + this.head[39]);
        intVal = Steim.makeInt(this.head[40], this.head[41], this.head[42], this.head[43], this.byteSwappedRec);
        os.println("             time correction: " + intVal);
        intVal = Steim.makeShort(this.head[44], this.head[45], this.byteSwappedRec);
        os.println("           begin data offset: " + intVal);
        intVal = Steim.makeShort(this.head[46], this.head[47], this.byteSwappedRec);
        os.println("        begin blkette offset: " + intVal);
        int nextOffset = intVal;
        int blktLen = 0;
        while (nextOffset > 0) {
            String errStr;
            if (nextOffset + 1 > this.head.length) {
                errStr = "printDataBlockettes (ERROR): can't determine miniSEED header type";
                System.err.println(errStr);
                System.exit(10);
            }
            short blktType = Steim.makeShort(this.head[nextOffset], this.head[nextOffset + 1], this.byteSwappedRec);
            switch (blktType) {
                case 100: {
                    blktLen = 12;
                    this.printBlockette100(os, nextOffset);
                    break;
                }
                case 200: {
                    blktLen = 28;
                    break;
                }
                case 201: {
                    blktLen = 36;
                    break;
                }
                case 300: {
                    blktLen = 32;
                    break;
                }
                case 310: {
                    blktLen = 32;
                    break;
                }
                case 320: {
                    blktLen = 28;
                    break;
                }
                case 390: {
                    blktLen = 28;
                    break;
                }
                case 395: {
                    blktLen = 16;
                    break;
                }
                case 400: {
                    blktLen = 16;
                    break;
                }
                case 1000: {
                    blktLen = 8;
                    this.printBlockette1000(os, nextOffset);
                    break;
                }
                case 1001: {
                    blktLen = 8;
                    this.printBlockette1001(os, nextOffset);
                    break;
                }
                default: {
                    errStr = "printDataBlockettes (ERROR): unrecognized blockette (type = " + blktType + ") found in data record";
                    System.err.println(errStr);
                    System.exit(10);
                }
            }
            if (nextOffset + blktLen > this.head.length) {
                errStr = "printDataBlockettes (ERROR): incomplete miniSEED header found";
                System.err.println(errStr);
                System.exit(10);
            }
            nextOffset = Steim.makeShort(this.head[nextOffset + 2], this.head[nextOffset + 3], this.byteSwappedRec);
        }
    }

    public int compareTo(Object obj) {
        GenericMiniSeedRecord gmsrObj = (GenericMiniSeedRecord)obj;
        if (this.getStartTime().after(gmsrObj.getStartTime())) {
            return 1;
        }
        if (this.getStartTime().before(gmsrObj.getStartTime())) {
            return -1;
        }
        return 0;
    }

    public ChannelMask getChannelMask() {
        return this.chanMask;
    }

    public boolean isRealTimePacket() {
        int locID = 0;
        try {
            locID = Integer.parseInt(this.getLocID());
            return locID < 50;
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }

    public boolean isTriggerEventPacket() {
        return !this.isRealTimePacket();
    }

    public boolean isStrongMotionPacket() {
        char flag = this.getChannel().charAt(1);
        return flag == 'A';
    }

    public boolean isChannelUD() {
        char flag = this.getChannel().charAt(2);
        return flag == 'Z';
    }

    public boolean isChannelNE() {
        char flag = this.getChannel().charAt(2);
        return flag == 'N';
    }

    public boolean isChannelEW() {
        char flag = this.getChannel().charAt(2);
        return flag == 'E';
    }

    private String buildFlagString(byte flags) {
        String flagStr = Integer.toBinaryString(flags);
        int strLength = flagStr.length();
        if (strLength < 8) {
            int padLength = 8 - strLength;
            String formatStr = "%" + padLength + "." + padLength + "d";
            Format fmts = new Format(formatStr);
            flagStr = String.valueOf(fmts.format(0)) + flagStr;
        }
        return flagStr;
    }

    public static void testDecompress(String fname) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fname));
            bis.skip(0L);
            int recLen = 512;
            byte[] b = new byte[recLen];
            bis.read(b);
            GenericMiniSeedRecord gmsRec = GenericMiniSeedRecord.buildMiniSeedRecord(b);
            int[] udata = new int[gmsRec.getNumSamples()];
            int i = 0;
            while (i < udata.length) {
                udata[i] = -9999;
                ++i;
            }
            if (gmsRec.decompress(udata)) {
                System.out.println("OK");
            } else {
                System.out.println("Error");
            }
            System.out.print(String.valueOf(gmsRec.getStation()) + "/" + gmsRec.getChannel() + " ");
            System.out.println("srate=" + gmsRec.getSampleRate() + ",nsamples=" + gmsRec.getNumSamples());
            System.out.println(gmsRec.getStartTime());
            i = 0;
            while (i < udata.length) {
                System.out.println(udata[i]);
                ++i;
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        catch (MiniseedFormatException msfEx) {
            msfEx.printStackTrace();
        }
    }

    public static void testDecompress1(String fname) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fname));
            bis.skip(0L);
            int recLen = 512;
            byte[] buf = new byte[recLen];
            long now_ms = new Date().getTime();
            int i = 0;
            while (i < 25600) {
                bis.read(buf, 0, recLen);
                GenericMiniSeedRecord gmsRec = GenericMiniSeedRecord.buildMiniSeedRecord(buf);
                long check_ms = gmsRec.getStartTime().getTime() / 1000L * 1000L + (long)(gmsRec.getStartTime().getNanos() / 1000000);
                int[] udata = new int[gmsRec.getNumSamples()];
                if (gmsRec.decompress(udata)) {
                    System.out.println("OK");
                } else {
                    System.out.println("Error");
                }
                System.out.print(String.valueOf(gmsRec.getStation()) + "/" + gmsRec.getChannel() + " ");
                System.out.println(gmsRec.getStartTime());
                int j = 0;
                while (j < udata.length) {
                    System.out.println(udata[j]);
                    ++j;
                }
                ++i;
            }
            long n_now_ms = new Date().getTime();
            System.err.println("Load one DECODE cycle elapse time: " + (n_now_ms - now_ms) + " ms.");
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        catch (Exception msfEx) {
            msfEx.printStackTrace();
        }
    }

    static int indexOf(byte[] buffer, byte[] str, int fromIndex) {
        return GenericMiniSeedRecord.indexOf(buffer, 0, buffer.length, str, 0, str.length, fromIndex);
    }

    static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && source[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (source[j++] == target[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    public static void main(String[] args) {
        System.out.println(fmt7_4f.format(0.0));
        System.out.println(fmt7_4f.format(11.1));
        System.out.println(fmt7_4f.format(1.12));
        System.out.println(fmt7_4f.format(11.1234));
        System.out.println(fmt7_4f.format(1.0E8));
        byte[] str = new byte[]{-86, -86, -86, -86, -86, -86, -86, -86, -86};
        byte[] buffer = new byte[]{97, -85, -86, -86, -84, -86, -86, -86, -86, -86, 98};
        int ret = GenericMiniSeedRecord.indexOf(buffer, str, 0);
        System.err.println(ret);
        GenericMiniSeedRecord.testDecompress(args[0]);
    }
}

