/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.miniseedutils.steim;

import edu.iris.miniseedutils.steim.CompressedFrame;
import edu.iris.miniseedutils.steim.GenericDataRecord;
import edu.iris.miniseedutils.steim.GenericDataRecordControl;
import edu.iris.miniseedutils.steim.Steim;
import edu.iris.timeutils.TimeStamp;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CompressMiniSeedRecord
extends GenericDataRecord {
    private short steimLevel = (short)2;
    private short flip = 0;
    private short dframes = (short)7;
    private short firstFrame = 0;
    private int nSampsInMiniSeedRecord = 0;
    private static Steim steim = new Steim();
    String netCode;
    String stationCode;
    String locID;
    String chanCode;
    byte[] startTimeStr;
    double sampleRate;
    TimeStamp startTime = null;
    int activityFlag = 0;
    int caliFlag = 32;

    public CompressMiniSeedRecord(short steimLevel, short dframes) {
        this.steimLevel = steimLevel;
        this.dframes = dframes;
        this.head = new byte[64];
        this.byteSwappedRec = false;
        this.recordLength = 1;
        int i = 0;
        while (i < this.get_rec_length(this.dframes)) {
            this.recordLength *= 2;
            ++i;
        }
        this.headLength = this.head.length;
        this.dataLength = this.recordLength - this.headLength;
        this.head = new byte[this.headLength];
        this.data = new byte[this.dataLength];
        this.frameLength = 64;
        int numRecordFrames = this.recordLength / this.frameLength;
        this.numHeaderFrames = (int)Math.ceil(this.headLength / this.frameLength);
        if (this.numHeaderFrames >= numRecordFrames) {
            return;
        }
        this.numDataFrames = numRecordFrames - this.numHeaderFrames;
        int recordHeaderLength = this.numHeaderFrames * this.frameLength;
        int recordDataLength = this.recordLength - recordHeaderLength;
        this.frames = new CompressedFrame[this.numDataFrames];
        int i2 = 0;
        while (i2 < this.frames.length) {
            this.frames[i2] = new CompressedFrame();
            ++i2;
        }
    }

    public void setStationInfo(String netCode, String StationCode, String locID, String chanCode) {
        this.netCode = netCode;
        this.stationCode = StationCode;
        this.locID = locID;
        this.chanCode = chanCode;
    }

    public void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public TimeStamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(TimeStamp startTime) {
        this.startTime = startTime;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTime(startTime);
        int year = c.get(1);
        int doy = c.get(6);
        int hour = c.get(11);
        int min = c.get(12);
        int intSec = c.get(13);
        int tenth_millisec = startTime.getNanoSecs() / 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10);
        try {
            DataOutputStream ds = new DataOutputStream(baos);
            ds.writeShort(year);
            ds.writeShort(doy);
            ds.writeByte(hour);
            ds.writeByte(min);
            ds.writeByte(intSec);
            ds.writeByte(0);
            ds.writeShort(tenth_millisec);
            ds.flush();
            ds.close();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.startTimeStr = baos.toByteArray();
    }

    public void setActivityFlag(int activityFlag) {
        this.activityFlag = activityFlag;
    }

    public void setCaliFlag(int edas_flag) {
        int flag = edas_flag & 3;
        if (flag == 0) {
            this.caliFlag = 32;
        } else if (flag == 1) {
            this.caliFlag = 96;
        } else if (flag == 2) {
            this.caliFlag = 160;
        } else if (flag == 3) {
            this.caliFlag = 224;
        }
    }

    private void installMiniSeedHeader() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        DataOutputStream ds = new DataOutputStream(baos);
        ds.writeBytes("######D ");
        ds.writeBytes(this.pad(this.stationCode, 5, ' '));
        ds.writeBytes(this.pad(this.locID, 2, ' '));
        ds.writeBytes(this.pad(this.chanCode, 3, ' '));
        ds.writeBytes(this.pad(this.netCode, 2, ' '));
        ds.write(this.startTimeStr);
        ds.writeShort(this.nSampsInMiniSeedRecord);
        if (this.sampleRate >= 1.0) {
            ds.writeShort((int)Math.round(this.sampleRate));
            ds.writeShort(1);
        } else {
            ds.writeShort((int)Math.round(-1.0 / this.sampleRate));
            ds.writeShort(1);
        }
        ds.writeByte(this.activityFlag);
        ds.writeByte(this.caliFlag);
        ds.writeByte(0);
        ds.writeByte(1);
        ds.writeByte(0);
        ds.writeByte(0);
        ds.writeByte(0);
        ds.writeByte(0);
        ds.writeShort(64);
        ds.writeShort(48);
        ds.writeShort(1000);
        ds.writeShort(0);
        switch (this.steimLevel) {
            case 1: {
                ds.writeByte(10);
                break;
            }
            case 2: {
                ds.writeByte(11);
                break;
            }
            case 3: {
                ds.writeByte(19);
            }
        }
        ds.writeByte(1);
        ds.writeByte(this.get_rec_length(this.dframes));
        ds.flush();
        ds.close();
        baos.close();
        System.arraycopy(baos.toByteArray(), 0, this.head, 0, baos.size());
    }

    private short get_rec_length(short dframes) {
        short rec_length = 0;
        switch (dframes) {
            case 1: {
                rec_length = 7;
                break;
            }
            case 3: {
                rec_length = 8;
                break;
            }
            case 7: {
                rec_length = 9;
                break;
            }
            case 15: {
                rec_length = 10;
                break;
            }
            case 31: {
                rec_length = 11;
                break;
            }
            case 63: {
                rec_length = 12;
                break;
            }
            default: {
                System.out.println("illegal SEED record length!\n");
            }
        }
        return rec_length;
    }

    public int encodeOneMiniSeedRecord(int[] darray) {
        return this.encodeOneMiniSeedRecord(darray, 0, darray.length);
    }

    public int encodeOneMiniSeedRecord(int[] darray, int compSamps) {
        return this.encodeOneMiniSeedRecord(darray, 0, compSamps);
    }

    public int encodeOneMiniSeedRecord(int[] darray, int startIdx, int compSamps) {
        int up_to_peek = startIdx;
        short adapt = (short)((this.dframes + 8) / 8);
        GenericDataRecordControl gdp = steim.initGenericCompression((short)1, adapt, this.dframes, this.steimLevel, this.flip, this);
        if (gdp == null) {
            System.out.println("Not enough mem");
        }
        steim.clearGenericCompression(gdp, this.firstFrame);
        int[] peekTmp = new int[1];
        while (true) {
            if (up_to_peek < startIdx + compSamps && steim.peekThresholdAvail(gdp.adp.ccp) < 0) {
                peekTmp[0] = darray[up_to_peek++];
                if (steim.peekWrite(gdp.adp.ccp, peekTmp, (short)1) == 1) continue;
                System.out.println("compression peek buffer failed to accept new data!\n");
                continue;
            }
            short nframes = steim.compressGenericRecord(gdp, this.firstFrame);
            if (nframes > this.dframes) {
                System.out.println("Frame came back too big from compress %d (>%d)");
            }
            if (nframes == this.dframes) break;
        }
        this.nSampsInMiniSeedRecord = steim.genericRecordSamples(gdp);
        try {
            this.installMiniSeedHeader();
            this.installMiniSeedData();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.nSampsInMiniSeedRecord;
    }

    private void installMiniSeedData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(448);
        DataOutputStream ds = new DataOutputStream(baos);
        int j = 0;
        while (j < this.dframes) {
            int k = 0;
            while (k < this.frames[j].cfp.length) {
                ds.writeInt(this.frames[j].cfp[k]);
                ++k;
            }
            ++j;
        }
        ds.flush();
        ds.close();
        baos.close();
        System.arraycopy(baos.toByteArray(), 0, this.data, 0, baos.size());
    }

    public String toString() {
        return "";
    }

    public byte[] getBytes() {
        byte[] totalData = new byte[this.head.length + this.data.length];
        System.arraycopy(this.head, 0, totalData, 0, this.head.length);
        System.arraycopy(this.data, 0, totalData, this.head.length, this.data.length);
        return totalData;
    }

    String pad(String aString, int len, char padChar) {
        StringBuffer buf = new StringBuffer(aString);
        int alen = len - aString.length();
        int i = 0;
        while (i < alen) {
            buf.append(padChar);
            ++i;
        }
        return buf.substring(0, len);
    }

    public static void main(String[] args) {
        try {
            int headLen = 64;
            int dataLen = 4032;
            int recLen = 4096;
            byte[] aHead = new byte[headLen];
            byte[] aData = new byte[dataLen];
            int[] udata = new int[6000];
            int i = 0;
            while (i < udata.length) {
                udata[i] = i;
                ++i;
            }
            int num = udata.length;
            CompressMiniSeedRecord cmsr = new CompressMiniSeedRecord(1, 63);
            cmsr.setSampleRate(50.0);
            cmsr.setStartTime(new TimeStamp(new Date().getTime()));
            cmsr.setStationInfo("IC", "BET", "10", "BHZ");
            int[] test = new int[10240];
            int nEncode = cmsr.encodeOneMiniSeedRecord(udata);
            FileOutputStream fos = new FileOutputStream("c:\\my.mseed");
            fos.write(cmsr.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        catch (Exception msfEx) {
            msfEx.printStackTrace();
        }
    }
}

