/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.corejava;

public class Format {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leading_zeroes = false;
    private boolean show_plus = false;
    private boolean alternate = false;
    private boolean show_space = false;
    private boolean left_align = false;
    private char fmt = (char)32;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Format(String s) {
        int length = s.length();
        int parse_state = 0;
        int i = 0;
        while (parse_state == 0) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == '%') {
                if (i >= length - 1) throw new IllegalArgumentException();
                if (s.charAt(i + 1) == '%') {
                    this.pre = String.valueOf(this.pre) + '%';
                    ++i;
                } else {
                    parse_state = 1;
                }
            } else {
                this.pre = String.valueOf(this.pre) + s.charAt(i);
            }
            ++i;
        }
        while (parse_state == 1) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == ' ') {
                this.show_space = true;
            } else if (s.charAt(i) == '-') {
                this.left_align = true;
            } else if (s.charAt(i) == '+') {
                this.show_plus = true;
            } else if (s.charAt(i) == '0') {
                this.leading_zeroes = true;
            } else if (s.charAt(i) == '#') {
                this.alternate = true;
            } else {
                parse_state = 2;
                --i;
            }
            ++i;
        }
        while (parse_state == 2) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.width = this.width * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            if (s.charAt(i) == '.') {
                parse_state = 3;
                this.precision = 0;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        while (parse_state == 3) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.precision = this.precision * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        if (parse_state == 4) {
            if (i >= length) {
                parse_state = 5;
            } else {
                this.fmt = s.charAt(i);
            }
            ++i;
        }
        if (i >= length) return;
        this.post = s.substring(i, length);
    }

    public static void printf(String fmt, double x) {
        System.out.print(new Format(fmt).format(x));
    }

    public static void printf(String fmt, int x) {
        System.out.print(new Format(fmt).format(x));
    }

    public static void printf(String fmt, long x) {
        System.out.print(new Format(fmt).format(x));
    }

    public static void printf(String fmt, char x) {
        System.out.print(new Format(fmt).format(x));
    }

    public static void printf(String fmt, String x) {
        System.out.print(new Format(fmt).format(x));
    }

    public static int atoi(String s) {
        return (int)Format.atol(s);
    }

    public static long atol(String s) {
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i < s.length() && s.charAt(i) == '0') {
            if (i + 1 < s.length() && (s.charAt(i + 1) == 'x' || s.charAt(i + 1) == 'X')) {
                return Format.parseLong(s.substring(i + 2), 16);
            }
            return Format.parseLong(s, 8);
        }
        return Format.parseLong(s, 10);
    }

    private static long parseLong(String s, int base) {
        int i = 0;
        int sign = 1;
        long r = 0L;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch < 48 + base) {
                r = r * (long)base + (long)ch - 48L;
            } else if ('A' <= ch && ch < 65 + base - 10) {
                r = r * (long)base + (long)ch - 65L + 10L;
            } else if ('a' <= ch && ch < 97 + base - 10) {
                r = r * (long)base + (long)ch - 97L + 10L;
            } else {
                return r * (long)sign;
            }
            ++i;
        }
        return r * (long)sign;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String s) {
        int i = 0;
        int sign = 1;
        double r = 0.0;
        double p = 1.0;
        boolean state = false;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (!state) {
                    r = r * 10.0 + (double)ch - 48.0;
                } else if (state) {
                    r += (p /= 10.0) * (double)(ch - 48);
                }
            } else if (ch == '.') {
                if (state) return (double)sign * r;
                state = true;
            } else {
                if (ch != 'e' && ch != 'E') return (double)sign * r;
                long e = (int)Format.parseLong(s.substring(i + 1), 10);
                return (double)sign * r * Math.pow(10.0, e);
            }
            ++i;
        }
        return (double)sign * r;
    }

    public String format(double x) {
        String r;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int s = 1;
        if (x < 0.0) {
            x = -x;
            s = -1;
        }
        int logTenFact = (int)Math.floor(Math.log(x) / Math.log(10.0));
        double multFact = Math.pow(10.0, this.precision - logTenFact);
        double xx = x;
        if (this.fmt == 'f' && x < 1.0 || this.fmt != 'f') {
            xx = (double)Math.round(x * multFact) / multFact;
        }
        if (this.fmt == 'f') {
            r = this.fixed_format(xx);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            r = this.exp_format(xx);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String format(int x) {
        long lx = x;
        if (this.fmt == 'o' || this.fmt == 'x' || this.fmt == 'X') {
            lx &= 0xFFFFFFFFL;
        }
        return this.format(lx);
    }

    public String format(long x) {
        String r;
        int s = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (x < 0L) {
                r = ("" + x).substring(1);
                s = -1;
            } else {
                r = "" + x;
                s = 1;
            }
        } else if (this.fmt == 'o') {
            r = Format.convert(x, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            r = Format.convert(x, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            r = Format.convert(x, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String format(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String r = "" + c;
        return this.pad(r);
    }

    public String format(String s) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0 && this.precision < s.length()) {
            s = s.substring(0, this.precision);
        }
        return this.pad(s);
    }

    public static void main(String[] a) {
        double x = 1.23456789012;
        double y = 123.0;
        double z = 1.2345E30;
        double w = 1.02;
        double u = 1.234E-5;
        double d1 = 999.9945;
        double d2 = 0.09999945;
        Format.printf("d1 = |%12.6E|\n", d1);
        Format.printf("d1 = |%11.5E|\n", d1);
        Format.printf("d1 = |%10.4E|\n", d1);
        Format.printf("d1 = |%7.3f|\n", d1);
        Format.printf("d1 = |%6.2f|\n", d1);
        Format.printf("d1 = |%6.1f|\n", d1);
        Format.printf("d2 = |%7.5f|\n", d2);
        Format.printf("d2 = |%8.6f|\n", d2);
        Format.printf("d2 = |%10.4E|\n", d2);
        Format.printf("d2 = |%11.5E|\n", d2);
        Format.printf("d2 = |%12.6E|\n", d2);
        int d = 51966;
        Format.printf("x = |%f|\n", x);
        Format.printf("u = |%20f|\n", u);
        Format.printf("x = |% .5f|\n", x);
        Format.printf("w = |%20.5f|\n", w);
        Format.printf("x = |%020.5f|\n", x);
        Format.printf("x = |%+20.5f|\n", x);
        Format.printf("x = |%+020.5f|\n", x);
        Format.printf("x = |% 020.5f|\n", x);
        Format.printf("y = |%#+20.5f|\n", y);
        Format.printf("y = |%-+20.5f|\n", y);
        Format.printf("z = |%20.5f|\n", z);
        Format.printf("x = |%e|\n", x);
        Format.printf("u = |%20e|\n", u);
        Format.printf("x = |% .5e|\n", x);
        Format.printf("w = |%20.5e|\n", w);
        Format.printf("x = |%020.5e|\n", x);
        Format.printf("x = |%+20.5e|\n", x);
        Format.printf("x = |%+020.5e|\n", x);
        Format.printf("x = |% 020.5e|\n", x);
        Format.printf("y = |%#+20.5e|\n", y);
        Format.printf("y = |%-+20.5e|\n", y);
        Format.printf("x = |%g|\n", x);
        Format.printf("z = |%g|\n", z);
        Format.printf("w = |%g|\n", w);
        Format.printf("u = |%g|\n", u);
        Format.printf("y = |%.2g|\n", y);
        Format.printf("y = |%#.2g|\n", y);
        Format.printf("d = |%d|\n", d);
        Format.printf("d = |%20d|\n", d);
        Format.printf("d = |%020d|\n", d);
        Format.printf("d = |%+20d|\n", d);
        Format.printf("d = |% 020d|\n", d);
        Format.printf("d = |%-20d|\n", d);
        Format.printf("d = |%20.8d|\n", d);
        Format.printf("d = |%x|\n", d);
        Format.printf("d = |%20X|\n", d);
        Format.printf("d = |%#20x|\n", d);
        Format.printf("d = |%020X|\n", d);
        Format.printf("d = |%20.8x|\n", d);
        Format.printf("d = |%o|\n", d);
        Format.printf("d = |%020o|\n", d);
        Format.printf("d = |%#20o|\n", d);
        Format.printf("d = |%#020o|\n", d);
        Format.printf("d = |%20.12o|\n", d);
        Format.printf("s = |%-20s|\n", "Hello");
        Format.printf("s = |%-20c|\n", '!');
        Format.printf("|%i|\n", Long.MIN_VALUE);
        Format.printf("|%6.2e|\n", 0.0);
        Format.printf("|%6.2g|\n", 0.0);
        Format.printf("|%6.2f|\n", 9.99);
        Format.printf("|%6.2f|\n", 9.999);
        Format.printf("|%6.0f|\n", 9.999);
        d = -1;
        Format.printf("d = |%X|\n", d);
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer s = new StringBuffer(n);
        int i = 0;
        while (i < n) {
            s.append(c);
            ++i;
        }
        return s.toString();
    }

    private static String convert(long x, int n, int m, String d) {
        if (x == 0L) {
            return "0";
        }
        String r = "";
        while (x != 0L) {
            r = String.valueOf(d.charAt((int)(x & (long)m))) + r;
            x >>>= n;
        }
        return r;
    }

    private String pad(String r) {
        String p = Format.repeat(' ', this.width - r.length());
        if (this.left_align) {
            return String.valueOf(this.pre) + r + p + this.post;
        }
        return String.valueOf(this.pre) + p + r + this.post;
    }

    private String sign(int s, String r) {
        String p = "";
        if (s < 0) {
            p = "-";
        } else if (s > 0) {
            if (this.show_plus) {
                p = "+";
            } else if (this.show_space) {
                p = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && r.length() > 0 && r.charAt(0) != '0') {
            p = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            p = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            p = "0X";
        }
        int w = 0;
        if (this.leading_zeroes) {
            w = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            w = this.precision;
        }
        return String.valueOf(p) + Format.repeat('0', w - p.length() - r.length()) + r;
    }

    private String fixed_format(double d) {
        boolean removeTrailing;
        boolean bl = removeTrailing = (this.fmt == 'G' || this.fmt == 'g') && !this.alternate;
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        if (this.precision == 0) {
            return String.valueOf((long)(d + 0.5)) + (removeTrailing ? "" : ".");
        }
        long whole = (long)d;
        double fr = d - (double)whole;
        if (fr >= 1.0 || fr < 0.0) {
            return this.exp_format(d);
        }
        double factor = 1.0;
        String leading_zeroes = "";
        int i = 1;
        while (i <= this.precision && factor <= 9.223372036854776E18) {
            factor *= 10.0;
            leading_zeroes = String.valueOf(leading_zeroes) + "0";
            ++i;
        }
        long l = (long)(factor * fr + 0.5);
        if ((double)l >= factor) {
            l = 0L;
            ++whole;
        }
        String z = String.valueOf(leading_zeroes) + l;
        z = "." + z.substring(z.length() - this.precision, z.length());
        if (removeTrailing) {
            int t = z.length() - 1;
            while (t >= 0 && z.charAt(t) == '0') {
                --t;
            }
            if (t >= 0 && z.charAt(t) == '.') {
                --t;
            }
            z = z.substring(0, t + 1);
        }
        return String.valueOf(whole) + z;
    }

    private String exp_format(double d) {
        String f = "";
        int e = 0;
        double dd = d;
        double factor = 1.0;
        if (d != 0.0) {
            while (dd >= 10.0) {
                ++e;
                factor /= 10.0;
                dd /= 10.0;
            }
            while (dd < 1.0) {
                --e;
                factor *= 10.0;
                dd *= 10.0;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && e >= -4 && e < this.precision) {
            return this.fixed_format(d);
        }
        f = String.valueOf(f) + this.fixed_format(d *= factor);
        f = this.fmt == 'e' || this.fmt == 'g' ? String.valueOf(f) + "e" : String.valueOf(f) + "E";
        String p = "00";
        if (e >= 0) {
            f = String.valueOf(f) + "+";
            p = String.valueOf(p) + e;
        } else {
            f = String.valueOf(f) + "-";
            p = String.valueOf(p) + -e;
        }
        return String.valueOf(f) + p.substring(p.length() - 2, p.length());
    }
}

