/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.util.Progress;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class WindowProgress
implements Progress {
    private static final int WIDTH = 360;
    private static final int HEIGHT = 140;
    private static final int WARNING_HEIGHT = 120;
    private static final int HMARGIN = 12;
    private static final int VMARGIN = 9;
    private static final int WARNING_MARGIN = 8;
    private final Component window;
    private final JComponent content;
    private final JProgressBar progressBar;
    private final JLabel description;
    private final JButton cancel;
    private JComponent warningArea;
    private String lastSource;
    private volatile boolean canceled;
    private int worked;
    private int total;

    public WindowProgress(Component parent) {
        this(parent, "Progress", "Cancel");
    }

    public WindowProgress(Component parent, String TITLE, String CANCEL) {
        Dimension parentSize;
        Container frame;
        JDesktopPane desktop = JOptionPane.getDesktopPaneForComponent(parent);
        if (desktop != null) {
            frame = new JInternalFrame(TITLE);
            this.window = frame;
            this.content = new JPanel();
            parentSize = desktop.getSize();
            ((JInternalFrame)frame).setContentPane(this.content);
            ((JInternalFrame)frame).setDefaultCloseOperation(1);
            desktop.add((Component)frame, JLayeredPane.PALETTE_LAYER);
        } else {
            frame = JOptionPane.getFrameForComponent(parent);
            JDialog dialog = new JDialog((Frame)frame, TITLE);
            this.window = dialog;
            this.content = (JComponent)dialog.getContentPane();
            parentSize = frame.getSize();
            if (parentSize.width == 0 || parentSize.height == 0) {
                parentSize = Toolkit.getDefaultToolkit().getScreenSize();
            }
            dialog.setDefaultCloseOperation(1);
            dialog.setResizable(false);
        }
        this.window.setBounds((parentSize.width - 360) / 2, (parentSize.height - 140) / 2, 360, 140);
        this.description = new JLabel();
        this.description.setHorizontalAlignment(0);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 9, 6, 9), this.progressBar.getBorder()));
        this.cancel = new JButton(CANCEL);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowProgress.this.setCanceled(true);
            }
        });
        Box cancelBox = Box.createHorizontalBox();
        cancelBox.add(Box.createGlue());
        cancelBox.add(this.cancel);
        cancelBox.add(Box.createGlue());
        cancelBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(9, 12, 9, 12), BorderFactory.createEtchedBorder()));
        panel.add(this.description);
        panel.add(this.progressBar);
        this.content.setLayout(new BorderLayout());
        this.content.add((Component)panel, "North");
        this.content.add((Component)cancelBox, "South");
    }

    public void begin(final String mainTask, int totalWork) {
        this.worked = 0;
        this.total = totalWork;
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BoundedRangeModel model = WindowProgress.this.progressBar.getModel();
                if (WindowProgress.this.total == -1) {
                    WindowProgress.this.progressBar.setIndeterminate(true);
                } else {
                    model.setRangeProperties(WindowProgress.this.worked, 1, 0, WindowProgress.this.total, false);
                }
                WindowProgress.this.description.setText(mainTask);
                WindowProgress.this.window.setVisible(true);
                WindowProgress windowProgress = WindowProgress.this;
                synchronized (windowProgress) {
                    if (WindowProgress.this.window instanceof JDialog) {
                        JDialog window = (JDialog)WindowProgress.this.window;
                        window.setDefaultCloseOperation(0);
                    } else {
                        JInternalFrame window = (JInternalFrame)WindowProgress.this.window;
                        window.setClosable(false);
                    }
                }
            }
        });
    }

    public void done() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BoundedRangeModel model = WindowProgress.this.progressBar.getModel();
                model.setRangeProperties(100, 1, 0, 100, false);
                WindowProgress.this.window.setVisible(WindowProgress.this.warningArea != null);
                WindowProgress.this.cancel.setEnabled(false);
                WindowProgress windowProgress = WindowProgress.this;
                synchronized (windowProgress) {
                    if (WindowProgress.this.window instanceof JDialog) {
                        JDialog window = (JDialog)WindowProgress.this.window;
                        window.setDefaultCloseOperation(1);
                    } else {
                        JInternalFrame window = (JInternalFrame)WindowProgress.this.window;
                        window.setClosable(true);
                    }
                }
            }
        });
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(final boolean isCanceled) {
        this.canceled = isCanceled;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowProgress.this.cancel.setEnabled(!isCanceled);
            }
        });
    }

    public void setTask(final String task) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowProgress.this.description.setText(task);
            }
        });
    }

    public void worked(int amountWorked) {
        this.worked += amountWorked;
        if (this.worked >= this.total) {
            this.done();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BoundedRangeModel model = WindowProgress.this.progressBar.getModel();
                    model.setValue(WindowProgress.this.worked);
                    WindowProgress.this.progressBar.setIndeterminate(false);
                }
            });
        }
    }

    public String toString() {
        return this.description.getName();
    }
}

