/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.simplify.LineSegmentIndex;
import com.vividsolutions.jts.simplify.TaggedLineSegment;
import com.vividsolutions.jts.simplify.TaggedLineString;
import java.util.List;

public class TaggedLineStringSimplifier {
    private static LineIntersector li = new RobustLineIntersector();
    private LineSegmentIndex inputIndex = new LineSegmentIndex();
    private LineSegmentIndex outputIndex = new LineSegmentIndex();
    private TaggedLineString line;
    private Coordinate[] linePts;
    private double distanceTolerance = 0.0;
    private int[] validSectionIndex = new int[2];

    public TaggedLineStringSimplifier(LineSegmentIndex inputIndex, LineSegmentIndex outputIndex) {
        this.inputIndex = inputIndex;
        this.outputIndex = outputIndex;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public void simplify(TaggedLineString line) {
        this.line = line;
        this.linePts = line.getParentCoordinates();
        this.simplifySection(0, this.linePts.length - 1, 0);
    }

    private void simplifySection(int i, int j, int depth) {
        int worstCaseSize;
        ++depth;
        int[] sectionIndex = new int[2];
        if (i + 1 == j) {
            TaggedLineSegment newSeg = this.line.getSegment(i);
            this.line.addToResult(newSeg);
            return;
        }
        boolean isValidToSimplify = true;
        if (this.line.getResultSize() < this.line.getMinimumSize() && (worstCaseSize = depth + 1) < this.line.getMinimumSize()) {
            isValidToSimplify = false;
        }
        double[] distance = new double[1];
        int furthestPtIndex = this.findFurthestPoint(this.linePts, i, j, distance);
        if (distance[0] > this.distanceTolerance) {
            isValidToSimplify = false;
        }
        LineSegment candidateSeg = new LineSegment();
        candidateSeg.p0 = this.linePts[i];
        candidateSeg.p1 = this.linePts[j];
        sectionIndex[0] = i;
        sectionIndex[1] = j;
        if (this.hasBadIntersection(this.line, sectionIndex, candidateSeg)) {
            isValidToSimplify = false;
        }
        if (isValidToSimplify) {
            LineSegment newSeg = this.flatten(i, j);
            this.line.addToResult(newSeg);
            return;
        }
        this.simplifySection(i, furthestPtIndex, depth);
        this.simplifySection(furthestPtIndex, j, depth);
    }

    private int findFurthestPoint(Coordinate[] pts, int i, int j, double[] maxDistance) {
        LineSegment seg = new LineSegment();
        seg.p0 = pts[i];
        seg.p1 = pts[j];
        double maxDist = -1.0;
        int maxIndex = i;
        int k = i + 1;
        while (k < j) {
            Coordinate midPt = pts[k];
            double distance = seg.distance(midPt);
            if (distance > maxDist) {
                maxDist = distance;
                maxIndex = k;
            }
            ++k;
        }
        maxDistance[0] = maxDist;
        return maxIndex;
    }

    private LineSegment flatten(int start, int end) {
        Coordinate p0 = this.linePts[start];
        Coordinate p1 = this.linePts[end];
        LineSegment newSeg = new LineSegment(p0, p1);
        this.remove(this.line, start, end);
        this.outputIndex.add(newSeg);
        return newSeg;
    }

    private boolean hasBadIntersection(TaggedLineString parentLine, int[] sectionIndex, LineSegment candidateSeg) {
        if (this.hasBadOutputIntersection(candidateSeg)) {
            return true;
        }
        return this.hasBadInputIntersection(parentLine, sectionIndex, candidateSeg);
    }

    private boolean hasBadOutputIntersection(LineSegment candidateSeg) {
        List querySegs = this.outputIndex.query(candidateSeg);
        for (LineSegment querySeg : querySegs) {
            if (!this.hasInteriorIntersection(querySeg, candidateSeg)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBadInputIntersection(TaggedLineString parentLine, int[] sectionIndex, LineSegment candidateSeg) {
        List querySegs = this.inputIndex.query(candidateSeg);
        for (TaggedLineSegment querySeg : querySegs) {
            if (!this.hasInteriorIntersection(querySeg, candidateSeg) || TaggedLineStringSimplifier.isInLineSection(parentLine, sectionIndex, querySeg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInLineSection(TaggedLineString line, int[] sectionIndex, TaggedLineSegment seg) {
        if (seg.getParent() != line.getParent()) {
            return false;
        }
        int segIndex = seg.getIndex();
        return segIndex >= sectionIndex[0] && segIndex < sectionIndex[1];
    }

    private boolean hasInteriorIntersection(LineSegment seg0, LineSegment seg1) {
        li.computeIntersection(seg0.p0, seg0.p1, seg1.p0, seg1.p1);
        return li.isInteriorIntersection();
    }

    private void remove(TaggedLineString line, int start, int end) {
        int i = start;
        while (i < end) {
            TaggedLineSegment seg = line.getSegment(i);
            this.inputIndex.remove(seg);
            ++i;
        }
    }
}

