/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.precision.CommonBits;

public class CommonBitsRemover {
    private Coordinate commonCoord;
    private CommonCoordinateFilter ccFilter = new CommonCoordinateFilter();

    public void add(Geometry geom) {
        geom.apply(this.ccFilter);
        this.commonCoord = this.ccFilter.getCommonCoordinate();
    }

    public Coordinate getCommonCoordinate() {
        return this.commonCoord;
    }

    public Geometry removeCommonBits(Geometry geom) {
        if (this.commonCoord.x == 0.0 && this.commonCoord.y == 0.0) {
            return geom;
        }
        Coordinate invCoord = new Coordinate(this.commonCoord);
        invCoord.x = -invCoord.x;
        invCoord.y = -invCoord.y;
        Translater trans = new Translater(invCoord);
        geom.apply(trans);
        geom.geometryChanged();
        return geom;
    }

    public void addCommonBits(Geometry geom) {
        Translater trans = new Translater(this.commonCoord);
        geom.apply(trans);
        geom.geometryChanged();
    }

    class CommonCoordinateFilter
    implements CoordinateFilter {
        private CommonBits commonBitsX = new CommonBits();
        private CommonBits commonBitsY = new CommonBits();

        CommonCoordinateFilter() {
        }

        public void filter(Coordinate coord) {
            this.commonBitsX.add(coord.x);
            this.commonBitsY.add(coord.y);
        }

        public Coordinate getCommonCoordinate() {
            return new Coordinate(this.commonBitsX.getCommon(), this.commonBitsY.getCommon());
        }
    }

    class Translater
    implements CoordinateFilter {
        Coordinate trans = null;

        public Translater(Coordinate trans) {
            this.trans = trans;
        }

        public void filter(Coordinate coord) {
            coord.x += this.trans.x;
            coord.y += this.trans.y;
        }
    }
}

