/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.MaximalEdgeRing;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectedInteriorTester {
    private GeometryFactory geometryFactory = new GeometryFactory();
    private CGAlgorithms cga = new CGAlgorithms();
    private GeometryGraph geomGraph;
    private Coordinate disconnectedRingcoord;

    public static Coordinate findDifferentPoint(Coordinate[] coord, Coordinate pt) {
        int i = 0;
        while (i < coord.length) {
            if (!coord[i].equals(pt)) {
                return coord[i];
            }
            ++i;
        }
        return null;
    }

    public ConnectedInteriorTester(GeometryGraph geomGraph) {
        this.geomGraph = geomGraph;
    }

    public Coordinate getCoordinate() {
        return this.disconnectedRingcoord;
    }

    public boolean isInteriorsConnected() {
        ArrayList splitEdges = new ArrayList();
        this.geomGraph.computeSplitEdges(splitEdges);
        PlanarGraph graph = new PlanarGraph(new OverlayNodeFactory());
        graph.addEdges(splitEdges);
        this.setInteriorEdgesInResult(graph);
        graph.linkResultDirectedEdges();
        List edgeRings = this.buildEdgeRings(graph.getEdgeEnds());
        this.visitShellInteriors(this.geomGraph.getGeometry(), graph);
        return !this.hasUnvisitedShellEdge(edgeRings);
    }

    private void setInteriorEdgesInResult(PlanarGraph graph) {
        for (DirectedEdge de : graph.getEdgeEnds()) {
            if (de.getLabel().getLocation(0, 2) != 0) continue;
            de.setInResult(true);
        }
    }

    private List buildEdgeRings(Collection dirEdges) {
        ArrayList edgeRings = new ArrayList();
        for (DirectedEdge de : dirEdges) {
            if (!de.isInResult() || de.getEdgeRing() != null) continue;
            MaximalEdgeRing er = new MaximalEdgeRing(de, this.geometryFactory, this.cga);
            er.linkDirectedEdgesForMinimalEdgeRings();
            List minEdgeRings = er.buildMinimalRings();
            edgeRings.addAll(minEdgeRings);
        }
        return edgeRings;
    }

    private void visitShellInteriors(Geometry g, PlanarGraph graph) {
        if (g instanceof Polygon) {
            Polygon p = (Polygon)g;
            this.visitInteriorRing(p.getExteriorRing(), graph);
        }
        if (g instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g;
            int i = 0;
            while (i < mp.getNumGeometries()) {
                Polygon p = (Polygon)mp.getGeometryN(i);
                this.visitInteriorRing(p.getExteriorRing(), graph);
                ++i;
            }
        }
    }

    private void visitInteriorRing(LineString ring, PlanarGraph graph) {
        Coordinate[] pts = ring.getCoordinates();
        Coordinate pt0 = pts[0];
        Coordinate pt1 = ConnectedInteriorTester.findDifferentPoint(pts, pt0);
        Edge e = graph.findEdgeInSameDirection(pt0, pt1);
        DirectedEdge de = (DirectedEdge)graph.findEdgeEnd(e);
        DirectedEdge intDe = null;
        if (de.getLabel().getLocation(0, 2) == 0) {
            intDe = de;
        } else if (de.getSym().getLabel().getLocation(0, 2) == 0) {
            intDe = de.getSym();
        }
        Assert.isTrue(intDe != null, "unable to find dirEdge with Interior on RHS");
        this.visitLinkedDirectedEdges(intDe);
    }

    protected void visitLinkedDirectedEdges(DirectedEdge start) {
        DirectedEdge startDe = start;
        DirectedEdge de = start;
        do {
            Assert.isTrue(de != null, "found null Directed Edge");
            de.setVisited(true);
        } while ((de = de.getNext()) != startDe);
    }

    private boolean hasUnvisitedShellEdge(List edgeRings) {
        int i = 0;
        while (i < edgeRings.size()) {
            List edges;
            DirectedEdge de;
            EdgeRing er = (EdgeRing)edgeRings.get(i);
            if (!er.isHole() && (de = (DirectedEdge)(edges = er.getEdges()).get(0)).getLabel().getLocation(0, 2) == 0) {
                int j = 0;
                while (j < edges.size()) {
                    de = (DirectedEdge)edges.get(j);
                    if (!de.isVisited()) {
                        this.disconnectedRingcoord = de.getCoordinate();
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }
}

