/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.PointExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.operation.distance.ConnectedElementLocationFilter;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import java.util.List;

public class DistanceOp {
    private Geometry[] geom;
    private double terminateDistance = 0.0;
    private PointLocator ptLocator = new PointLocator();
    private GeometryLocation[] minDistanceLocation;
    private double minDistance = Double.MAX_VALUE;

    public static double distance(Geometry g0, Geometry g1) {
        DistanceOp distOp = new DistanceOp(g0, g1);
        return distOp.distance();
    }

    public static boolean isWithinDistance(Geometry g0, Geometry g1, double distance) {
        DistanceOp distOp = new DistanceOp(g0, g1, distance);
        return distOp.distance() <= distance;
    }

    public static Coordinate[] closestPoints(Geometry g0, Geometry g1) {
        DistanceOp distOp = new DistanceOp(g0, g1);
        return distOp.closestPoints();
    }

    public DistanceOp(Geometry g0, Geometry g1) {
        this(g0, g1, 0.0);
    }

    public DistanceOp(Geometry g0, Geometry g1, double terminateDistance) {
        this.geom = new Geometry[2];
        this.geom[0] = g0;
        this.geom[1] = g1;
        this.terminateDistance = terminateDistance;
    }

    public double distance() {
        this.computeMinDistance();
        return this.minDistance;
    }

    public Coordinate[] closestPoints() {
        this.computeMinDistance();
        Coordinate[] closestPts = new Coordinate[]{this.minDistanceLocation[0].getCoordinate(), this.minDistanceLocation[1].getCoordinate()};
        return closestPts;
    }

    public GeometryLocation[] closestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    private void updateMinDistance(double dist) {
        if (dist < this.minDistance) {
            this.minDistance = dist;
        }
    }

    private void updateMinDistance(GeometryLocation[] locGeom, boolean flip) {
        if (locGeom[0] == null) {
            return;
        }
        if (flip) {
            this.minDistanceLocation[0] = locGeom[1];
            this.minDistanceLocation[1] = locGeom[0];
        } else {
            this.minDistanceLocation[0] = locGeom[0];
            this.minDistanceLocation[1] = locGeom[1];
        }
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        this.computeContainmentDistance();
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeLineDistance();
    }

    private void computeContainmentDistance() {
        List polys0 = PolygonExtracter.getPolygons(this.geom[0]);
        List polys1 = PolygonExtracter.getPolygons(this.geom[1]);
        GeometryLocation[] locPtPoly = new GeometryLocation[2];
        if (polys1.size() > 0) {
            List insideLocs0 = ConnectedElementLocationFilter.getLocations(this.geom[0]);
            this.computeInside(insideLocs0, polys1, locPtPoly);
            if (this.minDistance <= this.terminateDistance) {
                this.minDistanceLocation[0] = locPtPoly[0];
                this.minDistanceLocation[1] = locPtPoly[1];
                return;
            }
        }
        if (polys0.size() > 0) {
            List insideLocs1 = ConnectedElementLocationFilter.getLocations(this.geom[1]);
            this.computeInside(insideLocs1, polys0, locPtPoly);
            if (this.minDistance <= this.terminateDistance) {
                this.minDistanceLocation[0] = locPtPoly[1];
                this.minDistanceLocation[1] = locPtPoly[0];
                return;
            }
        }
    }

    private void computeInside(List locs, List polys, GeometryLocation[] locPtPoly) {
        int i = 0;
        while (i < locs.size()) {
            GeometryLocation loc = (GeometryLocation)locs.get(i);
            int j = 0;
            while (j < polys.size()) {
                Polygon poly = (Polygon)polys.get(j);
                this.computeInside(loc, poly, locPtPoly);
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private void computeInside(GeometryLocation ptLoc, Polygon poly, GeometryLocation[] locPtPoly) {
        Coordinate pt = ptLoc.getCoordinate();
        if (2 != this.ptLocator.locate(pt, (Geometry)poly)) {
            GeometryLocation locPoly;
            this.minDistance = 0.0;
            locPtPoly[0] = ptLoc;
            locPtPoly[1] = locPoly = new GeometryLocation(poly, pt);
            return;
        }
    }

    private void computeLineDistance() {
        GeometryLocation[] locGeom = new GeometryLocation[2];
        List lines0 = LinearComponentExtracter.getLines(this.geom[0]);
        List lines1 = LinearComponentExtracter.getLines(this.geom[1]);
        List pts0 = PointExtracter.getPoints(this.geom[0]);
        List pts1 = PointExtracter.getPoints(this.geom[1]);
        this.computeMinDistanceLines(lines0, lines1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines1, pts0, locGeom);
        this.updateMinDistance(locGeom, true);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistancePoints(pts0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
    }

    private void computeMinDistanceLines(List lines0, List lines1, GeometryLocation[] locGeom) {
        int i = 0;
        while (i < lines0.size()) {
            LineString line0 = (LineString)lines0.get(i);
            int j = 0;
            while (j < lines1.size()) {
                LineString line1 = (LineString)lines1.get(j);
                this.computeMinDistance(line0, line1, locGeom);
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private void computeMinDistancePoints(List points0, List points1, GeometryLocation[] locGeom) {
        int i = 0;
        while (i < points0.size()) {
            Point pt0 = (Point)points0.get(i);
            int j = 0;
            while (j < points1.size()) {
                Point pt1 = (Point)points1.get(j);
                double dist = pt0.getCoordinate().distance(pt1.getCoordinate());
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    locGeom[0] = new GeometryLocation(pt0, 0, pt0.getCoordinate());
                    locGeom[1] = new GeometryLocation(pt1, 0, pt1.getCoordinate());
                }
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private void computeMinDistanceLinesPoints(List lines, List points, GeometryLocation[] locGeom) {
        int i = 0;
        while (i < lines.size()) {
            LineString line = (LineString)lines.get(i);
            int j = 0;
            while (j < points.size()) {
                Point pt = (Point)points.get(j);
                this.computeMinDistance(line, pt, locGeom);
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private void computeMinDistance(LineString line0, LineString line1, GeometryLocation[] locGeom) {
        if (line0.getEnvelopeInternal().distance(line1.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coord0 = line0.getCoordinates();
        Coordinate[] coord1 = line1.getCoordinates();
        int i = 0;
        while (i < coord0.length - 1) {
            int j = 0;
            while (j < coord1.length - 1) {
                double dist = CGAlgorithms.distanceLineLine(coord0[i], coord0[i + 1], coord1[j], coord1[j + 1]);
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    LineSegment seg0 = new LineSegment(coord0[i], coord0[i + 1]);
                    LineSegment seg1 = new LineSegment(coord1[j], coord1[j + 1]);
                    Coordinate[] closestPt = seg0.closestPoints(seg1);
                    locGeom[0] = new GeometryLocation(line0, i, closestPt[0]);
                    locGeom[1] = new GeometryLocation(line1, j, closestPt[1]);
                }
                if (this.minDistance <= this.terminateDistance) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private void computeMinDistance(LineString line, Point pt, GeometryLocation[] locGeom) {
        if (line.getEnvelopeInternal().distance(pt.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coord0 = line.getCoordinates();
        Coordinate coord = pt.getCoordinate();
        int i = 0;
        while (i < coord0.length - 1) {
            double dist = CGAlgorithms.distancePointLine(coord, coord0[i], coord0[i + 1]);
            if (dist < this.minDistance) {
                this.minDistance = dist;
                LineSegment seg = new LineSegment(coord0[i], coord0[i + 1]);
                Coordinate segClosestPoint = seg.closestPoint(coord);
                locGeom[0] = new GeometryLocation(line, i, segClosestPoint);
                locGeom[1] = new GeometryLocation(pt, 0, coord);
            }
            if (this.minDistance <= this.terminateDistance) {
                return;
            }
            ++i;
        }
    }
}

