/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.noding.ScaledNoder;
import com.vividsolutions.jts.noding.snapround.MCIndexSnapRounder;
import com.vividsolutions.jts.operation.buffer.BufferBuilder;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.util.NullProgress;
import com.vividsolutions.jts.util.Progress;

public class BufferOp {
    public static final int CAP_ROUND = 1;
    public static final int CAP_BUTT = 2;
    public static final int CAP_FLAT = 2;
    public static final int CAP_SQUARE = 3;
    private static int MAX_PRECISION_DIGITS = 12;
    private Geometry argGeom;
    private double distance;
    private BufferParameters bufParams = new BufferParameters();
    private Geometry resultGeometry = null;
    private RuntimeException saveException;

    private static double precisionScaleFactor(Geometry g, double distance, int maxPrecisionDigits) {
        Envelope env = g.getEnvelopeInternal();
        double envSize = Math.max(env.getHeight(), env.getWidth());
        double expandByDistance = distance > 0.0 ? distance : 0.0;
        double bufEnvSize = envSize + 2.0 * expandByDistance;
        int bufEnvLog10 = (int)(Math.log(bufEnvSize) / Math.log(10.0) + 1.0);
        int minUnitLog10 = bufEnvLog10 - maxPrecisionDigits;
        double scaleFactor = Math.pow(10.0, -minUnitLog10);
        return scaleFactor;
    }

    public static Geometry bufferOp(Geometry g, double distance) {
        BufferOp gBuf = new BufferOp(g);
        Geometry geomBuf = gBuf.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g, double distance, BufferParameters params) {
        BufferOp bufOp = new BufferOp(g, params);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g, double distance, int quadrantSegments) {
        BufferOp bufOp = new BufferOp(g);
        bufOp.setQuadrantSegments(quadrantSegments);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g, double distance, int quadrantSegments, int endCapStyle) {
        BufferOp bufOp = new BufferOp(g);
        bufOp.setQuadrantSegments(quadrantSegments);
        bufOp.setEndCapStyle(endCapStyle);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public BufferOp(Geometry g) {
        this.argGeom = g;
    }

    public BufferOp(Geometry g, BufferParameters bufParams) {
        this.argGeom = g;
        this.bufParams = bufParams;
    }

    public void setEndCapStyle(int endCapStyle) {
        this.bufParams.setEndCapStyle(endCapStyle);
    }

    public void setQuadrantSegments(int quadrantSegments) {
        this.bufParams.setQuadrantSegments(quadrantSegments);
    }

    public Geometry getResultGeometry(double distance) {
        this.distance = distance;
        this.computeGeometry(new NullProgress());
        return this.resultGeometry;
    }

    public Geometry getResultGeometry(double distance, Progress progress) {
        this.distance = distance;
        this.computeGeometry(progress);
        return this.resultGeometry;
    }

    private void computeGeometry(Progress progress) {
        this.bufferOriginalPrecision(progress);
        if (this.resultGeometry != null) {
            return;
        }
        PrecisionModel argPM = this.argGeom.getFactory().getPrecisionModel();
        if (argPM.getType() == PrecisionModel.FIXED) {
            this.bufferFixedPrecision(argPM, progress);
        } else {
            this.bufferReducedPrecision(progress);
        }
    }

    private void bufferReducedPrecision(Progress progress) {
        int precDigits = MAX_PRECISION_DIGITS;
        while (precDigits >= 0) {
            try {
                this.bufferReducedPrecision(precDigits, progress);
            }
            catch (TopologyException ex) {
                this.saveException = ex;
            }
            if (this.resultGeometry != null) {
                return;
            }
            --precDigits;
        }
        throw this.saveException;
    }

    private void bufferOriginalPrecision(Progress progress) {
        try {
            BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
            this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance);
        }
        catch (RuntimeException ex) {
            this.saveException = ex;
        }
    }

    private void bufferReducedPrecision(int precisionDigits, Progress progress) {
        double sizeBasedScaleFactor = BufferOp.precisionScaleFactor(this.argGeom, this.distance, precisionDigits);
        PrecisionModel fixedPM = new PrecisionModel(sizeBasedScaleFactor);
        this.bufferFixedPrecision(fixedPM, progress);
    }

    private void bufferFixedPrecision(PrecisionModel fixedPM, Progress progress) {
        ScaledNoder noder = new ScaledNoder(new MCIndexSnapRounder(new PrecisionModel(1.0)), fixedPM.getScale());
        BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
        bufBuilder.setWorkingPrecisionModel(fixedPM);
        bufBuilder.setNoder(noder);
        this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance, progress);
    }
}

