/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.NodableSegmentString;
import com.vividsolutions.jts.noding.Octant;
import com.vividsolutions.jts.noding.SegmentNode;
import com.vividsolutions.jts.noding.SegmentNodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodedSegmentString
implements NodableSegmentString {
    private SegmentNodeList nodeList = new SegmentNodeList(this);
    private Coordinate[] pts;
    private Object data;

    public static List getNodedSubstrings(Collection segStrings) {
        ArrayList resultEdgelist = new ArrayList();
        NodedSegmentString.getNodedSubstrings(segStrings, resultEdgelist);
        return resultEdgelist;
    }

    public static void getNodedSubstrings(Collection segStrings, Collection resultEdgelist) {
        for (NodedSegmentString ss : segStrings) {
            ss.getNodeList().addSplitEdges(resultEdgelist);
        }
    }

    public NodedSegmentString(Coordinate[] pts, Object data) {
        this.pts = pts;
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public SegmentNodeList getNodeList() {
        return this.nodeList;
    }

    public int size() {
        return this.pts.length;
    }

    public Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public int getSegmentOctant(int index) {
        if (index == this.pts.length - 1) {
            return -1;
        }
        return Octant.octant(this.getCoordinate(index), this.getCoordinate(index + 1));
    }

    public void addIntersections(LineIntersector li, int segmentIndex, int geomIndex) {
        int i = 0;
        while (i < li.getIntersectionNum()) {
            this.addIntersection(li, segmentIndex, geomIndex, i);
            ++i;
        }
    }

    public void addIntersection(LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        this.addIntersection(intPt, segmentIndex);
    }

    public void addIntersection(Coordinate intPt, int segmentIndex) {
        this.addIntersectionNode(intPt, segmentIndex);
    }

    public SegmentNode addIntersectionNode(Coordinate intPt, int segmentIndex) {
        Coordinate nextPt;
        int normalizedSegmentIndex = segmentIndex;
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
        }
        SegmentNode ei = this.nodeList.add(intPt, normalizedSegmentIndex);
        return ei;
    }
}

