/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainBuilder;
import com.vividsolutions.jts.index.chain.MonotoneChainOverlapAction;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.SinglePassNoder;
import com.vividsolutions.jts.util.NullProgress;
import com.vividsolutions.jts.util.Progress;
import com.vividsolutions.jts.util.SubProgress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MCIndexNoder
extends SinglePassNoder {
    private List monoChains = new ArrayList();
    private SpatialIndex index = new STRtree();
    private int idCounter = 0;
    private Collection nodedSegStrings;
    private int nOverlaps = 0;

    public List getMonotoneChains() {
        return this.monoChains;
    }

    public SpatialIndex getIndex() {
        return this.index;
    }

    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    public void computeNodes(Collection inputSegStrings) {
        this.computeNodes(inputSegStrings, new NullProgress());
    }

    public void computeNodes(Collection inputSegStrings, Progress progress) throws IllegalStateException {
        if (progress == null) {
            progress = new NullProgress();
        }
        progress.begin("Compute Nodes", 100);
        SubProgress setup = new SubProgress(progress, 50);
        setup.begin("Add SegementStrings", inputSegStrings.size());
        this.nodedSegStrings = inputSegStrings;
        Iterator i = inputSegStrings.iterator();
        while (i.hasNext()) {
            this.add((SegmentString)i.next());
            setup.worked(1);
            if (!setup.isCanceled()) continue;
            throw new IllegalStateException("Canceled");
        }
        setup.done();
        this.intersectChains(new SubProgress(progress, 50));
    }

    private void intersectChains(Progress progress) throws IllegalStateException {
        if (progress == null) {
            progress = new NullProgress();
        }
        SegmentOverlapAction overlapAction = new SegmentOverlapAction(this.segInt);
        progress.begin("Intersect chains", this.monoChains.size());
        for (MonotoneChain queryChain : this.monoChains) {
            List overlapChains = this.index.query(queryChain.getEnvelope());
            for (MonotoneChain testChain : overlapChains) {
                if (testChain.getId() > queryChain.getId()) {
                    queryChain.computeOverlaps(testChain, overlapAction);
                    ++this.nOverlaps;
                }
                if (!this.segInt.isDone()) continue;
                progress.done();
                return;
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new IllegalStateException("Canceled");
        }
        progress.done();
    }

    private void add(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            mc.setId(this.idCounter++);
            this.index.insert(mc.getEnvelope(), mc);
            this.monoChains.add(mc);
        }
    }

    public class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        private SegmentIntersector si = null;

        public SegmentOverlapAction(SegmentIntersector si) {
            this.si = si;
        }

        public void overlap(MonotoneChain mc1, int start1, MonotoneChain mc2, int start2) {
            SegmentString ss1 = (SegmentString)mc1.getContext();
            SegmentString ss2 = (SegmentString)mc2.getContext();
            this.si.processIntersections(ss1, start1, ss2, start2);
        }
    }
}

