/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class WKTFileReader {
    private File file;
    private WKTReader wktReader;
    private int count = 0;
    private int limit = -1;
    private int offset = 0;

    public WKTFileReader(File file, WKTReader wktReader) {
        this.file = file;
        this.wktReader = wktReader;
    }

    public WKTFileReader(String filename, WKTReader wktReader) {
        this(new File(filename), wktReader);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List read() throws IOException, ParseException {
        this.count = 0;
        FileReader fileReader = new FileReader(this.file);
        try {
            List list;
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                list = this.read(bufferedReader);
            }
            catch (Throwable throwable) {
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return list;
        }
        finally {
            fileReader.close();
        }
    }

    private List read(BufferedReader bufferedReader) throws IOException, ParseException {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        while (!this.isAtEndOfFile(bufferedReader) && !this.isAtLimit(geoms)) {
            Geometry g = this.wktReader.read(bufferedReader);
            if (this.count >= this.offset) {
                geoms.add(g);
            }
            ++this.count;
        }
        return geoms;
    }

    private boolean isAtLimit(List geoms) {
        if (this.limit < 0) {
            return false;
        }
        return geoms.size() >= this.limit;
    }

    private boolean isAtEndOfFile(BufferedReader bufferedReader) throws IOException {
        bufferedReader.mark(1000);
        StreamTokenizer tokenizer = new StreamTokenizer(bufferedReader);
        int type = tokenizer.nextToken();
        if (type == -1) {
            return true;
        }
        bufferedReader.reset();
        return false;
    }
}

