/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.AbstractSTRtree;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class STRtree
extends AbstractSTRtree
implements SpatialIndex {
    private Comparator xComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return STRtree.this.compareDoubles(STRtree.this.centreX((Envelope)((Boundable)o1).getBounds()), STRtree.this.centreX((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private Comparator yComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return STRtree.this.compareDoubles(STRtree.this.centreY((Envelope)((Boundable)o1).getBounds()), STRtree.this.centreY((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private AbstractSTRtree.IntersectsOp intersectsOp = new AbstractSTRtree.IntersectsOp(){

        public boolean intersects(Object aBounds, Object bBounds) {
            return ((Envelope)aBounds).intersects((Envelope)bBounds);
        }
    };
    private static final int DEFAULT_NODE_CAPACITY = 10;

    private double centreX(Envelope e) {
        return this.avg(e.getMinX(), e.getMaxX());
    }

    private double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    private double centreY(Envelope e) {
        return this.avg(e.getMinY(), e.getMaxY());
    }

    protected List createParentBoundables(List childBoundables, int newLevel) {
        Assert.isTrue(!childBoundables.isEmpty());
        int minLeafCount = (int)Math.ceil((double)childBoundables.size() / (double)this.getNodeCapacity());
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        Collections.sort(sortedChildBoundables, this.xComparator);
        List[] verticalSlices = this.verticalSlices(sortedChildBoundables, (int)Math.ceil(Math.sqrt(minLeafCount)));
        return this.createParentBoundablesFromVerticalSlices(verticalSlices, newLevel);
    }

    private List createParentBoundablesFromVerticalSlices(List[] verticalSlices, int newLevel) {
        Assert.isTrue(verticalSlices.length > 0);
        ArrayList parentBoundables = new ArrayList();
        int i = 0;
        while (i < verticalSlices.length) {
            parentBoundables.addAll(this.createParentBoundablesFromVerticalSlice(verticalSlices[i], newLevel));
            ++i;
        }
        return parentBoundables;
    }

    protected List createParentBoundablesFromVerticalSlice(List childBoundables, int newLevel) {
        return super.createParentBoundables(childBoundables, newLevel);
    }

    protected List[] verticalSlices(List childBoundables, int sliceCount) {
        int sliceCapacity = (int)Math.ceil((double)childBoundables.size() / (double)sliceCount);
        List[] slices = new List[sliceCount];
        Iterator i = childBoundables.iterator();
        int j = 0;
        while (j < sliceCount) {
            slices[j] = new ArrayList();
            int boundablesAddedToSlice = 0;
            while (i.hasNext() && boundablesAddedToSlice < sliceCapacity) {
                Boundable childBoundable = (Boundable)i.next();
                slices[j].add(childBoundable);
                ++boundablesAddedToSlice;
            }
            ++j;
        }
        return slices;
    }

    public STRtree() {
        this(10);
    }

    public STRtree(int nodeCapacity) {
        super(nodeCapacity);
    }

    protected AbstractNode createNode(int level) {
        return new AbstractNode(level){

            protected Object computeBounds() {
                Envelope bounds = null;
                for (Boundable childBoundable : this.getChildBoundables()) {
                    if (bounds == null) {
                        bounds = new Envelope((Envelope)childBoundable.getBounds());
                        continue;
                    }
                    bounds.expandToInclude((Envelope)childBoundable.getBounds());
                }
                return bounds;
            }
        };
    }

    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return this.intersectsOp;
    }

    public void insert(Envelope itemEnv, Object item) {
        if (itemEnv.isNull()) {
            return;
        }
        super.insert(itemEnv, item);
    }

    public List query(Envelope searchEnv) {
        return super.query(searchEnv);
    }

    public void query(Envelope searchEnv, ItemVisitor visitor) {
        super.query(searchEnv, visitor);
    }

    public boolean remove(Envelope itemEnv, Object item) {
        return super.remove(itemEnv, item);
    }

    public int size() {
        return super.size();
    }

    public int depth() {
        return super.depth();
    }

    protected Comparator getComparator() {
        return this.yComparator;
    }
}

