/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EdgeList {
    private List edges = new ArrayList();
    private SpatialIndex index = new Quadtree();

    public void add(Edge e) {
        this.edges.add(e);
        this.index.insert(e.getEnvelope(), e);
    }

    public void addAll(Collection edgeColl) {
        Iterator i = edgeColl.iterator();
        while (i.hasNext()) {
            this.add((Edge)i.next());
        }
    }

    public List getEdges() {
        return this.edges;
    }

    public Edge findEqualEdge(Edge e) {
        List testEdges = this.index.query(e.getEnvelope());
        for (Edge testEdge : testEdges) {
            if (!testEdge.equals(e)) continue;
            return testEdge;
        }
        return null;
    }

    public Iterator iterator() {
        return this.edges.iterator();
    }

    public Edge get(int i) {
        return (Edge)this.edges.get(i);
    }

    public int findEdgeIndex(Edge e) {
        int i = 0;
        while (i < this.edges.size()) {
            if (((Edge)this.edges.get(i)).equals(e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void print(PrintStream out) {
        out.print("MULTILINESTRING ( ");
        int j = 0;
        while (j < this.edges.size()) {
            Edge e = (Edge)this.edges.get(j);
            if (j > 0) {
                out.print(",");
            }
            out.print("(");
            Coordinate[] pts = e.getCoordinates();
            int i = 0;
            while (i < pts.length) {
                if (i > 0) {
                    out.print(",");
                }
                out.print(String.valueOf(pts[i].x) + " " + pts[i].y);
                ++i;
            }
            out.println(")");
            ++j;
        }
        out.print(")  ");
    }
}

