/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;

public class GeometryEditor {
    private GeometryFactory factory = null;

    public GeometryEditor() {
    }

    public GeometryEditor(GeometryFactory factory) {
        this.factory = factory;
    }

    public Geometry edit(Geometry geometry, GeometryEditorOperation operation) {
        if (geometry == null) {
            return null;
        }
        if (this.factory == null) {
            this.factory = geometry.getFactory();
        }
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry, operation);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry, operation);
        }
        if (geometry instanceof Point) {
            return operation.edit(geometry, this.factory);
        }
        if (geometry instanceof LineString) {
            return operation.edit(geometry, this.factory);
        }
        Assert.shouldNeverReachHere("Unsupported Geometry class: " + geometry.getClass().getName());
        return null;
    }

    private Polygon editPolygon(Polygon polygon, GeometryEditorOperation operation) {
        Polygon newPolygon = (Polygon)operation.edit(polygon, this.factory);
        if (newPolygon.isEmpty()) {
            return newPolygon;
        }
        LinearRing shell = (LinearRing)this.edit(newPolygon.getExteriorRing(), operation);
        if (shell.isEmpty()) {
            return this.factory.createPolygon(null, null);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        int i = 0;
        while (i < newPolygon.getNumInteriorRing()) {
            LinearRing hole = (LinearRing)this.edit(newPolygon.getInteriorRingN(i), operation);
            if (!hole.isEmpty()) {
                holes.add(hole);
            }
            ++i;
        }
        return this.factory.createPolygon(shell, holes.toArray(new LinearRing[0]));
    }

    private GeometryCollection editGeometryCollection(GeometryCollection collection, GeometryEditorOperation operation) {
        GeometryCollection newCollection = (GeometryCollection)operation.edit(collection, this.factory);
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        int i = 0;
        while (i < newCollection.getNumGeometries()) {
            Geometry geometry = this.edit(newCollection.getGeometryN(i), operation);
            if (!geometry.isEmpty()) {
                geometries.add(geometry);
            }
            ++i;
        }
        if (newCollection.getClass() == MultiPoint.class) {
            return this.factory.createMultiPoint(geometries.toArray(new Point[0]));
        }
        if (newCollection.getClass() == MultiLineString.class) {
            return this.factory.createMultiLineString(geometries.toArray(new LineString[0]));
        }
        if (newCollection.getClass() == MultiPolygon.class) {
            return this.factory.createMultiPolygon(geometries.toArray(new Polygon[0]));
        }
        return this.factory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public static abstract class CoordinateOperation
    implements GeometryEditorOperation {
        public final Geometry edit(Geometry geometry, GeometryFactory factory) {
            if (geometry instanceof LinearRing) {
                return factory.createLinearRing(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof LineString) {
                return factory.createLineString(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof Point) {
                Coordinate[] newCoordinates = this.edit(geometry.getCoordinates(), geometry);
                return factory.createPoint(newCoordinates.length > 0 ? newCoordinates[0] : null);
            }
            return geometry;
        }

        public abstract Coordinate[] edit(Coordinate[] var1, Geometry var2);
    }

    public static interface GeometryEditorOperation {
        public Geometry edit(Geometry var1, GeometryFactory var2);
    }
}

