/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.lang.ref.SoftReference;

public abstract class PackedCoordinateSequence
implements CoordinateSequence {
    protected int dimension;
    protected SoftReference coordRef;

    public int getDimension() {
        return this.dimension;
    }

    public Coordinate getCoordinate(int i) {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords[i];
        }
        return this.getCoordinateInternal(i);
    }

    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinateInternal(i);
    }

    public void getCoordinate(int i, Coordinate coord) {
        coord.x = this.getOrdinate(i, 0);
        coord.y = this.getOrdinate(i, 1);
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords;
        }
        coords = new Coordinate[this.size()];
        int i = 0;
        while (i < coords.length) {
            coords[i] = this.getCoordinateInternal(i);
            ++i;
        }
        this.coordRef = new SoftReference<Coordinate[]>(coords);
        return coords;
    }

    private Coordinate[] getCachedCoords() {
        if (this.coordRef != null) {
            Coordinate[] coords = (Coordinate[])this.coordRef.get();
            if (coords != null) {
                return coords;
            }
            this.coordRef = null;
            return null;
        }
        return null;
    }

    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    public abstract double getOrdinate(int var1, int var2);

    public void setX(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 0, value);
    }

    public void setY(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 1, value);
    }

    protected abstract Coordinate getCoordinateInternal(int var1);

    public abstract Object clone();

    public abstract void setOrdinate(int var1, int var2, double var3);

    public static class Double
    extends PackedCoordinateSequence {
        double[] coords;

        public Double(double[] coords, int dimensions) {
            if (dimensions < 2) {
                throw new IllegalArgumentException("Must have at least 2 dimensions");
            }
            if (coords.length % dimensions != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.dimension = dimensions;
            this.coords = coords;
        }

        public Double(float[] coordinates, int dimensions) {
            this.coords = new double[coordinates.length];
            this.dimension = dimensions;
            int i = 0;
            while (i < coordinates.length) {
                this.coords[i] = coordinates[i];
                ++i;
            }
        }

        public Double(Coordinate[] coordinates, int dimension) {
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.dimension = dimension;
            this.coords = new double[coordinates.length * this.dimension];
            int i = 0;
            while (i < coordinates.length) {
                this.coords[i * this.dimension] = coordinates[i].x;
                if (this.dimension >= 2) {
                    this.coords[i * this.dimension + 1] = coordinates[i].y;
                }
                if (this.dimension >= 3) {
                    this.coords[i * this.dimension + 2] = coordinates[i].z;
                }
                ++i;
            }
        }

        public Double(Coordinate[] coordinates) {
            this(coordinates, 3);
        }

        public Double(int size, int dimension) {
            this.dimension = dimension;
            this.coords = new double[size * this.dimension];
        }

        public Coordinate getCoordinateInternal(int i) {
            double x = this.coords[i * this.dimension];
            double y = this.coords[i * this.dimension + 1];
            double z = this.dimension == 2 ? 0.0 : this.coords[i * this.dimension + 2];
            return new Coordinate(x, y, z);
        }

        public int size() {
            return this.coords.length / this.dimension;
        }

        public Object clone() {
            double[] clone = new double[this.coords.length];
            System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
            return new Double(clone, this.dimension);
        }

        public double getOrdinate(int index, int ordinate) {
            return this.coords[index * this.dimension + ordinate];
        }

        public void setOrdinate(int index, int ordinate, double value) {
            this.coordRef = null;
            this.coords[index * this.dimension + ordinate] = value;
        }

        public Envelope expandEnvelope(Envelope env) {
            int i = 0;
            while (i < this.coords.length) {
                env.expandToInclude(this.coords[i], this.coords[i + 1]);
                i += this.dimension;
            }
            return env;
        }
    }

    public static class Float
    extends PackedCoordinateSequence {
        float[] coords;

        public Float(float[] coords, int dimensions) {
            if (dimensions < 2) {
                throw new IllegalArgumentException("Must have at least 2 dimensions");
            }
            if (coords.length % dimensions != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.dimension = dimensions;
            this.coords = coords;
        }

        public Float(double[] coordinates, int dimensions) {
            this.coords = new float[coordinates.length];
            this.dimension = dimensions;
            int i = 0;
            while (i < coordinates.length) {
                this.coords[i] = (float)coordinates[i];
                ++i;
            }
        }

        public Float(Coordinate[] coordinates, int dimension) {
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.dimension = dimension;
            this.coords = new float[coordinates.length * this.dimension];
            int i = 0;
            while (i < coordinates.length) {
                this.coords[i * this.dimension] = (float)coordinates[i].x;
                if (this.dimension >= 2) {
                    this.coords[i * this.dimension + 1] = (float)coordinates[i].y;
                }
                if (this.dimension >= 3) {
                    this.coords[i * this.dimension + 2] = (float)coordinates[i].z;
                }
                ++i;
            }
        }

        public Float(int size, int dimension) {
            this.dimension = dimension;
            this.coords = new float[size * this.dimension];
        }

        public Coordinate getCoordinateInternal(int i) {
            double x = this.coords[i * this.dimension];
            double y = this.coords[i * this.dimension + 1];
            double z = this.dimension == 2 ? 0.0 : (double)this.coords[i * this.dimension + 2];
            return new Coordinate(x, y, z);
        }

        public int size() {
            return this.coords.length / this.dimension;
        }

        public Object clone() {
            float[] clone = new float[this.coords.length];
            System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
            return new Float(clone, this.dimension);
        }

        public double getOrdinate(int index, int ordinate) {
            return this.coords[index * this.dimension + ordinate];
        }

        public void setOrdinate(int index, int ordinate, double value) {
            this.coordRef = null;
            this.coords[index * this.dimension + ordinate] = (float)value;
        }

        public Envelope expandEnvelope(Envelope env) {
            int i = 0;
            while (i < this.coords.length) {
                env.expandToInclude(this.coords[i], this.coords[i + 1]);
                i += this.dimension;
            }
            return env;
        }
    }
}

