/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.Arrays;

public class Polygon
extends Geometry
implements Polygonal {
    private static final long serialVersionUID = -3494792200821764533L;
    protected LinearRing shell = null;
    protected LinearRing[] holes;

    public Polygon(LinearRing shell, PrecisionModel precisionModel, int SRID) {
        this(shell, new LinearRing[0], new GeometryFactory(precisionModel, SRID));
    }

    public Polygon(LinearRing shell, LinearRing[] holes, PrecisionModel precisionModel, int SRID) {
        this(shell, holes, new GeometryFactory(precisionModel, SRID));
    }

    public Polygon(LinearRing shell, LinearRing[] holes, GeometryFactory factory) {
        super(factory);
        if (shell == null) {
            shell = this.getFactory().createLinearRing((CoordinateSequence)null);
        }
        if (holes == null) {
            holes = new LinearRing[]{};
        }
        if (Polygon.hasNullElements(holes)) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (shell.isEmpty() && Polygon.hasNonEmptyElements(holes)) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
        this.shell = shell;
        this.holes = holes;
    }

    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        Coordinate[] shellCoordinates = this.shell.getCoordinates();
        int x = 0;
        while (x < shellCoordinates.length) {
            coordinates[++k] = shellCoordinates[x];
            ++x;
        }
        int i = 0;
        while (i < this.holes.length) {
            Coordinate[] childCoordinates = this.holes[i].getCoordinates();
            int j = 0;
            while (j < childCoordinates.length) {
                coordinates[++k] = childCoordinates[j];
                ++j;
            }
            ++i;
        }
        return coordinates;
    }

    public int getNumPoints() {
        int numPoints = this.shell.getNumPoints();
        int i = 0;
        while (i < this.holes.length) {
            numPoints += this.holes[i].getNumPoints();
            ++i;
        }
        return numPoints;
    }

    public int getDimension() {
        return 2;
    }

    public int getBoundaryDimension() {
        return 1;
    }

    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isRectangle() {
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        if (this.shell == null) {
            return false;
        }
        if (this.shell.getNumPoints() != 5) {
            return false;
        }
        CoordinateSequence seq = this.shell.getCoordinateSequence();
        Envelope env = this.getEnvelopeInternal();
        int i = 0;
        while (i < 5) {
            double x = seq.getX(i);
            if (x != env.getMinX() && x != env.getMaxX()) {
                return false;
            }
            double y = seq.getY(i);
            if (y != env.getMinY() && y != env.getMaxY()) {
                return false;
            }
            ++i;
        }
        double prevX = seq.getX(0);
        double prevY = seq.getY(0);
        int i2 = 1;
        while (i2 <= 4) {
            boolean yChanged;
            double x = seq.getX(i2);
            double y = seq.getY(i2);
            boolean xChanged = x != prevX;
            boolean bl = yChanged = y != prevY;
            if (xChanged == yChanged) {
                return false;
            }
            prevX = x;
            prevY = y;
            ++i2;
        }
        return true;
    }

    public LineString getExteriorRing() {
        return this.shell;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    public LineString getInteriorRingN(int n) {
        return this.holes[n];
    }

    public String getGeometryType() {
        return "Polygon";
    }

    public double getArea() {
        double area = 0.0;
        area += Math.abs(CGAlgorithms.signedArea(this.shell.getCoordinates()));
        int i = 0;
        while (i < this.holes.length) {
            area -= Math.abs(CGAlgorithms.signedArea(this.holes[i].getCoordinates()));
            ++i;
        }
        return area;
    }

    public double getLength() {
        double len = 0.0;
        len += this.shell.getLength();
        int i = 0;
        while (i < this.holes.length) {
            len += this.holes[i].getLength();
            ++i;
        }
        return len;
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        LineString[] rings = new LinearRing[this.holes.length + 1];
        rings[0] = this.shell;
        int i = 0;
        while (i < this.holes.length) {
            rings[i + 1] = this.holes[i];
            ++i;
        }
        if (rings.length <= 1) {
            return this.getFactory().createLinearRing(rings[0].getCoordinateSequence());
        }
        return this.getFactory().createMultiLineString(rings);
    }

    protected Envelope computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        Polygon otherPolygon = (Polygon)other;
        LinearRing thisShell = this.shell;
        LinearRing otherPolygonShell = otherPolygon.shell;
        if (!((Geometry)thisShell).equalsExact(otherPolygonShell, tolerance)) {
            return false;
        }
        if (this.holes.length != otherPolygon.holes.length) {
            return false;
        }
        if (this.holes.length != otherPolygon.holes.length) {
            return false;
        }
        int i = 0;
        while (i < this.holes.length) {
            if (!((Geometry)this.holes[i]).equalsExact(otherPolygon.holes[i], tolerance)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void apply(CoordinateFilter filter) {
        this.shell.apply(filter);
        int i = 0;
        while (i < this.holes.length) {
            this.holes[i].apply(filter);
            ++i;
        }
    }

    public void apply(CoordinateSequenceFilter filter) {
        this.shell.apply(filter);
        if (!filter.isDone()) {
            int i = 0;
            while (i < this.holes.length) {
                this.holes[i].apply(filter);
                if (filter.isDone()) break;
                ++i;
            }
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        this.shell.apply(filter);
        int i = 0;
        while (i < this.holes.length) {
            this.holes[i].apply(filter);
            ++i;
        }
    }

    public Object clone() {
        Polygon poly = (Polygon)super.clone();
        poly.shell = (LinearRing)this.shell.clone();
        poly.holes = new LinearRing[this.holes.length];
        int i = 0;
        while (i < this.holes.length) {
            poly.holes[i] = (LinearRing)this.holes[i].clone();
            ++i;
        }
        return poly;
    }

    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    public void normalize() {
        this.normalize(this.shell, true);
        int i = 0;
        while (i < this.holes.length) {
            this.normalize(this.holes[i], false);
            ++i;
        }
        Arrays.sort(this.holes);
    }

    protected int compareToSameClass(Object o) {
        LinearRing thisShell = this.shell;
        LinearRing otherShell = ((Polygon)o).shell;
        return thisShell.compareToSameClass(otherShell);
    }

    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell;
        LinearRing otherShell = poly.shell;
        int shellComp = thisShell.compareToSameClass(otherShell, comp);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = poly.getNumInteriorRing();
        int i = 0;
        while (i < nHole1 && i < nHole2) {
            LinearRing otherHole;
            LinearRing thisHole = (LinearRing)this.getInteriorRingN(i);
            int holeComp = thisHole.compareToSameClass(otherHole = (LinearRing)poly.getInteriorRingN(i), comp);
            if (holeComp != 0) {
                return holeComp;
            }
            ++i;
        }
        if (i < nHole1) {
            return 1;
        }
        if (i < nHole2) {
            return -1;
        }
        return 0;
    }

    private void normalize(LinearRing ring, boolean clockwise) {
        if (ring.isEmpty()) {
            return;
        }
        Coordinate[] uniqueCoordinates = new Coordinate[ring.getCoordinates().length - 1];
        System.arraycopy(ring.getCoordinates(), 0, uniqueCoordinates, 0, uniqueCoordinates.length);
        Coordinate minCoordinate = CoordinateArrays.minCoordinate(ring.getCoordinates());
        CoordinateArrays.scroll(uniqueCoordinates, minCoordinate);
        System.arraycopy(uniqueCoordinates, 0, ring.getCoordinates(), 0, uniqueCoordinates.length);
        ring.getCoordinates()[uniqueCoordinates.length] = uniqueCoordinates[0];
        if (CGAlgorithms.isCCW(ring.getCoordinates()) == clockwise) {
            CoordinateArrays.reverse(ring.getCoordinates());
        }
    }
}

