/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.BoundaryOp;

public class MultiLineString
extends GeometryCollection
implements Lineal {
    private static final long serialVersionUID = 8166665132445433741L;

    public MultiLineString(LineString[] lineStrings, PrecisionModel precisionModel, int SRID) {
        super(lineStrings, new GeometryFactory(precisionModel, SRID));
    }

    public MultiLineString(LineString[] lineStrings, GeometryFactory factory) {
        super(lineStrings, factory);
    }

    public int getDimension() {
        return 1;
    }

    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.geometries.length) {
            if (!((LineString)this.geometries[i]).isClosed()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    public MultiLineString reverse() {
        int nLines = this.geometries.length;
        LineString[] revLines = new LineString[nLines];
        int i = 0;
        while (i < this.geometries.length) {
            revLines[nLines - 1 - i] = ((LineString)this.geometries[i]).reverse();
            ++i;
        }
        return this.getFactory().createMultiLineString(revLines);
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }
}

