/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2.thread;

import com.creawor.meip2.Server;
import com.creawor.meip2.beans.SessionBean;
import com.creawor.meip2.beans.SmReceived;
import com.creawor.meip2.client.MeipClientException;
import com.creawor.meip2.client.MeipConnectionFactory;
import com.creawor.meip2.client.MeipException;
import com.creawor.meip2.client.MeipInfoProxyAxis;
import com.creawor.meip2.db.SmDatabase;
import com.creawor.meip2.extent.ExtentManager;
import com.creawor.meip2.main.Main;
import com.haibo.log.TraceFactory;
import com.haibo.thread.ThreadBase;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;

public class ReceiveSmsThread
extends ThreadBase {
    public static int READ_SM_COUNT = 100;

    public ReceiveSmsThread() {
    }

    public ReceiveSmsThread(Runnable target) {
        super(target);
    }

    public ReceiveSmsThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public void run() {
        MeipInfoProxyAxis meipConn = null;
        try {
            meipConn = MeipConnectionFactory.getConnection(Main.getCfg().readString("COMMUNICATION_METHOD"));
        }
        catch (MeipClientException e) {
            TraceFactory.getTrace().trace("ReceiveSmsThread " + e);
        }
        String eid = null;
        boolean bThread = "thread".equalsIgnoreCase(System.getProperty("receive"));
        if (!Main.getCfg().readBoolean("RECEIVE_SMS_ENABLE")) {
            return;
        }
        int time = Main.getCfg().readInt("READ_SMS_INTERVAL", 5000);
        while (!this.bTerminal) {
            try {
                if (time < 5000) {
                    time = 5000;
                }
                this.sleep(time, 1000);
            }
            catch (InterruptedException e) {
                TraceFactory.getTrace().trace("ReceiveSms sleep Exception:" + e.getMessage(), 8);
                TraceFactory.getTrace().trace((Exception)e, 8);
            }
            eid = Server.getEid();
            try {
                this.receive(meipConn, eid);
            }
            catch (Exception e) {
                TraceFactory.getTrace().trace("ReceiveSms receive Exception:" + e.getMessage(), 8);
                TraceFactory.getTrace().trace(e, 8);
            }
        }
        TraceFactory.getTrace().trace("ReceiveSms abnormal exit ************************", 2);
    }

    private void receive(MeipInfoProxyAxis conn, String eid) {
        Vector<SmReceived> vtsms = null;
        String[] msg = null;
        String[] msgPreSid = null;
        ArrayList<String> msgList = new ArrayList<String>();
        try {
            int i;
            String sessionId = null;
            List sidList = Server.getAllSessionId();
            if (sidList != null && !sidList.isEmpty()) {
                int t = 0;
                while (t < sidList.size()) {
                    sessionId = (String)sidList.get(t);
                    if (sessionId != null && (msgPreSid = conn.receive(sessionId, Main.getCfg().readString("RECEIVE_SMS_FILTER", "*"))) != null) {
                        i = 0;
                        while (i < msgPreSid.length) {
                            msgList.add(msgPreSid[i]);
                            ++i;
                        }
                    }
                    ++t;
                }
                sidList.clear();
                sidList = null;
            }
            if (msgList != null && !msgList.isEmpty()) {
                msg = new String[msgList.size()];
                int s = 0;
                while (s < msgList.size()) {
                    msg[s] = (String)msgList.get(s);
                    ++s;
                }
                msgList.clear();
            }
            if (vtsms == null) {
                vtsms = new Vector<SmReceived>();
            } else {
                vtsms.clear();
            }
            if (msg != null) {
                SmReceived smrd = null;
                i = 0;
                while (i < msg.length) {
                    smrd = new SmReceived();
                    if (smrd != null) {
                        String rtncontent = msg[i];
                        System.out.println("recieve.content=====" + rtncontent);
                        if (rtncontent.indexOf("#") > 0) {
                            Calendar cal;
                            int pos = rtncontent.indexOf("#");
                            int pos2 = rtncontent.indexOf("#", pos + 1);
                            smrd.mobile = rtncontent.substring(0, pos);
                            smrd.content = rtncontent.endsWith("##") ? "" : (rtncontent.endsWith("#") ? rtncontent.substring(pos2 + 1, rtncontent.length() - 1) : (rtncontent.indexOf("##") > 0 ? rtncontent.substring(pos2 + 1) : rtncontent.substring(pos2 + 1)));
                            smrd.recetime = cal = Calendar.getInstance();
                            smrd.eid = eid;
                            vtsms.addElement(smrd);
                        }
                    }
                    ++i;
                }
            }
            if (vtsms != null && vtsms.size() > 0) {
                System.out.println("vtsms.size():" + vtsms.size());
                ExtentManager.getInstance().receiveSms((Vector)vtsms.clone());
                SmDatabase.AddSmReceived(vtsms);
                TraceFactory.getTrace().trace("ReceiveSms[" + eid + "] received " + vtsms.size() + " short message!", 2);
            }
        }
        catch (SQLException e) {
            TraceFactory.getTrace().trace("ReceiveSms[" + eid + "] \uff0cException\uff1a" + e, 8);
            TraceFactory.getTrace().trace((Exception)e, 8);
        }
        catch (MeipException e) {
            if (e.toString().equals(String.valueOf(602)) || e.toString().trim().equals(String.valueOf(601))) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException sidList) {
                    // empty catch block
                }
                SessionBean sbean = Server.getSessionBean();
                Server.login();
            }
            TraceFactory.getTrace().trace("ReceiveSms[" + eid + "] Exception\uff1a" + e.toString(), 8);
            TraceFactory.getTrace().trace((Exception)e, 8);
        }
        catch (RemoteException e) {
            TraceFactory.getTrace().trace("ReceiveSms[" + eid + "] Exception\uff1a" + e, 8);
            TraceFactory.getTrace().trace((Exception)e, 8);
        }
        catch (Exception e) {
            TraceFactory.getTrace().trace("ReceiveSms[" + eid + "] \uff0cException\uff1a" + e, 8);
            TraceFactory.getTrace().trace(e, 8);
        }
    }
}

