/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2.http;

import com.creawor.meip2.http.DataSourceObject;
import com.creawor.meip2.http.IHTMLChecker;
import java.util.Hashtable;

public class HttpMonitorManager {
    private static Hashtable _handlers = null;

    static {
        _handlers = new Hashtable(1, 0.75f);
    }

    public static void installHandler(DataSourceObject dso, IHTMLChecker idh) {
        Hashtable hashtable = _handlers;
        synchronized (hashtable) {
            if (idh == null || dso == null) {
                return;
            }
            _handlers.put(dso, idh);
        }
    }

    public static void uninstallHandler(DataSourceObject dso) {
        if (dso == null) {
            return;
        }
        Hashtable hashtable = _handlers;
        synchronized (hashtable) {
            _handlers.remove(dso);
        }
    }

    public static IHTMLChecker getHandler(DataSourceObject dso) {
        return (IHTMLChecker)HttpMonitorManager.getHandlers().get(dso);
    }

    public static Hashtable getHandlers() {
        return _handlers;
    }
}

